<?php
session_start();
include 'conexao.php';

$mensagem = '';
$erro = '';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $agente = $_POST['agente'] ?? '';
    $senha_antiga = $_POST['senha_antiga'] ?? '';
    $nova_senha = $_POST['nova_senha'] ?? '';

    if ($agente && $senha_antiga && $nova_senha) {
        $sql = "SELECT * FROM usuarios WHERE agente = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $agente);
        $stmt->execute();
        $res = $stmt->get_result();

        if ($res && $res->num_rows === 1) {
            $usuario = $res->fetch_assoc();
            
            if (password_verify($senha_antiga, $usuario['senha'])) {
                $nova_senha_hash = password_hash($nova_senha, PASSWORD_DEFAULT);
                $update = $conn->prepare("UPDATE usuarios SET senha = ? WHERE agente = ?");
                $update->bind_param("ss", $nova_senha_hash, $agente);
                if ($update->execute()) {
                    $mensagem = "Senha alterada com sucesso!";
                } else {
                    $erro = "Erro ao atualizar senha.";
                }
            } else {
                $erro = "Senha antiga incorreta.";
            }
        } else {
            $erro = "Número de agente não encontrado.";
        }
    } else {
        $erro = "Preencha todos os campos.";
    }
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Alterar Senha | SISMAG</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(135deg, #0f2027, #203a43, #2c5364);
      color: white;
      height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      font-family: 'Segoe UI', sans-serif;
    }

    .container {
      background: rgba(255,255,255,0.05);
      backdrop-filter: blur(12px);
      padding: 40px 30px;
      border-radius: 15px;
      box-shadow: 0 8px 32px rgba(0,0,0,0.3);
      width: 90%;
      max-width: 450px;
    }

    h2 {
      text-align: center;
      margin-bottom: 20px;
      color: #00ffff;
    }

    label {
      display: block;
      margin-bottom: 5px;
      font-weight: bold;
    }

    input {
      width: 100%;
      padding: 10px;
      margin-bottom: 15px;
      border-radius: 8px;
      border: none;
      background-color: rgba(255, 255, 255, 0.2);
      color: white;
    }

    .btn {
      background-color: #00bcd4;
      color: white;
      width: 100%;
      padding: 12px;
      border: none;
      border-radius: 8px;
      font-weight: bold;
      cursor: pointer;
      transition: background 0.3s;
    }

    .btn:hover {
      background-color: #0097a7;
    }

    .mensagem {
      text-align: center;
      margin-top: 15px;
      font-weight: bold;
      color: lightgreen;
    }

    .erro {
      text-align: center;
      margin-top: 15px;
      font-weight: bold;
      color: #ff6666;
    }

    a {
      display: block;
      text-align: center;
      margin-top: 20px;
      color: #00ffff;
      text-decoration: none;
    }
  </style>
</head>
<body>
  <div class="container">
    <h2><i class="fas fa-lock"></i> Alterar Senha</h2>
    <form method="post">
      <label for="agente">Nº de Agente:</label>
      <input type="text" name="agente" id="agente" required>

      <label for="senha_antiga">Senha Antiga:</label>
      <input type="password" name="senha_antiga" id="senha_antiga" required>

      <label for="nova_senha">Nova Senha:</label>
      <input type="password" name="nova_senha" id="nova_senha" required>

      <button type="submit" class="btn">Atualizar Senha</button>
    </form>

    <?php if ($mensagem): ?>
      <div class="mensagem"><?= $mensagem ?></div>
    <?php endif; ?>
    <?php if ($erro): ?>
      <div class="erro"><?= $erro ?></div>
    <?php endif; ?>

    <a href="login.php"><i class="fas fa-arrow-left"></i> Voltar ao Login</a>
  </div>
</body>
</html>
