<?php
session_start();
include 'conexao.php';

if (!isset($_SESSION['aluno'])) {
    header("Location: login_aluno.php");
    exit;
}
$aluno = $_SESSION['aluno'];
$erro = $mensagem = '';

if ($_SERVER['REQUEST_METHOD']=='POST') {
    $senha_atual = $_POST['senha_atual'] ?? '';
    $senha_nova = $_POST['senha_nova'] ?? '';

    // Busca senha atual no banco
    $stmt = $conn->prepare("SELECT senha FROM alunos WHERE id=?");
    $stmt->bind_param("i", $aluno['id']);
    $stmt->execute();
    $res = $stmt->get_result()->fetch_assoc();
    $senha_bd = $res['senha'];

    // Caso senha personalizada exista
    if ($senha_bd) {
        if ($senha_atual !== $senha_bd) {
            $erro = "Senha atual incorreta.";
        }
    } else {
        // caso use número de ordem como senha
        if ($senha_atual != $aluno['ordem']) {
            $erro = "Senha atual incorreta.";
        }
    }

    if (!$erro) {
        $upd = $conn->prepare("UPDATE alunos SET senha=? WHERE id=?");
        $upd->bind_param("si",$senha_nova, $aluno['id']);
        if ($upd->execute()) {
            $mensagem = "Senha atualizada com sucesso!";
        } else {
            $erro = "Erro ao atualizar senha.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8"><title>Alterar Senha do Aluno</title>
  <meta name="viewport" content="width=device-width,initial-scale=1.0">
  <style>
    body{font-family:Arial,sans-serif;background:#f2f2f2;padding:20px;}
    .box{background:white;padding:20px;border-radius:8px;max-width:400px;margin:50px auto;}
    input, button {width:100%;padding:10px;margin-bottom:15px;border-radius:5px;border:1px solid #ccc;}
    button {background:#003366;color:white;border:none;}
    .msg {text-align:center;padding:10px;margin-bottom:15px;}
    .msg.ok{color:green;} .msg.err{color:red;}
    a{display:block;text-align:center;color:#003366;text-decoration:none;margin-top:10px;}
  </style>
</head>
<body>
  <div class="box">
    <h3>Olá, <?= htmlspecialchars($aluno['nome']) ?></h3>
    <?php if ($erro): ?><div class="msg err"><?= $erro ?></div><?php endif; ?>
    <?php if ($mensagem): ?><div class="msg ok"><?= $mensagem ?></div><?php endif; ?>
    <form method="post">
      <input type="password" name="senha_atual" placeholder="Senha atual" required>
      <input type="password" name="senha_nova" placeholder="Nova senha" required>
      <button type="submit">Alterar Senha</button>
    </form>
    <a href="painel_aluno.php">Voltar ao painel</a>
  </div>
</body>
</html>

