
<?php
session_start();
include 'conexao.php';

if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'PROFESSOR') {
    header("Location: login.php");
    exit;
}

$mensagem = "";
$erro = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $id = $_SESSION['usuario']['id'];
    $senha_actual = $_POST['senha_actual'];
    $nova_senha = $_POST['nova_senha'];
    $confirmar_senha = $_POST['confirmar_senha'];

    if (empty($senha_actual) || empty($nova_senha) || empty($confirmar_senha)) {
        $erro = "Preencha todos os campos.";
    } else {
        $stmt = $conn->prepare("SELECT senha FROM usuarios WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $resultado = $stmt->get_result();
        $usuario = $resultado->fetch_assoc();

        if (!password_verify($senha_actual, $usuario['senha'])) {
            $erro = "Senha actual incorreta.";
        } elseif ($nova_senha !== $confirmar_senha) {
            $erro = "As novas senhas não coincidem.";
        } else {
            $nova_senha_cripto = password_hash($nova_senha, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("UPDATE usuarios SET senha = ? WHERE id = ?");
            $stmt->bind_param("si", $nova_senha_cripto, $id);
            $stmt->execute();

            $mensagem = "Senha alterada com sucesso!";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Alterar Senha</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {font-family: Arial; background: #f4f6f9;}
    .container {
      width: 400px;
      margin: 100px auto;
      background: white;
      border-radius: 10px;
      padding: 30px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    input[type=password], button {
      width: 100%; padding: 10px; margin: 10px 0;
      border-radius: 5px; border: 1px solid #ccc;
    }
    button {
      background: #007bff; color: white; border: none; font-weight: bold;
    }
    .erro {color: red;}
    .sucesso {color: green;}
  </style>
</head>
<body>

<div class="container">
  <h3>🔐 Alterar Senha</h3>

  <?php if ($erro): ?>
    <p class="erro"><?= $erro ?></p>
  <?php elseif ($mensagem): ?>
    <p class="sucesso"><?= $mensagem ?></p>
  <?php endif; ?>

  <form method="POST">
    <input type="password" name="senha_actual" placeholder="Senha actual" required>
    <input type="password" name="nova_senha" placeholder="Nova senha" required>
    <input type="password" name="confirmar_senha" placeholder="Confirmar nova senha" required>
    <button type="submit">Salvar Alterações</button>
    
<ul>
        <li onclick="window.location.href='painel_professor1.php'"><i class="fas fa-home"></i> Voltar</li>
       
    </ul>
  </form>

   


</div>

</body>
</html>



