<?php
session_start();
include 'conexao.php';

// Restringir o acesso apenas ao Diretor Pedagógico
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'SUBDIRECÇÃO PEDAGÓGICA') {
    header("Location: login.php");
    exit;
}

$mensagem = '';
$tipo_mensagem = '';
$ano_lectivo_atual = '2025/2026'; // Defina o ano letivo atual

// Processar o fechamento do trimestre
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $turma_id_selecionada = (int)($_POST['turma_id'] ?? 0);
    $trimestre_selecionado = (int)($_POST['trimestre'] ?? 0);

    if ($turma_id_selecionada > 0 && $trimestre_selecionado > 0) {
        try {
            $conn->begin_transaction();

            // Buscar todas as disciplinas da turma atribuídas para o ano letivo atual
            $stmt_disciplinas = $conn->prepare("SELECT disciplina_id FROM atribuicoes WHERE turma_id = ? AND ano_lectivo = ?");
            if (!$stmt_disciplinas) {
                throw new Exception("Erro na preparação da consulta de disciplinas: " . $conn->error);
            }
            $stmt_disciplinas->bind_param("is", $turma_id_selecionada, $ano_lectivo_atual);
            $stmt_disciplinas->execute();
            $disciplinas = $stmt_disciplinas->get_result()->fetch_all(MYSQLI_ASSOC);
            $stmt_disciplinas->close();

            if (empty($disciplinas)) {
                throw new Exception("Nenhuma disciplina encontrada para a turma selecionada no ano letivo {$ano_lectivo_atual}.");
            }

            foreach ($disciplinas as $disciplina) {
                $disciplina_id = $disciplina['disciplina_id'];

                // Verificar se o fechamento já existe para evitar duplicatas
                $stmt_check_fecho = $conn->prepare("SELECT COUNT(*) FROM fecho_trimestre WHERE turma_id = ? AND disciplina_id = ? AND ano_lectivo = ? AND trimestre = ?");
                if (!$stmt_check_fecho) {
                    throw new Exception("Erro na preparação da verificação de fecho: " . $conn->error);
                }
                $stmt_check_fecho->bind_param("iisi", $turma_id_selecionada, $disciplina_id, $ano_lectivo_atual, $trimestre_selecionado);
                $stmt_check_fecho->execute();
                $count_fecho = $stmt_check_fecho->get_result()->fetch_row()[0];
                $stmt_check_fecho->close();

                if ($count_fecho == 0) {
                    // Inserir o registro de fechamento para cada disciplina
                    $stmt_fecho = $conn->prepare("INSERT INTO fecho_trimestre (turma_id, disciplina_id, ano_lectivo, trimestre) VALUES (?, ?, ?, ?)");
                    if (!$stmt_fecho) {
                        throw new Exception("Erro na preparação da inserção de fecho: " . $conn->error);
                    }
                    $stmt_fecho->bind_param("iisi", $turma_id_selecionada, $disciplina_id, $ano_lectivo_atual, $trimestre_selecionado);
                    $stmt_fecho->execute();
                    $stmt_fecho->close();
                }
            }

            $conn->commit();
            $mensagem = "Trimestre {$trimestre_selecionado} fechado com sucesso para a turma! As notas não podem mais ser alteradas.";
            $tipo_mensagem = 'success';
        } catch (Exception $e) {
            $conn->rollback();
            $mensagem = "Erro ao fechar o trimestre: " . $e->getMessage();
            $tipo_mensagem = 'error';
        }
    } else {
        $mensagem = "Por favor, selecione uma turma e um trimestre válidos.";
        $tipo_mensagem = 'error';
    }
}

// Buscar turmas para o select com classe e curso
$turmas = $conn->query("SELECT id, nome, classe, curso FROM turmas ORDER BY nome")->fetch_all(MYSQLI_ASSOC);

?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Fechar Trimestre Geral</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background-color: #f4f7f9; }
        .container { max-width: 600px; margin: auto; padding: 20px; border: 1px solid #e0e6ed; border-radius: 8px; background-color: #ffffff; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        h2 { text-align: center; color: #333; margin-bottom: 20px; }
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; font-weight: bold; color: #555; }
        select, button { width: 100%; padding: 10px; box-sizing: border-box; border-radius: 4px; }
        select { border: 1px solid #ccc; }
        button { background-color: #007bff; color: white; border: none; cursor: pointer; font-size: 16px; font-weight: bold; }
        button:hover { background-color: #0056b3; }
        .alert-message { margin-bottom: 15px; padding: 12px; border-radius: 4px; font-weight: bold; }
        .alert-message.success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .alert-message.error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .back-link { display: block; text-align: center; margin-top: 20px; color: #007bff; text-decoration: none; }
        .back-link:hover { text-decoration: underline; }
    </style>
</head>
<body>

<div class="container">
    <h2>Fecho de Trimestre por Turma</h2>
    <?php if (!empty($mensagem)): ?>
        <div class="alert-message <?= htmlspecialchars($tipo_mensagem) ?>">
            <?= htmlspecialchars($mensagem) ?>
        </div>
    <?php endif; ?>
    <form method="POST">
        <div class="form-group">
            <label for="turma_id">Selecionar Turma:</label>
            <select name="turma_id" id="turma_id" required>
                <option value="">-- Selecione uma turma --</option>
                <?php foreach ($turmas as $turma): ?>
                    <option value="<?= htmlspecialchars($turma['id']) ?>">
                        <?= htmlspecialchars($turma['classe'] . "ª - " . $turma['nome'] . " - " . $turma['curso']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label for="trimestre">Selecionar Trimestre:</label>
            <select name="trimestre" id="trimestre" required>
                <option value="">-- Selecione um trimestre --</option>
                <option value="1">1º Trimestre</option>
                <option value="2">2º Trimestre</option>
                <option value="3">3º Trimestre</option>
            </select>
        </div>
        <button type="submit">Fechar Trimestre</button>
    </form>
    <a href="painel_subpedagogico.php" class="back-link">Voltar ao Painel</a>
</div>

</body>
</html>