<?php
include 'conexao.php';
session_start();

// Buscar dados
$professores = $conn->query("SELECT id, nome FROM usuarios WHERE perfil = 'Professor' ORDER BY nome ASC");


$disciplinas = $conn->query("SELECT id, nome FROM disciplinas ORDER BY nome ASC");
$turmas = $conn->query("SELECT id, nome FROM turmas ORDER BY nome ASC");

// Atribuir disciplina ao professor
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['atribuir'])) {
    $professor_id = intval($_POST['professor']);
    $disciplina_id = intval($_POST['disciplina']);
    $turma_id = intval($_POST['turma']);

    $stmt = $conn->prepare("INSERT INTO atribuicoes (professor_id, disciplina_id, turma_id) VALUES (?, ?, ?)");
    $stmt->bind_param("iii", $professor_id, $disciplina_id, $turma_id);
    $stmt->execute();
    $mensagem = "Disciplina atribuída com sucesso!";
}

// Remover atribuição
if (isset($_POST['remover'])) {
    $id = intval($_POST['remover']);
    $conn->query("DELETE FROM atribuicoes WHERE id = $id");
    $mensagem = "Atribuição removida.";
}

// Buscar atribuições
$atribuicoes = $conn->query("SELECT a.id, p.nome as professor, d.nome as disciplina, t.nome as turma
    FROM atribuicoes a
    JOIN professores p ON a.professor_id = p.id
    JOIN disciplinas d ON a.disciplina_id = d.id
    JOIN turmas t ON a.turma_id = t.id
    ORDER BY p.nome ASC, d.nome ASC");
?>
<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Atribuir Disciplina</title>
  <link rel="stylesheet" href="adminlte/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="adminlte/dist/css/adminlte.min.css">
  <style>
    * { box-sizing: border-box; }
    body { margin:0; font-family:'Segoe UI',sans-serif; background:#f4f6f9; }
    .sidebar { width:260px; background:#001f3f; color:white; position:fixed; top:0; left:0; height:100vh; padding-top:60px; }
    .sidebar ul{ list-style:none; padding:0; }
    .sidebar li{ padding:12px 20px; cursor:pointer; border-left:4px solid transparent; }
    .sidebar li:hover{ background:#0056b3; border-left:4px solid white; }
    .main-header { background:#003366; color:white; padding:20px; position:fixed; top:0; left:260px; right:0; display:flex; justify-content:space-between; z-index:1000; }
    .content { margin-top:80px; margin-left:260px; padding:20px; }
    form, table { background:white; padding:20px; border-radius:10px; box-shadow:0 0 10px rgba(0,0,0,0.1); margin-bottom:20px; }
    label { font-weight:bold; margin-top:10px; display:block; }
    select, button { width:100%; padding:8px; margin-top:5px; border:1px solid #ccc; border-radius:5px; }
    button { background:#007bff; color:white; font-weight:bold; }
    .mensagem { background:#d4edda; color:#155724; padding:10px; margin-bottom:15px; border-left:5px solid #155724; }
    table { width:100%; border-collapse:collapse; }
    th, td { border:1px solid #ccc; padding:10px; text-align:left; }
    th { background:#003366; color:white; }
    .btn-remove { background:#dc3545; color:white; border:none; padding:5px 10px; border-radius:4px; }
  </style>
</head>
<body>
<aside class="sidebar">
  <ul>
    <li onclick="location.href='painel.php'"><i class="fas fa-home"></i> Painel Principal</li>
    <li><i class="fas fa-user"></i> Professores</li>
    <li><i class="fas fa-book"></i> Disciplinas</li>
    <li><i class="fas fa-layer-group"></i> Turmas</li>
  </ul>
</aside>

<div class="main-header">
  <div><strong>SISMAG</strong> — Atribuição de Disciplinas</div>
  <div>Usuário: <?= htmlspecialchars($_SESSION['usuario']['nome'] ?? 'Desconhecido') ?></div>
</div>

<div class="content">
  <?php if (!empty($mensagem)): ?>
    <div class="mensagem"> <?= $mensagem ?> </div>
  <?php endif; ?>

  <form method="post">
    <label>Professor</label>
    <select name="professor" required>
      <option value="">-- Selecione --</option>
      <?php foreach($professores as $p): ?>
        <option value="<?= $p['id'] ?>"> <?= htmlspecialchars($p['nome']) ?> </option>
      <?php endforeach; ?>
    </select>

    <label>Disciplina</label>
    <select name="disciplina" required>
      <option value="">-- Selecione --</option>
      <?php foreach($disciplinas as $d): ?>
        <option value="<?= $d['id'] ?>"> <?= htmlspecialchars($d['nome']) ?> </option>
      <?php endforeach; ?>
    </select>

    <label>Turma</label>
    <select name="turma" required>
      <option value="">-- Selecione --</option>
      <?php foreach($turmas as $t): ?>
        <option value="<?= $t['id'] ?>"> <?= htmlspecialchars($t['nome']) ?> </option>
      <?php endforeach; ?>
    </select>

    <button type="submit" name="atribuir">Atribuir Disciplina</button>
  </form>

  <table>
    <thead>
      <tr>
        <th>Professor</th>
        <th>Disciplina</th>
        <th>Turma</th>
        <th>Ação</th>
      </tr>
    </thead>
    <tbody>
      <?php while($row = $atribuicoes->fetch_assoc()): ?>
      <tr>
        <td><?= htmlspecialchars($row['professor']) ?></td>
        <td><?= htmlspecialchars($row['disciplina']) ?></td>
        <td><?= htmlspecialchars($row['turma']) ?></td>
        <td>
          <form method="post" style="display:inline">
            <input type="hidden" name="remover" value="<?= $row['id'] ?>">
            <button type="submit" class="btn-remove">Remover</button>
          </form>
        </td>
      </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</div>
</body>
</html>





