<?php
include 'conexao.php';

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(['error' => 'ID do aluno não fornecido.']);
    exit;
}

$aluno_id = intval($_GET['id']);

$stmt = $conn->prepare("SELECT nome, idade, genero, opcao_lingua, vez FROM alunos WHERE id = ?");
$stmt->bind_param("i", $aluno_id);
$stmt->execute();
$result = $stmt->get_result();
$aluno = $result->fetch_assoc();
$stmt->close();

if ($aluno) {
    echo json_encode($aluno);
} else {
    echo json_encode(null);
}

$conn->close();
?>