<?php
// Arquivo: buscar_aluno_dados.php
// Objetivo: Buscar todos os dados do aluno e os dados da sua última matrícula/turma em JSON.

include 'conexao.php';
// session_start() não é estritamente necessário neste script AJAX, mas não prejudica.

header('Content-Type: application/json');

$aluno_id = $_GET['aluno_id'] ?? null;
$resultados = [];

if ($aluno_id) {
    // --- QUERY AJUSTADA: Garantir os aliases e a coluna 'a.foto' ---
    $sql = "
        SELECT 
            a.id,
            a.nome,
            a.idade,
            a.genero,
            a.data_nascimento,
            a.contacto, 
            a.endereco, 
            a.opcao_lingua, 
            a.vez, 
            a.observacoes, 
            a.naturalidade, 
            a.provincia, 
            a.bi_numero, 
            a.bi_emitido_em, 
            a.bi_data_emissao, 
            a.municipio, 
            a.nome_pai, 
            a.nome_mae, 
            a.numero_processo, 
            a.foto,  -- <-- IMPORTANTE! Garante que o nome da foto é retornado
            
            -- Dados de Turma/Matrícula
            t.id AS turma_id_do_aluno, -- <-- Nome do alias ajustado para corresponder ao JS
            t.nome AS nome_turma_display, -- <-- Nome do alias ajustado para corresponder ao JS
            t.classe, 
            t.curso, 
            t.turno

        FROM alunos a
        LEFT JOIN matriculas m ON m.aluno_id = a.id
        LEFT JOIN turmas t ON t.id = m.turma_id
        WHERE a.id = ?
        ORDER BY m.ano_letivo DESC, m.id DESC
        LIMIT 1
    ";

    $stmt = $conn->prepare($sql);
    
    // Verifica se a preparação foi bem sucedida antes de continuar
    if ($stmt === false) {
        // Erro na preparação: SQL incorreto ou problema de conexão
        echo json_encode(['error' => 'Erro na preparação da query: ' . $conn->error]);
        exit;
    }

    $stmt->bind_param("i", $aluno_id);

    if ($stmt->execute()) {
        $result = $stmt->get_result();

        if ($row = $result->fetch_assoc()) {
            
            // --- TRATAMENTO DOS DADOS PARA O FRONT-END ---

            // 1. Formato da Data de Nascimento (YYYY-MM-DD para input type="date")
            if (!empty($row['data_nascimento'])) {
                $row['data_nascimento'] = date('Y-m-d', strtotime($row['data_nascimento']));
            } else {
                $row['data_nascimento'] = '';
            }

            // 2. Formato da Data de Emissão do BI (YYYY-MM-DD para input type="date")
             if (!empty($row['bi_data_emissao'])) {
                $row['bi_data_emissao'] = date('Y-m-d', strtotime($row['bi_data_emissao']));
            } else {
                $row['bi_data_emissao'] = '';
            }
            
            // 3. Garantir que os campos de texto não sejam nulos (para evitar erros JS)
            $row['observacoes'] = $row['observacoes'] ?: '';
            
            // 4. Mapeamento de Turma: garantir que os campos esperados pelo JS existam,
            // mesmo que venham nulos do JOIN (aluno sem matrícula)
            $row['classe'] = $row['classe'] ?: 'N/A';
            $row['curso'] = $row['curso'] ?: 'N/A';
            $row['turno'] = $row['turno'] ?: 'N/A';
            $row['nome_turma_display'] = $row['nome_turma_display'] ?: 'Nenhuma Turma Ativa';
            $row['turma_id_do_aluno'] = $row['turma_id_do_aluno'] ?: null; // Null se não houver matrícula

            $resultados[] = $row;
        }
    }

    $stmt->close();
}

$conn->close();
// Retorna o resultado. Usamos JSON_UNESCAPED_UNICODE para caracteres especiais (como ã, ç, é).
echo json_encode($resultados, JSON_UNESCAPED_UNICODE);
?>