<?php
// Arquivo: buscar_alunos_por_turma.php
header('Content-Type: application/json');

// Inclui a conexão
include 'conexao.php'; 

$turma_id = $_GET['turma_id'] ?? null;
$alunos = [];

if ($turma_id && is_numeric($turma_id)) {
    $stmt = $conn->prepare("SELECT id, nome FROM alunos WHERE turma_id = ? ORDER BY nome ASC");
    if ($stmt) {
        $stmt->bind_param("i", $turma_id);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $alunos[] = $row;
        }
        $stmt->close();
    }
}

// Retorna a lista de alunos em formato JSON
echo json_encode($alunos);
$conn->close();
?>