<?php
include 'conexao.php';

// Define o cabeçalho para garantir que a resposta seja um JSON
header('Content-Type: application/json');

// Inicializa o array de resposta
$subcategorias = [];

// 1. Verifica se o ID da categoria foi passado e é um número inteiro
if (isset($_GET['categoria_id']) && is_numeric($_GET['categoria_id'])) {
    $categoria_id = intval($_GET['categoria_id']);

    // 2. Usa um prepared statement para uma consulta segura
    $stmt = $conn->prepare("SELECT id, codigo, nome FROM subcategorias_financeiras WHERE categoria_id = ? ORDER BY codigo");
    $stmt->bind_param("i", $categoria_id);
    $stmt->execute();
    $result = $stmt->get_result();

    // 3. Loop para preencher o array de subcategorias
    while ($row = $result->fetch_assoc()) {
        $subcategorias[] = [
            'id' => $row['id'],
            'nome' => $row['codigo'] . ' - ' . $row['nome']
        ];
    }
    
    $stmt->close();
}

// 4. Retorna o array como um JSON
echo json_encode($subcategorias);

// Fecha a conexão (opcional, mas boa prática)
$conn->close();
?>