<?php
// Arquivo: buscar_turmas.php
// Objetivo: Retornar a lista de turmas no formato JSON.

// 1. Configura o cabeçalho para indicar que a resposta é JSON
header('Content-Type: application/json');

// 2. Inclui o arquivo de conexão
// ATENÇÃO: Se 'conexao.php' não estiver no mesmo nível, ajuste o caminho.
include 'conexao.php'; 

// Inicializa o array de turmas
$turmas = [];

// 3. Query SQL para buscar os dados
// A query deve buscar as colunas da sua tabela 'turmas'
$query = "SELECT id, classe, nome, curso, sala, turno, ano 
          FROM turmas 
          ORDER BY classe ASC, nome ASC";

// 4. Executa a query
if ($result = $conn->query($query)) {
    while ($row = $result->fetch_assoc()) {
        // Adiciona cada linha (turma) ao array
        $turmas[] = $row;
    }
    // Libera o resultado
    $result->free();
} else {
    // 5. Tratamento de Erro (Se houver erro no SQL ou na conexão)
    // Retorna um status HTTP 500 para indicar erro interno e a mensagem de erro no corpo
    http_response_code(500);
    // Retorna a mensagem de erro do banco de dados (útil para depuração)
    echo json_encode(["error" => "Erro ao executar a query: " . $conn->error]);
    exit(); // Pára a execução
}

// 6. Retorna o array de turmas em formato JSON
echo json_encode($turmas);

// 7. Fecha a conexão
$conn->close();

// Não deve haver HTML, espaços em branco ou outro output depois desta linha!
?>