<?php
include 'conexao.php';

// Salvar turma
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome = $_POST['nome'] ?? '';
    $curso = $_POST['curso'] ?? '';
    $ano = $_POST['ano'] ?? '';
    $turno = $_POST['turno'] ?? '';

    // Validação simples do ano
    if (!preg_match('/^\d{4}\/\d{4}$/', $ano)) {
        echo "<script>alert('Ano lectivo inválido. Use o formato AAAA/AAAA');</script>";
    } elseif ($nome && $curso && $ano && $turno) {
        // Verificar duplicação
        $check = $conn->prepare("SELECT * FROM turmas_anteriores WHERE nome = ? AND curso = ? AND ano = ? AND turno = ?");
        $check->bind_param("ssss", $nome, $curso, $ano, $turno);
        $check->execute();
        $result = $check->get_result();
        if ($result->num_rows > 0) {
            echo "<script>alert('Essa turma já foi cadastrada.');</script>";
        } else {
            $stmt = $conn->prepare("INSERT INTO turmas_anteriores (nome, curso, ano, turno) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("ssss", $nome, $curso, $ano, $turno);
            $stmt->execute();
            echo "<script>alert('Turma salva com sucesso! Redirecionando para cadastro de disciplina...'); window.location.href='cadastrar_disciplina_anterior.php';</script>";
            exit;
        }
    } else {
        echo "<script>alert('Preencha todos os campos.');</script>";
    }
}

// Buscar turmas anteriores cadastradas
$turmas = $conn->query("SELECT * FROM turmas_anteriores ORDER BY ano DESC, nome ASC");
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Cadastrar Turma Anterior</title>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
        }
        .top-bar {
            background: #0056b3;
            color: white;
            padding: 15px;
            font-size: 18px;
        }
        .sidebar {
            width: 220px;
            background: #1c1c1c;
            height: 100vh;
            float: left;
            padding-top: 20px;
        }
        .sidebar a {
            display: block;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
        }
        .sidebar a:hover {
            background: #333;
        }
        .content {
            margin-left: 220px;
            padding: 20px;
            background: #f4f4f4;
            min-height: 100vh;
        }
        .form-box {
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 5px #ccc;
            margin-bottom: 20px;
        }
        input {
            width: 100%;
            padding: 8px;
            margin: 6px 0;
        }
        button {
            padding: 10px 15px;
            background: #0056b3;
            color: white;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background: #004494;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ccc;
        }
        th {
            background: #ddd;
        }
    </style>
</head>
<body>

<div class="top-bar">SISMAG - Cadastrar Turmas de Anos Lectivos Anteriores</div>

<div class="sidebar">
    <a href="painel_anteriores.php">🏠 Início</a>
    <a href="cadastrar_turma_anterior.php">➕ Nova Turma</a>
    <a href="cadastrar_disciplina_anterior.php">📚 Cadastrar Disciplinas</a>
    <a href="ver_alunos_anteriores.php">👨‍🎓 Ver Alunos Anteriores</a>
</div>

<div class="content">
    <div class="form-box">
        <h2>Nova Turma de Ano Anterior</h2>
        <form method="POST">
            <label>Nome da Turma:</label>
            <input name="nome" required>

            <label>Curso:</label>
            <input name="curso" required>

            <label>Ano Lectivo (ex: 2023/2024):</label>
            <input name="ano" required>

            <label>Turno:</label>
            <input name="turno" required>

            <button type="submit">Salvar</button>
        </form>
    </div>

    <h3>📋 Turmas Anteriores Cadastradas</h3>
    <table>
        <tr>
            <th>Nome</th>
            <th>Curso</th>
            <th>Ano</th>
            <th>Turno</th>
        </tr>
        <?php while ($t = $turmas->fetch_assoc()): ?>
        <tr>
            <td><?= htmlspecialchars($t['nome']) ?></td>
            <td><?= htmlspecialchars($t['curso']) ?></td>
            <td><?= htmlspecialchars($t['ano']) ?></td>
            <td><?= htmlspecialchars($t['turno']) ?></td>
        </tr>
        <?php endwhile; ?>
    </table>
</div>

</body>
</html>
