<?php
session_start();
include 'conexao.php';

$nome_usuario = ''; // Variável para o nome do formulário
$agente = '';
$perfil = '';
$mensagem = '';
$modo_edicao = false;
$id_usuario = 0;

// Verifica se está em modo edição
if (isset($_GET['editar'])) {
    $modo_edicao = true;
    $id_usuario = intval($_GET['editar']);
    $res = $conn->query("SELECT * FROM usuarios WHERE id = $id_usuario");
    if ($res && $res->num_rows > 0) {
        $dados = $res->fetch_assoc();
        $nome_usuario = $dados['nome']; // Carrega o nome para o formulário de edição
        $agente = $dados['agente'];
        $perfil = $dados['perfil'];
    }
}

// Remoção via GET
if (isset($_GET['remover'])) {
    $id_remover = intval($_GET['remover']);
    $stmt = $conn->prepare("DELETE FROM usuarios WHERE id=?");
    $stmt->bind_param("i", $id_remover);
    if ($stmt->execute()) {
        $mensagem = "Usuário removido com sucesso!";
    } else {
        $mensagem = "Erro ao remover: " . $stmt->error;
    }
}

// Processa o formulário
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['acao'])) {
    $acao = $_POST['acao'];
    $nome_usuario = $_POST['nome'] ?? ''; // Pega o nome do formulário
    $agente = $_POST['agente'] ?? '';
    $perfil = $_POST['perfil'] ?? '';
    $id_usuario = intval($_POST['id_usuario'] ?? 0);
    $senha_padrao = password_hash('123p', PASSWORD_DEFAULT);

    if ($nome_usuario && $agente && $perfil) {
        if ($acao === "salvar") {
            // AQUI ESTÁ A MUDANÇA: 'usuario' e 'nome' recebem o mesmo valor
            $stmt = $conn->prepare("INSERT INTO usuarios (usuario, nome, agente, perfil, senha) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("sssss", $nome_usuario, $nome_usuario, $agente, $perfil, $senha_padrao);
            if ($stmt->execute()) {
                $mensagem = "Usuário cadastrado com sucesso!";
                $nome_usuario = $agente = $perfil = '';
            } else {
                $mensagem = "Erro ao cadastrar: " . $stmt->error;
            }
        }

        if ($acao === "alterar" && $id_usuario > 0) {
            // AQUI ESTÁ A MUDANÇA: 'usuario' e 'nome' são atualizados com o mesmo valor
            $stmt = $conn->prepare("UPDATE usuarios SET usuario = ?, nome = ?, agente = ?, perfil = ? WHERE id = ?");
            $stmt->bind_param("ssssi", $nome_usuario, $nome_usuario, $agente, $perfil, $id_usuario);
            if ($stmt->execute()) {
                $mensagem = "Usuário alterado com sucesso!";
                $modo_edicao = false;
                $nome_usuario = $agente = $perfil = '';
                $id_usuario = 0;
            } else {
                $mensagem = "Erro ao alterar: " . $stmt->error;
            }
        }
    } else {
        $mensagem = "Preencha todos os campos obrigatórios.";
    }
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Gestão de Usuários</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="adminlte/plugins/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="adminlte/dist/css/adminlte.min.css">
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', sans-serif;
            background-color: #f4f6f9;
        }

        .main-header {
            background-color: #003366;
            color: white;
            padding: 15px 20px;
            position: fixed;
            width: 100%;
            top: 0;
            left: 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
            z-index: 1000;
        }

        .sidebar {
            width: 250px;
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            background-color: #003366;
            padding-top: 60px;
            color: white;
        }

        .sidebar a {
            display: block;
            color: white;
            padding: 15px 20px;
            text-decoration: none;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .sidebar a:hover {
            background-color: #0056b3;
        }

        .main-content {
            margin-left: 250px;
            padding: 90px 30px 30px 30px;
        }

        .form-box, .table-container {
            background: white;
            padding: 25px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            max-width: 700px;
            margin-bottom: 30px;
        }

        .form-box h2 {
            color: #003366;
            margin-bottom: 20px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        label {
            display: block;
            font-weight: bold;
            margin-bottom: 5px;
        }

        input, select {
            width: 100%;
            padding: 8px;
            border-radius: 4px;
            border: 1px solid #ccc;
        }

        .buttons button {
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            margin-right: 10px;
            font-weight: bold;
            cursor: pointer;
            color: white;
        }

        .salvar { background-color: #007bff; }

        .mensagem {
            margin-bottom: 15px;
            color: green;
            font-weight: bold;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            padding: 10px;
            border-bottom: 1px solid #ccc;
            text-align: left;
        }

        th {
            background-color: #003366;
            color: white;
        }

        .btn-editar {
            background: #17a2b8;
            color: white;
            padding: 5px 10px;
            text-decoration: none;
            border-radius: 5px;
            margin-right: 5px;
        }

        .btn-editar:hover {
            background: #138496;
        }

        .remover {
            background-color: #dc3545;
        }
    </style>
</head>
<body>

<div class="main-header">
    <div><strong>SISMAG | Gestão de Usuários</strong></div>
    <div><i class="fas fa-user"></i> <?= $_SESSION['usuario']['nome'] ?? 'Usuário' ?></div>
</div>

<div class="sidebar">
    <a href="painel.php"><i class="fas fa-home"></i> Painel Principal</a>
    <a href="cadastrar_usuario.php"><i class="fas fa-users-cog"></i> Gerenciar Usuários</a>
</div>

<div class="main-content">

    <div class="form-box">
        <h2><?= $modo_edicao ? 'Editar Usuário' : 'Cadastrar Novo Usuário' ?></h2>
        <?php if (!empty($mensagem)) echo "<div class='mensagem'>$mensagem</div>"; ?>
        <form method="post">
            <input type="hidden" name="id_usuario" value="<?= $id_usuario ?>">

            <div class="form-group">
                <label>Nome do Usuário:</label>
                <input type="text" name="nome" required value="<?= htmlspecialchars($nome_usuario) ?>">
            </div>

            <div class="form-group">
                <label>Nº de Agente:</label>
                <input type="text" name="agente" required value="<?= htmlspecialchars($agente) ?>">
            </div>

            <div class="form-group">
                <label>Perfil:</label>
                <select name="perfil" required>
                    <option value="">-- Selecione --</option>
                    <option value="ADMINISTRADOR" <?= $perfil == 'ADMINISTRADOR' ? 'selected' : '' ?>>ADMINISTRADOR</option>
                    <option value="SECRETARIA GERAL" <?= $perfil == 'SECRETARIA GERAL' ? 'selected' : '' ?>>SECRETARIA GERAL</option>
                    <option value="SECRETARIA PEDAGÓGICA" <?= $perfil == 'SECRETARIA PEDAGÓGICA' ? 'selected' : '' ?>>SECRETARIA PEDAGÓGICA</option>
                    <option value="SUBDIRECÇÃO ADMINISTRATIVA" <?= $perfil == 'SUBDIRECÇÃO ADMINISTRATIVA' ? 'selected' : '' ?>>SUBDIRECÇÃO ADMINISTRATIVA</option>
                    <option value="SUBDIRECÇÃO PEDAGÓGICA" <?= $perfil == 'SUBDIRECÇÃO PEDAGÓGICA' ? 'selected' : '' ?>>SUBDIRECÇÃO PEDAGÓGICA</option>
                    <option value="PROFESSOR" <?= $perfil == 'PROFESSOR' ? 'selected' : '' ?>>PROFESSOR</option>
                </select>
            </div>

            <div class="buttons">
                <button type="submit" name="acao" value="salvar" class="salvar" <?= $modo_edicao ? 'disabled' : '' ?>>Salvar</button>
                <?php if ($modo_edicao): ?>
                    <button type="submit" name="acao" value="alterar" class="btn-editar">Alterar</button>
                <?php endif; ?>
            </div>
        </form>
    </div>

    <div class="table-container">
        <h3>Usuários Cadastrados</h3>
        <table>
            <thead>
                <tr>
                    <th>Nº</th>
                    <th>Nome do Usuário</th>
                    <th>Agente</th>
                    <th>Perfil</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $usuarios = $conn->query("SELECT * FROM usuarios ORDER BY nome");
                $i = 1;
                while ($u = $usuarios->fetch_assoc()) {
                    echo "<tr>
                            <td>{$i}</td>
                            <td>" . htmlspecialchars($u['nome']) . "</td>
                            <td>" . htmlspecialchars($u['agente']) . "</td>
                            <td>" . htmlspecialchars($u['perfil']) . "</td>
                            <td>
                                <a class='btn-editar' href='cadastrar_usuario.php?editar={$u['id']}'><i class='fas fa-edit'></i> Alterar</a>
                                <a class='btn-editar remover' href='cadastrar_usuario.php?remover={$u['id']}' onclick='return confirm(\"Deseja remover este usuário?\")'><i class='fas fa-trash'></i> Remover</a>
                            </td>
                          </tr>";
                    $i++;
                }
                ?>
            </tbody>
        </table>
    </div>
</div>
</body>
</html>