<?php
include 'conexao.php';

if (isset($_POST['ano_letivo'])) {
    $ano = $_POST['ano_letivo'];
    file_put_contents("debug.txt", "Ano recebido: " . $ano);

    $stmt = $conn->prepare("SELECT id, classe, nome, curso FROM turmas WHERE ano = ?");
    $stmt->bind_param("s", $ano);
    $stmt->execute();
    $resultado = $stmt->get_result();

    if ($resultado->num_rows > 0) {
        echo '<option value="">-- Selecione a Turma --</option>';
        while ($row = $resultado->fetch_assoc()) {
            $id = $row['id'];
            $classe = $row['classe'];
            $turma = $row['nome'];
            $curso = $row['curso'];

            $label = $classe . '-' . $turma . '-' . $curso;
            echo "<option value=\"$id\">$label</option>";
        }
    } else {
        echo '<option value="">Nenhuma turma encontrada</option>';
    }
} else {
    echo '<option value="">Erro: ano letivo não enviado</option>';
}
?>
