 <?php
ob_start();
session_start();

include 'conexao.php';
require 'fpdf/fpdf.php';

// Receber ID do aluno via GET
$aluno_id = $_GET['aluno_id'] ?? '';
if (!$aluno_id) die("ID do aluno não fornecido.");

// Buscar dados do aluno
$stmt = $conn->prepare("
    SELECT a.nome, a.bi_numero, a.data_nascimento, a.genero,
           a.nome_pai, a.nome_mae, a.curso, a.provincia, a.bi_emitido_em, a.bi_data_emissao
    FROM alunos a
    WHERE a.id = ?
");
$stmt->bind_param("i", $aluno_id);
$stmt->execute();
$dados = $stmt->get_result()->fetch_assoc();
if (!$dados) die("Aluno não encontrado.");

// Buscar ano da 12ª classe
$stmtAnoConclusao = $conn->prepare("
    SELECT t.ano
    FROM matriculas m
    INNER JOIN turmas t ON m.turma_id = t.id
    WHERE m.aluno_id = ? AND t.classe = '12ª'
    ORDER BY t.ano DESC
    LIMIT 1
");
$stmtAnoConclusao->bind_param("i", $aluno_id);
$stmtAnoConclusao->execute();
$resultAno = $stmtAnoConclusao->get_result();
$ano_conclusao = $resultAno->fetch_assoc()['ano'] ?? '_______';

// Buscar notas finais
$stmt = $conn->prepare("
    SELECT d.nome AS disciplina, t.classe, n.mf
    FROM notas n
    INNER JOIN disciplinas d ON n.disciplina_id = d.id
    INNER JOIN turmas t ON n.turma_id = t.id
    WHERE n.aluno_id = ?
    ORDER BY d.nome, t.classe
");
$stmt->bind_param("i", $aluno_id);
$stmt->execute();
$result = $stmt->get_result();

$disciplinas_por_classe = [];
$disciplinas_unicas = [];
$classes = ['10ª', '11ª', '12ª'];

// Organizar os dados
while ($row = $result->fetch_assoc()) {
    $disc = $row['disciplina'];
    $classe = $row['classe'];
    $mf = $row['mf'];
    $disciplinas_por_classe[$disc][$classe] = $mf;
    $disciplinas_unicas[$disc] = true;
}

// Calcular média geral
$totalNotas = 0;
$totalDisciplinas = 0;

foreach ($disciplinas_por_classe as $disciplinas) {
    foreach ($classes as $classe) {
        if (isset($disciplinas[$classe]) && is_numeric($disciplinas[$classe])) {
            $totalNotas += $disciplinas[$classe];
            $totalDisciplinas++;
        }
    }
}
$media_final = $totalDisciplinas ? round($totalNotas / $totalDisciplinas) : 0;
$media_extenso = ucfirst(strtolower(num2letras($media_final)));

// --------------------------
// Gerar PDF
// --------------------------
$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Times', '', 12);

// Insígnia central
$pdf->Image('insignia/insignia.png', ($pdf->GetPageWidth() - 30) / 2, 10, 30);
$pdf->Ln(28);

// Cabeçalho
$pdf->SetFont('Times', 'B', 12);
$pdf->Cell(0, 8, utf8_decode('REPÚBLICA DE ANGOLA'), 0, 1, 'C');
$pdf->Cell(0, 8, utf8_decode('GOVERNO PROVINCIAL DE BENGUELA'), 0, 1, 'C');
$pdf->Cell(0, 8, utf8_decode('GABINETE PROVINCIAL DA EDUCAÇÃO'), 0, 1, 'C');
$pdf->Cell(0, 8, utf8_decode('COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK - CATUMBELA'), 0, 1, 'C');
$pdf->Ln(4);
$pdf->Cell(0, 6, utf8_decode('CERTIFICADO'), 0, 1, 'C');
$pdf->Ln(4);

// Corpo
$pdf->SetFont('Times', '', 12);
$pdf->MultiCell(0, 6, utf8_decode(
    "Eduardo Sanjambela Tchandja, Director do Complexo Escolar BG0026 Padre Emil Frick - Catumbela, certifica que, " .
    "{$dados['nome']}, filho de {$dados['nome_pai']} e de {$dados['nome_mae']}, nascido aos " . date('d', strtotime($dados['data_nascimento'])) .
    " de " . traduz_mes(date('F', strtotime($dados['data_nascimento']))) . " de " . date('Y', strtotime($dados['data_nascimento'])) .
    ", no município de {$dados['municipio']}, Província do {$dados['provincia']}, portador do B.I nº {$dados['bi']}, passado pelo Arquivo de Identificação de {$dados['bi_emitido_em']} aos " .
    date('d', strtotime($dados['bi_data_emissao'])) . " de " . traduz_mes(date('F', strtotime($dados['bi_data_de_emissao']))) . " de " . date('Y', strtotime($dados['bi_data_de_emissao'])) .
    ".\nConcluiu no ano lectivo {$ano_conclusao}, o curso de {$dados['curso']}, tendo obtido as seguintes classificações:"
), 0, 'J');

$pdf->Ln(4);

// Tabela de Notas
$pdf->SetFont('Times', 'B', 10);
$pdf->SetX(30);
$pdf->Cell(60, 8, 'Disciplinas', 1, 0, 'C');
foreach ($classes as $classe) {
    $pdf->Cell(30, 8, $classe, 1, 0, 'C');
}
$pdf->Ln();

$pdf->SetFont('Times', '', 10);
foreach ($disciplinas_por_classe as $disciplina => $notas) {
    $pdf->SetX(30);
    $pdf->Cell(60, 8, utf8_decode($disciplina), 1);
    foreach ($classes as $classe) {
        $valor = $notas[$classe] ?? '-';
        $pdf->Cell(30, 8, $valor, 1, 0, 'C');
    }
    $pdf->Ln();
}

$pdf->Ln(5);
$pdf->MultiCell(0, 6, utf8_decode(
    "Obteve a classificação final de {$media_final} ({$media_extenso}) Valores.\n" .
    "Por ser verdade e assim constar, se passou o presente Certificado que vai por mim assinado e autenticado com o carimbo a óleo em uso nesta Instituição."
), 0, 'J');

$pdf->Ln(3);
$pdf->Cell(0, 8, utf8_decode("Complexo Escolar BG0026 Padre Emil Frick – Catumbela, aos " . date('d') . " de " . traduz_mes(date('F')) . " de " . date('Y') . "."), 0, 1);

$pdf->Ln(5);
$pdf->Cell(90, 8, 'O Director', 0, 0, 'L');
$pdf->Cell(90, 8, 'O Subdirector Pedagógico', 0, 1, 'R');
$pdf->Cell(90, 8, '_________________________', 0, 0, 'L');
$pdf->Cell(90, 8, '__________________________________', 0, 1, 'R');
$pdf->Cell(90, 8, 'Eduardo Sanjambela Tchandja', 0, 0, 'L');
$pdf->Cell(90, 8, 'Anacleto Domingos de Oliveira Cachiyenjo', 0, 1, 'R');

ob_end_clean();
$pdf->Output();
exit();

// Funções auxiliares
function traduz_mes($mes_en) {
    $meses = [
        'January' => 'Janeiro', 'February' => 'Fevereiro', 'March' => 'Março',
        'April' => 'Abril', 'May' => 'Maio', 'June' => 'Junho',
        'July' => 'Julho', 'August' => 'Agosto', 'September' => 'Setembro',
        'October' => 'Outubro', 'November' => 'Novembro', 'December' => 'Dezembro'
    ];
    return $meses[$mes_en] ?? $mes_en;
}

function num2letras($n) {
    $f = new NumberFormatter("pt", NumberFormatter::SPELLOUT);
    return $f->format($n);
}
?>
