<?php

session_start();

// É altamente recomendado definir o locale para que strftime funcione corretamente
setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
date_default_timezone_set('Africa/Luanda');

include 'conexao.php';

$dias = ['Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta'];

$horario_turmas = [];
$horario_professores_manhã = [];
$horario_professores_tarde = [];
$tempos_por_turma = [];
$tempos_por_professor = [];
$disciplinas_por_professor_geral = []; // Lista geral de disciplinas por professor
$professor_disciplinas_por_turma = []; // Nova estrutura: Professor -> Turma -> Disciplinas
$disciplinas_alocadas_dia = [];
$professor_turnos = [];

// Função para verificar se a alocação é possível em um determinado tempo e dia, respeitando a regra
function pode_alocar(&$horario_turma, &$horario_professor, $turma, $professor, $dia, $tempo_indice, $disciplina_nome) {
    global $disciplinas_alocadas_dia;
    if (isset($horario_turma[$turma][$dia][$tempo_indice]) && !empty($horario_turma[$turma][$dia][$tempo_indice])) {
        return false;
    }
    if (isset($horario_professor[$professor][$dia][$tempo_indice]) && !empty($horario_professor[$professor][$dia][$tempo_indice])) {
        return false;
    }
    // Regra: Não mais de 2 tempos da mesma disciplina no mesmo dia
    if (isset($disciplinas_alocadas_dia[$turma][$disciplina_nome][$dia]) && $disciplinas_alocadas_dia[$turma][$disciplina_nome][$dia] >= 2) {
        return false;
    }
    return true;
}

// Buscar atribuições e ordenar por maior carga horária (tempos_semana)
$atribuicoes_query = $conn->query("
    SELECT a.professor_id, a.disciplina_id, a.turma_id, a.tempos_semana,
           p.nome AS professor, d.nome AS disciplina,
           t.nome AS turma_nome, t.classe, t.curso, t.turno, t.sala
    FROM atribuicoes a
    JOIN usuarios p ON a.professor_id = p.id
    JOIN disciplinas d ON a.disciplina_id = d.id
    JOIN turmas t ON a.turma_id = t.id
    ORDER BY a.tempos_semana DESC
");

$atribuicoes = $atribuicoes_query->fetch_all(MYSQLI_ASSOC);

// Inicializar estruturas de dados
foreach ($atribuicoes as $a) {
    // Turma completa (chave de identificação)
    $turma_completa = "{$a['classe']} - {$a['turma_nome']} - {$a['curso']} - {$a['turno']} - Sala {$a['sala']}";
    // Turma simplificada (para exibição no horário do professor)
    $turma_simples = "{$a['classe']}-{$a['turma_nome']}/{$a['curso']}";
    $professor_completo = $a['professor'];
    $turno = strtolower($a['turno']);
    $disciplina = $a['disciplina'];

    $tempos = ($turno === 'tarde')
        ? ['13:00-13:45', '13:50-14:35', '14:40-15:25', '15:30-16:15', '16:20-17:05', '17:10-17:55']
        : ['7:30-8:15', '8:20-9:05', '9:10-9:55', '10:10-10:55', '11:00-11:45', '11:50-12:35'];

    $tempos_por_turma[$turma_completa] = $tempos;

    // 1. Estrutura de dados para a Legenda da Turma
    if (!isset($professor_disciplinas_por_turma[$turma_completa][$professor_completo])) {
        $professor_disciplinas_por_turma[$turma_completa][$professor_completo] = [];
    }
    if (!in_array($disciplina, $professor_disciplinas_por_turma[$turma_completa][$professor_completo])) {
        $professor_disciplinas_por_turma[$turma_completa][$professor_completo][] = $disciplina;
    }
    
    // 2. Inicialização para o Horário
    if (!isset($tempos_por_professor[$professor_completo])) {
        $tempos_por_professor[$professor_completo] = $tempos;
    }
    if (!isset($professor_turnos[$professor_completo])) {
        $professor_turnos[$professor_completo] = [];
    }
    if (!in_array($turno, $professor_turnos[$professor_completo])) {
        $professor_turnos[$professor_completo][] = $turno;
    }
    if (!isset($horario_turmas[$turma_completa])) {
        foreach ($dias as $dia) {
            for ($i = 0; $i < 6; $i++) {
                $horario_turmas[$turma_completa][$dia][$i] = '';
            }
        }
    }
    if (!isset($horario_professores_manhã[$professor_completo])) {
        foreach ($dias as $dia) {
            for ($i = 0; $i < 6; $i++) {
                $horario_professores_manhã[$professor_completo][$dia][$i] = '';
            }
        }
    }
    if (!isset($horario_professores_tarde[$professor_completo])) {
        foreach ($dias as $dia) {
            for ($i = 0; $i < 6; $i++) {
                $horario_professores_tarde[$professor_completo][$dia][$i] = '';
            }
        }
    }
    if (!isset($disciplinas_alocadas_dia[$turma_completa][$a['disciplina']])) {
        $disciplinas_alocadas_dia[$turma_completa][$a['disciplina']] = array_fill_keys($dias, 0);
    }
    if (!isset($disciplinas_por_professor_geral[$professor_completo])) {
        $disciplinas_por_professor_geral[$professor_completo] = [];
    }
    if (!in_array($a['disciplina'], $disciplinas_por_professor_geral[$professor_completo])) {
        $disciplinas_por_professor_geral[$professor_completo][] = $a['disciplina'];
    }
}

// Lógica de alocação principal (continua igual)
foreach ($atribuicoes as $a) {
    $turma_completa = "{$a['classe']} - {$a['turma_nome']} - {$a['curso']} - {$a['turno']} - Sala {$a['sala']}";
    $professor_completo = $a['professor'];
    $disciplina = $a['disciplina'];
    $tempos_restantes = intval($a['tempos_semana']);
    $turno = strtolower($a['turno']);

    if ($turno === 'tarde') {
        $horario_professor_alocacao = &$horario_professores_tarde;
    } else {
        $horario_professor_alocacao = &$horario_professores_manhã;
    }

    // Turma formatada para o HORÁRIO DO PROFESSOR (apenas turma, SEM A SALA)
    $turma_display_prof = "{$a['classe']}-{$a['turma_nome']}/{$a['curso']}"; 
    
    // Alocação de 2 tempos juntos
    for ($t = 0; $t < ceil($tempos_restantes / 2); $t++) {
        $alocado = false;
        foreach ($dias as $dia) {
            for ($i = 0; $i < 5; $i++) {
                if (
                    $tempos_restantes >= 2 &&
                    pode_alocar($horario_turmas, $horario_professor_alocacao, $turma_completa, $professor_completo, $dia, $i, $disciplina) &&
                    pode_alocar($horario_turmas, $horario_professor_alocacao, $turma_completa, $professor_completo, $dia, $i + 1, $disciplina)
                ) {
                    // AQUI: Apenas disciplina no horário da turma
                    $entrada_turma = "$disciplina"; 
                    // AQUI: Apenas turma no horário do professor (sem disciplina, sem sala)
                    $entrada_professor = "$turma_display_prof"; 
                    
                    $horario_turmas[$turma_completa][$dia][$i] = $entrada_turma;
                    $horario_turmas[$turma_completa][$dia][$i+1] = $entrada_turma;
                    $horario_professor_alocacao[$professor_completo][$dia][$i] = $entrada_professor;
                    $horario_professor_alocacao[$professor_completo][$dia][$i+1] = $entrada_professor;
                    $disciplinas_alocadas_dia[$turma_completa][$disciplina][$dia] += 2;
                    $tempos_restantes -= 2;
                    $alocado = true;
                    break;
                }
            }
            if ($alocado) break;
        }
    }

    // Alocação de 1 tempo restante
    for ($t = 0; $t < $tempos_restantes; $t++) {
        $alocado = false;
        foreach ($dias as $dia) {
            for ($i = 0; $i < 6; $i++) {
                if (pode_alocar($horario_turmas, $horario_professor_alocacao, $turma_completa, $professor_completo, $dia, $i, $disciplina)) {
                    // AQUI: Apenas disciplina no horário da turma
                    $entrada_turma = "$disciplina"; 
                    // AQUI: Apenas turma no horário do professor (sem disciplina, sem sala)
                    $entrada_professor = "$turma_display_prof";
                    
                    $horario_turmas[$turma_completa][$dia][$i] = $entrada_turma;
                    $horario_professor_alocacao[$professor_completo][$dia][$i] = $entrada_professor;
                    $disciplinas_alocadas_dia[$turma_completa][$disciplina][$dia]++;
                    $alocado = true;
                    break;
                }
            }
            if ($alocado) break;
        }
    }
}

// RE-CALCULAR CARGA HORÁRIA FINAL
$carga_professores_final = [];
foreach ($tempos_por_professor as $prof => $tempos) {
    $carga_professores_final[$prof] = 0;
    if (isset($horario_professores_manhã[$prof])) {
        foreach ($horario_professores_manhã[$prof] as $dia) {
            foreach ($dia as $tempo) {
                if (!empty($tempo)) $carga_professores_final[$prof]++;
            }
        }
    }
    if (isset($horario_professores_tarde[$prof])) {
        foreach ($horario_professores_tarde[$prof] as $dia) {
            foreach ($dia as $tempo) {
                if (!empty($tempo)) $carga_professores_final[$prof]++;
            }
        }
    }
}

// Função para gerar o rodapé com a data por extenso e centralizado
function rodapeComData() {
    // Usando a data atual fornecida pela pesquisa (ou a data atual real, como preferir)
    $dataAtual = '04 de Outubro de 2025'; // Exemplo
    $dataLinha = "Catumbela, {$dataAtual}";

    return "
        <div class='assinatura-print' style='text-align: center;'>
            <p class='assinatura-data'>{$dataLinha}</p>
            <p class='assinatura-cargo'>O SUBDIRECTOR PEDAGÓGICO</p>
            <p class='assinatura-linha'>_____________________________________________</p>
            <p class='assinatura-nome-subdiretor'>ANACLETO DOMINGOS DE OLIVEIRA CACHIYENJO</p> </div>
    ";
}

?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Consultar Horário</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.3/html2pdf.bundle.min.js"></script>
    <style>
        /* Estilos existentes para a tela, mantidos para usabilidade */
        body { font-family: Arial; background: #f5f5f5; padding: 20px; }
        h2 { text-align: center; color: #004080; }
        .form-container { text-align: center; margin-bottom: 20px; }
        .horario-container { margin-bottom: 60px; border: 1px solid #ccc; padding: 20px; background-color: #fff; }
        .horario-buttons { text-align: right; margin-bottom: 10px; }
        .horario-buttons button { padding: 5px 10px; cursor: pointer; margin-left: 5px; }
        select, button { padding: 8px; margin: 5px; }
        table { border-collapse: collapse; width: 100%; background: white; }
        th, td { border: 1px solid #ccc; padding: 8px; vertical-align: top; width: 15%; }
        .coluna-hora { width: 10%; font-size: 0.7em; padding: 3px; }
        td { text-align: justify; }
        th { background-color: #004080; color: white; text-align: center; }
        .no-print { margin: 10px 0; }
        #horarios-gerados { display: none; }
        .edit-mode td { background-color: #e6f7ff; }

        /* Estilos para a legenda do professor/disciplina */
        .legenda-professores { 
            margin-top: 15px; 
            padding: 10px; 
            border-top: 1px solid #ddd;
            font-size: 10pt;
        }
        .legenda-professores strong {
            display: block;
            margin-bottom: 5px;
            font-size: 11pt;
            color: #004080;
        }
        .legenda-professores p {
            margin: 2px 0;
        }

        /* Esconder o Visto na visualização em tela para evitar sobreposição */
        .visto-label, .visto-assinatura {
            display: none; 
        }

        /* --- Estilos para impressão (PDF) na vertical --- */
        @media print {
            .no-print, .horario-buttons { display: none; }
            
            body { 
                font-size: 10pt;
                margin: 1cm;
            }

            h2, h3, h4, p { font-size: 10pt; margin: 0; padding: 0; }
            
            .header-print { 
                font-size: 9pt; 
                margin-bottom: 10px;
                text-align: center;
                font-family: Arial;
                /* CABEÇALHO MOVIDO PARA O TOPO */
                margin-top: 5px; 
                position: relative; 
            }
            
            .header-print img { height: 60px !important; margin-bottom: 5px !important; }
            
            .header-print p { margin: 0px; }
            .header-print h3, .header-print h4 { margin: 0px; }

            .horario-container h4 {
                margin-top: 5px;
                margin-bottom: 10px;
            }
            
            /* Ajustes para a grelha e células */
            th, td { 
                padding: 3px;
                font-size: 9pt;
                text-align: left;
            }
            th { text-align: center; }
            td { word-wrap: break-word; }

            .coluna-hora { 
                width: 1%;
                white-space: nowrap;
                font-size: 9pt;
                text-align: center;
            }
            
            /* REDUZIR TAMANHO DA LETRA DENTRO DO HORÁRIO DO PROFESSOR (8PT) */
            .professor-horario td {
                font-size: 8pt; 
            }
            /* Garantir que a coluna da hora mantenha o tamanho */
            .professor-horario .coluna-hora {
                font-size: 9pt;
            }
            
            .horario-container { 
                page-break-inside: avoid;
                margin: 5px;
                border: 1px solid #ccc;
                padding: 5px;
                background-color: #fff;
            }
            
            /* Rodapé (SUBDIRECTOR) */
            .assinatura-print { 
                font-size: 10pt; 
                margin-top: 25px; 
                text-align: center; 
                font-family: Arial;
            }
            
            .assinatura-print p {
                text-align: center; 
                margin: 0; 
                padding: 0;
                line-height: 1.2;
            }

            .assinatura-data { margin-bottom: 15px !important; }
            .assinatura-cargo { margin-top: 10px !important; margin-bottom: 0 !important; }
            
            /* Separar a linha do traço do nome do Subdiretor */
            .assinatura-linha { 
                margin-top: 5px !important; 
                margin-bottom: 0 !important; 
            }
            .assinatura-nome-subdiretor { 
                margin-top: 2px !important; 
                font-weight: bold;
                line-height: 1.2;
            }

            /* --- AJUSTE FINAL: VISTO/DIRETOR (DESCIDO) --- */
            
            /* Bloco Visto (palavra "Visto") */
            .visto-label {
                position: absolute;
                top: 75px;    /* DESCIDO */
                left: 5px;   
                width: 250px; 
                text-align: center; 
                font-size: 9pt; 
                font-family: Arial;
                font-weight: bold;
                display: block; 
            }

            /* Bloco Assinatura do Diretor */
            .visto-assinatura {
                position: absolute;
                top: 95px;   /* DESCIDO */
                left: 5px;   
                width: 250px; 
                text-align: center; 
                font-size: 9pt; 
                font-family: Arial;
                line-height: 1.2;
                display: block; 
            }

            /* Estilos para a legenda de professores/disciplinas na impressão */
            .legenda-professores {
                margin-top: 15px; 
                padding: 10px 0 0 0; 
                border-top: 1px solid #ddd;
                font-size: 9pt; /* Ajuste para o tamanho da impressão */
                page-break-inside: avoid;
            }
            .legenda-professores strong {
                font-size: 10pt;
                display: block;
                margin-bottom: 5px;
            }
        }
    </style>
</head>
<body>

<h2>Consultar Horário</h2>

<div class="form-container no-print">
    <button id="btnExibir" onclick="exibirHorarios()">Exibir Horários</button>
</div>

<div id="horarios-gerados">
    <h3>Horários por Turma</h3>
    <?php foreach ($horario_turmas as $turma => $tabela): ?>
        <div class="horario-container turma-horario" id="turma-<?= htmlspecialchars(str_replace([' ', '/', '.'], '', $turma)) ?>">
            <div class="horario-buttons no-print">
                <button onclick="toggleEdicao('turma-<?= htmlspecialchars(str_replace([' ', '/', '.'], '', $turma)) ?>')">✏️ Editar</button>
                <button onclick="downloadHorario('turma-<?= htmlspecialchars(str_replace([' ', '/', '.'], '', $turma)) ?>', 'Horario_Turma_<?= htmlspecialchars(str_replace([' ', '/', '.'], '', $turma)) ?>')">⬇️ Download</button>
                <button onclick="imprimirHorario('turma-<?= htmlspecialchars(str_replace([' ', '/', '.'], '', $turma)) ?>')">🖨️ Imprimir</button>
            </div>
            
            <div class="content-to-download">
                <div class="visto-label">
                    <strong>Visto</strong>
                </div>
                <div class="visto-assinatura">
                    O DIRECTOR<br><br>
                    __________________________<br>
                    Eduardo Sanjambela Tchandja
                </div>
                <div class="header-print" style="position: relative; text-align:center; font-family: Arial; margin-bottom: 10px;">
                    <img src="insignia/insignia.png" alt="Insígnia" style="height: 80px; margin-bottom: 10px;">
                    <p style="font-weight: normal; margin: 0;">REPÚBLICA DE ANGOLA</p>
                    <p style="margin: 2px 0; font-weight: normal;">GOVERNO PROVINCIAL DE BENGUELA</p>
                    <p style="margin: 2px 0; font-weight: normal;">GABINETE PROVINCIAL DA EDUCAÇÃO</p>
                    <p style="margin: 2px 0 15px; font-weight: normal;">COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK - CATUMBELA</p>
                    <h3 style="font-weight: bold; text-align: center; margin: 0;">HORÁRIO ESCOLAR</h3>
                    <h3 style="font-weight: bold; text-align: center; margin: 0;">Ano Lectivo : 2025/2026</h3>
                </div>
                
                <h4>Turma: <?= htmlspecialchars($turma) ?></h4>
                <table>
                    <thead>
                        <tr><th class="coluna-hora">Hora</th><?php foreach ($dias as $d) echo "<th>$d</th>"; ?></tr>
                    </thead>
                    <tbody>
                        <?php for ($i = 0; $i < 6; $i++): ?>
                            <tr>
                                <td class="coluna-hora"><?= $tempos_por_turma[$turma][$i] ?></td>
                                <?php foreach ($dias as $dia): ?>
                                    <td class="editable" contenteditable="false"><?= $tabela[$dia][$i] ?? '' ?></td>
                                <?php endforeach; ?>
                            </tr>
                        <?php endfor; ?>
                    </tbody>
                </table>
                
                <div class="legenda-professores">
                    <strong>Corpo Docente da Turma:</strong>
                    <?php 
                    if (isset($professor_disciplinas_por_turma[$turma])):
                        // Ordenar por nome do professor
                        ksort($professor_disciplinas_por_turma[$turma]);
                        foreach ($professor_disciplinas_por_turma[$turma] as $professor_nome => $disciplinas): 
                            $disciplinas_list = implode(", ", $disciplinas);
                    ?>
                        <p>
                            **<?= htmlspecialchars($professor_nome) ?>**: <?= htmlspecialchars($disciplinas_list) ?>
                        </p>
                    <?php 
                        endforeach; 
                    endif;
                    ?>
                </div>
                
                <?= rodapeComData() ?>
            </div>
        </div>
    <?php endforeach; ?>

    <h3>Horários por Professor</h3>
    <?php foreach ($tempos_por_professor as $prof => $tempos): ?>
        <div class="horario-container professor-horario" id="prof-<?= htmlspecialchars(str_replace([' ', '/', '.'], '', $prof)) ?>">
            <div class="horario-buttons no-print">
                <button onclick="toggleEdicao('prof-<?= htmlspecialchars(str_replace([' ', '/', '.'], '', $prof)) ?>')">✏️ Editar</button>
                <button onclick="downloadHorario('prof-<?= htmlspecialchars(str_replace([' ', '/', '.'], '', $prof)) ?>', 'Horario_Prof_<?= htmlspecialchars(str_replace([' ', '/', '.'], '', $prof)) ?>')">⬇️ Download</button>
                <button onclick="imprimirHorario('prof-<?= htmlspecialchars(str_replace([' ', '/', '.'], '', $prof)) ?>')">🖨️ Imprimir</button>
            </div>
            <div class="content-to-download">
                
                <div class="visto-label">
                    <strong>Visto</strong>
                </div>
                <div class="visto-assinatura">
                    O DIRECTOR<br><br>
                    __________________________<br>
                    Eduardo Sanjambela Tchandja
                </div>
                <div class="header-print" style="position: relative; text-align:center; font-family: Arial; margin-bottom: 10px;">
                    <img src="insignia/insignia.png" alt="Insígnia" style="height: 80px; margin-bottom: 10px;">
                    <p style="font-weight: normal; margin: 0;">REPÚBLICA DE ANGOLA</p>
                    <p style="margin: 2px 0; font-weight: normal;">GOVERNO PROVINCIAL DE BENGUELA</p>
                    <p style="margin: 2px 0; font-weight: normal;">GABINETE PROVINCIAL DA EDUCAÇÃO</p>
                    <p style="margin: 2px 0 15px; font-weight: normal;">COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK - CATUMBELA</p>
                    <h3 style="font-weight:bold; text-align:center; margin: 0;">HORÁRIO ESCOLAR</h3>
                    <h3 style="font-weight:bold; text-align:center; margin: 0;">Ano Lectivo: 2025/2026</h3>
                </div>

                <div style="font-family: Arial; font-size: 12px; margin-bottom: 10px; text-align: left; width: 80%; margin-left: auto; margin-right: auto;">
                    <p>
                        <b>NOME DO PROFESSOR:</b> <?= htmlspecialchars($prof) ?> / 
                        <b>DISCIPLINAS:</b> <?= htmlspecialchars(implode(", ", $disciplinas_por_professor_geral[$prof])) ?> / 
                        <b>CARGA HORÁRIA:</b> <?= intval($carga_professores_final[$prof]) ?> tempos semanais
                    </p>
                </div>
                
                <?php if (in_array('manhã', $professor_turnos[$prof])): ?>
                <h4>Horário - Turno da Manhã</h4>
                <table>
                    <thead>
                        <tr><th class="coluna-hora">Hora</th><?php foreach ($dias as $d) echo "<th>$d</th>"; ?></tr>
                    </thead>
                    <tbody>
                        <?php
                        $tempos_manha = ['7:30-8:15', '8:20-9:05', '9:10-9:55', '10:10-10:55', '11:00-11:45', '11:50-12:35'];
                        for ($i = 0; $i < 6; $i++): ?>
                            <tr>
                                <td class="coluna-hora"><?= $tempos_manha[$i] ?></td>
                                <?php foreach ($dias as $dia): ?>
                                    <td class="editable" contenteditable="false"><?= $horario_professores_manhã[$prof][$dia][$i] ?? '' ?></td>
                                <?php endforeach; ?>
                            </tr>
                        <?php endfor; ?>
                    </tbody>
                </table>
                <?php endif; ?>

                <?php if (in_array('tarde', $professor_turnos[$prof])): ?>
                <h4>Horário - Turno da Tarde</h4>
                <table>
                    <thead>
                        <tr><th class="coluna-hora">Hora</th><?php foreach ($dias as $d) echo "<th>$d</th>"; ?></tr>
                    </thead>
                    <tbody>
                        <?php
                        $tempos_tarde = ['13:00-13:45', '13:50-14:35', '14:40-15:25', '15:30-16:15', '16:20-17:05', '17:10-17:55'];
                        for ($i = 0; $i < 6; $i++): ?>
                            <tr>
                                <td class="coluna-hora"><?= $tempos_tarde[$i] ?></td>
                                <?php foreach ($dias as $dia): ?>
                                    <td class="editable" contenteditable="false"><?= $horario_professores_tarde[$prof][$dia][$i] ?? '' ?></td>
                                <?php endforeach; ?>
                            </tr>
                        <?php endfor; ?>
                    </tbody>
                </table>
                <?php endif; ?>

                <?= rodapeComData() ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<script>
function exibirHorarios() {
    document.getElementById('horarios-gerados').style.display = 'block';
    document.getElementById('btnExibir').style.display = 'none';
}

function downloadHorario(elementId, filename) {
    const element = document.getElementById(elementId).querySelector('.content-to-download') || document.getElementById(elementId);
    
    // Temporariamente desabilita a edição para o download
    const editables = element.querySelectorAll('[contenteditable="true"]');
    editables.forEach(td => td.setAttribute('contenteditable', 'false'));
    
    html2pdf(element, {
        margin: 10,
        filename: `${filename}.pdf`,
        image: { type: 'jpeg', quality: 0.98 },
        html2canvas: { scale: 2 },
        jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' }
    }).then(() => {
        // Re-habilita a edição após o download
        editables.forEach(td => td.setAttribute('contenteditable', 'true'));
    });
}

function imprimirHorario(elementId) {
    const element = document.getElementById(elementId).querySelector('.content-to-download') || document.getElementById(elementId);
    
    // Temporariamente desabilita a edição para a impressão
    const editables = element.querySelectorAll('[contenteditable="true"]');
    editables.forEach(td => td.setAttribute('contenteditable', 'false'));

    // Criar um novo documento para impressão
    const printWindow = window.open('', '_blank');
    printWindow.document.write('<html><head><title>Imprimir Horário</title>');
    // Copiar os estilos do documento original
    printWindow.document.write('<style>');
    // Copiar todos os estilos do head do documento principal
    for (const styleSheet of document.styleSheets) {
        try {
            if (styleSheet.cssRules) {
                for (const rule of styleSheet.cssRules) {
                    printWindow.document.write(rule.cssText);
                }
            }
        } catch (e) {
            console.warn("Couldn't read stylesheet: " + styleSheet.href, e);
        }
    }
    printWindow.document.write('</style>');
    printWindow.document.write('</head><body>');
    printWindow.document.write(element.outerHTML); // Conteúdo a ser impresso
    printWindow.document.write('</body></html>');
    printWindow.document.close();
    printWindow.focus();
    printWindow.print();
    printWindow.close();


    // Re-habilita a edição (apenas se a página principal ainda estiver em modo de edição)
    const originalContainer = document.getElementById(elementId);
    if (originalContainer.classList.contains('edit-mode')) {
        const originalEditables = originalContainer.querySelectorAll('.editable');
        originalEditables.forEach(td => td.setAttribute('contenteditable', 'true'));
    }
}

function toggleEdicao(containerId) {
    const container = document.getElementById(containerId);
    const cells = container.querySelectorAll('.editable');
    
    const isEditMode = container.classList.toggle('edit-mode');
    
    const editButton = container.querySelector('.horario-buttons button');
    if (isEditMode) {
        editButton.textContent = '✅ Salvar Edição';
        editButton.onclick = () => salvarEdicao(containerId);
        cells.forEach(cell => {
            cell.setAttribute('contenteditable', 'true');
        });
    } else {
        editButton.textContent = '✏️ Editar';
        editButton.onclick = () => toggleEdicao(containerId);
        cells.forEach(cell => {
            cell.setAttribute('contenteditable', 'false');
        });
    }
}

function salvarEdicao(containerId) {
    const container = document.getElementById(containerId);
    const dadosEditados = {};
    const dias = ['Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta'];
    const linhas = container.querySelectorAll('tbody tr');

    linhas.forEach(linha => {
        const celulas = linha.querySelectorAll('td');
        const tempo = celulas[0].textContent;
        dadosEditados[tempo] = {};

        for (let i = 1; i < celulas.length; i++) {
            dadosEditados[tempo][dias[i-1]] = celulas[i].textContent.trim();
        }
    });

    fetch('salvar_horario_editado.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({
            container_id: containerId,
            horario: dadosEditados
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert(data.message);
        } else {
            alert('Erro: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        alert('Ocorreu um erro ao conectar com o servidor.');
    });

    toggleEdicao(containerId);
}
</script>

</body>
</html>