<!-- === consultar_nota_aluno.php === -->
<?php include 'config.php'; ?>
<h2>Consultar Notas do Aluno</h2>
<form method="GET">
    Nome do aluno: <input type="text" name="nome" required><br>
    Turma:
    <select name="turma_id">
        <?php
        $turmas = $conn->query("SELECT id, nome FROM turmas")->fetchAll();
        foreach ($turmas as $turma) {
            echo "<option value='{$turma['id']}'>{$turma['nome']}</option>";
        }
        ?>
    </select><br>
    Trimestre:
    <select name="trimestre">
        <option value="1">1º</option>
        <option value="2">2º</option>
        <option value="3">3º</option>
    </select><br>
    <button type="submit">Consultar</button>
</form>
<?php
if (isset($_GET['nome'], $_GET['turma_id'], $_GET['trimestre'])) {
    $stmt = $conn->prepare("SELECT * FROM alunos WHERE nome LIKE ? AND turma_id = ?");
    $stmt->execute(['%' . $_GET['nome'] . '%', $_GET['turma_id']]);
    $aluno = $stmt->fetch();

    if ($aluno) {
        echo "<h3>Aluno: {$aluno['nome']}</h3>";
        $turma = $conn->query("SELECT nome FROM turmas WHERE id = {$aluno['turma_id']}")->fetchColumn();
        echo "<p>Turma: $turma</p>";

        $disciplinas = $conn->query("SELECT id, nome FROM disciplinas WHERE turma_id = {$aluno['turma_id']}")->fetchAll();

        echo "<table border='1'><tr><th>Disciplina</th><th>MAC</th><th>NPP</th><th>NPT</th><th>MT</th></tr>";
        foreach ($disciplinas as $disc) {
            $stmt = $conn->prepare("SELECT mac, npp, npt FROM notas WHERE aluno_id = ? AND disciplina_id = ? AND trimestre = ?");
            $stmt->execute([$aluno['id'], $disc['id'], $_GET['trimestre']]);
            $nota = $stmt->fetch();

            if ($nota) {
                $mt = round(($nota['mac'] + $nota['npp'] + $nota['npt']) / 3, 1);
                echo "<tr><td>{$disc['nome']}</td><td>{$nota['mac']}</td><td>{$nota['npp']}</td><td>{$nota['npt']}</td><td>$mt</td></tr>";
            } else {
                echo "<tr><td>{$disc['nome']}</td><td colspan='4'>Sem notas</td></tr>";
            }
        }
        echo "</table>";
    } else {
        echo "<p style='color:red;'>Aluno não encontrado.</p>";
    }
}
?>

