<?php
// criptografar_senhas.php

include 'conexao.php'; // conexão com o banco ($conn)

// Seleciona todos os usuários
$sql = "SELECT id, senha FROM usuarios";
$result = $conn->query($sql);

// Verifica se há registros
if ($result->num_rows > 0) {
    while ($usuario = $result->fetch_assoc()) {
        $id = $usuario['id'];
        $senhaAtual = $usuario['senha'];

        // Verifica se a senha já está criptografada (pelo tamanho e prefixo do hash)
        if (strlen($senhaAtual) < 60 || !preg_match('/^\$2y\$/', $senhaAtual)) {
            // Criptografa a senha
            $senhaCriptografada = password_hash($senhaAtual, PASSWORD_DEFAULT);

            // Atualiza no banco
            $stmt = $conn->prepare("UPDATE usuarios SET senha = ? WHERE id = ?");
            $stmt->bind_param("si", $senhaCriptografada, $id);
            $stmt->execute();

            echo "Senha do usuário ID $id criptografada com sucesso.<br>";
        } else {
            echo "Senha do usuário ID $id já está criptografada.<br>";
        }
    }
} else {
    echo "Nenhum usuário encontrado.";
}

$conn->close();
?>

