<?php
session_start();
include 'conexao.php';

// Verifica se é um usuário autorizado
if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}

// Processa o formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $turma_id = $_POST['turma_id'];
    $disciplina_id = $_POST['disciplina_id'];
    $tempos_semana = $_POST['tempos_semana'];
    // Captura o professor_id do formulário
    $professor_id = $_POST['professor_id'];

    // Verifica se já existe uma atribuição para essa turma e disciplina
    $check = $conn->prepare("SELECT id FROM atribuicoes WHERE turma_id = ? AND disciplina_id = ?");
    $check->bind_param("ii", $turma_id, $disciplina_id);
    $check->execute();
    $check->store_result();

    if ($check->num_rows > 0) {
        // Atualiza a atribuição existente
        $update = $conn->prepare("UPDATE atribuicoes SET tempos_semana = ?, professor_id = ? WHERE turma_id = ? AND disciplina_id = ?");
        $update->bind_param("iiii", $tempos_semana, $professor_id, $turma_id, $disciplina_id);
        $update->execute();
    } else {
        // Insere nova atribuição
        $insert = $conn->prepare("INSERT INTO atribuicoes (professor_id, turma_id, disciplina_id, tempos_semana) VALUES (?, ?, ?, ?)");
        $insert->bind_param("iiii", $professor_id, $turma_id, $disciplina_id, $tempos_semana);
        $insert->execute();
    }

    $mensagem = "Tempos semanais definidos com sucesso!";
}

// 🔹 Buscar turmas com dados adicionais (classe, curso, turno, sala)
$turmas = $conn->query("
    SELECT id, nome, classe, curso, turno, sala 
    FROM turmas 
    ORDER BY nome
")->fetch_all(MYSQLI_ASSOC);

// 🔹 Buscar apenas disciplinas que foram atribuídas a pelo menos uma turma
$disciplinas = $conn->query("
    SELECT DISTINCT d.id, d.nome 
    FROM disciplinas d
    JOIN atribuicoes a ON a.disciplina_id = d.id
    ORDER BY d.nome
")->fetch_all(MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Definir Tempos por Disciplina</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f4f6f9;
            padding: 40px;
        }
        .container {
            background: white;
            padding: 30px;
            max-width: 600px;
            margin: auto;
            border-radius: 10px;
            box-shadow: 0 0 8px rgba(0,0,0,0.1);
        }
        h2 {
            text-align: center;
            color: #003366;
        }
        form {
            margin-top: 20px;
        }
        label {
            font-weight: bold;
            display: block;
            margin-top: 15px;
        }
        select, button {
            width: 100%;
            padding: 10px;
            margin-top: 5px;
            font-size: 16px;
            border-radius: 5px;
            border: 1px solid #ccc;
        }
        button {
            background-color: #28a745;
            color: white;
            font-weight: bold;
            margin-top: 20px;
            cursor: pointer;
        }
        button:hover {
            background-color: #218838;
        }
        .mensagem {
            background-color: #d4edda;
            color: #155724;
            padding: 12px;
            border-left: 5px solid #28a745;
            border-radius: 5px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Definir Tempos Semanais</h2>

    <?php if (!empty($mensagem)): ?>
        <div class="mensagem"><?= $mensagem ?></div>
    <?php endif; ?>

    <form method="post">
        <label for="turma_id">Turma:</label>
        <select name="turma_id" id="turma_id" required>
            <option value="">-- Selecione a Turma --</option>
            <?php foreach ($turmas as $t): ?>
                <option value="<?= $t['id'] ?>">
                    <?= htmlspecialchars($t['nome'] . " - " . $t['classe'] . " - " . $t['curso'] . " - " . $t['turno'] . " (sala " . $t['sala'] . ")") ?>
                </option>
            <?php endforeach; ?>
        </select>

        <label for="disciplina_id">Disciplina:</label>
        <select name="disciplina_id" id="disciplina_id" required>
            <option value="">-- Selecione a Disciplina --</option>
            <?php foreach ($disciplinas as $d): ?>
                <option value="<?= $d['id'] ?>"><?= htmlspecialchars($d['nome']) ?></option>
            <?php endforeach; ?>
        </select>

        <label for="professor_id">Professor:</label>
        <select name="professor_id" id="professor_id" required>
            <option value="">-- Selecione o Professor --</option>
            <?php
            $professores = $conn->query("SELECT id, nome FROM usuarios WHERE perfil = 'Professor' ORDER BY nome")->fetch_all(MYSQLI_ASSOC);
            foreach ($professores as $p):
            ?>
                <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['nome']) ?></option>
            <?php endforeach; ?>
        </select>

        <label for="tempos_semana">Nº de Tempos Semanais:</label>
        <select name="tempos_semana" id="tempos_semana" required>
            <option value="">-- Escolha --</option>
            <?php for ($i = 0; $i <= 6; $i++): ?>
                <option value="<?= $i ?>"><?= $i ?> tempo(s)</option>
            <?php endfor; ?>
        </select>

        <button type="submit">Salvar</button>
    </form>
</div>
</body>
</html>