<?php
include 'conexao.php';

$turmaId = $_GET['turma_id'] ?? 0;

// Buscar dados da turma
$stmtTurma = $conn->prepare("SELECT * FROM turmas WHERE id = ?");
$stmtTurma->bind_param("i", $turmaId);
$stmtTurma->execute();
$resTurma = $stmtTurma->get_result();
$turma = $resTurma->fetch_assoc();

// Buscar alunos da turma
$stmtAlunos = $conn->prepare("SELECT nome, idade, genero FROM alunos WHERE turma_id = ? ORDER BY nome");
$stmtAlunos->bind_param("i", $turmaId);
$stmtAlunos->execute();
$resAlunos = $stmtAlunos->get_result();

$alunos = [];
while ($row = $resAlunos->fetch_assoc()) {
    $alunos[] = $row;
}

echo json_encode([
    "turma" => $turma,
    "alunos" => $alunos
]);
