<?php
include 'conexao.php';

$turma_id = $_GET['turma_id'] ?? 0;

$stmt = $conn->prepare("
  SELECT d.id, d.nome 
  FROM atribuicoes a 
  INNER JOIN disciplinas d ON a.disciplina_id = d.id 
  WHERE a.turma_id = ?
  GROUP BY d.id, d.nome
");
$stmt->bind_param("i", $turma_id);
$stmt->execute();
$res = $stmt->get_result();

$disciplinas = [];
while ($row = $res->fetch_assoc()) {
    $disciplinas[] = $row;
}

header('Content-Type: application/json');
echo json_encode($disciplinas);
