<?php
session_start();
include 'conexao.php';

$relatorio = [];

function distribuirAlunos(mysqli $conn, $curso, $maxPorTurma, &$relatorio) {
    // Buscar turmas da 10ª do curso correspondente
    $stmt = $conn->prepare("SELECT id, nome FROM turmas WHERE nome LIKE '10ª %' AND nome LIKE CONCAT('%', ?, '%') ORDER BY nome ASC");
    $stmt->bind_param("s", $curso);
    $stmt->execute();
    $turmas = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    if (empty($turmas)) return;

    // Buscar alunos admitidos do curso
    $stmt = $conn->prepare("SELECT * FROM novos_alunos WHERE curso = ? AND obs = 'Admitido' ORDER BY nome ASC");
    $stmt->bind_param("s", $curso);
    $stmt->execute();
    $alunos = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    $indexTurma = 0;
    $contador = 1;

    foreach ($alunos as $aluno) {
        if (!isset($turmas[$indexTurma])) break;

        $turmaId = $turmas[$indexTurma]['id'];
        $turmaNome = $turmas[$indexTurma]['nome'];

        // Verificar se turma já está cheia
        $stmt = $conn->prepare("SELECT COUNT(*) AS total FROM alunos WHERE turma_id = ?");
        $stmt->bind_param("i", $turmaId);
        $stmt->execute();
        $total = $stmt->get_result()->fetch_assoc()['total'];
        $stmt->close();

        if ($total >= $maxPorTurma) {
            $indexTurma++;
            $contador = 1;
            continue;
        }

        // Senha padrão: número de ordem
        $senhaHash = password_hash($contador, PASSWORD_DEFAULT);

        // Inserir aluno na tabela alunos
        $stmt = $conn->prepare("INSERT INTO alunos (nome, idade, genero, curso, turma_id, numero, senha, obs) VALUES (?, ?, ?, ?, ?, ?, ?, 'Admitido')");
        $stmt->bind_param(
            "sississ",
            $aluno['nome'],
            $aluno['idade'],
            $aluno['genero'],
            $aluno['curso'],
            $turmaId,
            $contador,
            $senhaHash
        );
        $stmt->execute();
        $stmt->close();

        // Excluir da tabela novos_alunos
        $stmt = $conn->prepare("DELETE FROM novos_alunos WHERE id = ?");
        $stmt->bind_param("i", $aluno['id']);
        $stmt->execute();
        $stmt->close();

        $relatorio[] = "{$aluno['nome']} → {$turmaNome} (Nº {$contador})";
        $contador++;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    distribuirAlunos($conn, 'E.INF', 40, $relatorio);
    distribuirAlunos($conn, 'E.PRIM', 40, $relatorio);
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Distribuição de Alunos - SISMAG</title>
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background: #f4f6f9;
      margin: 0;
      padding: 30px;
    }
    .caixa {
      background: white;
      padding: 30px;
      border-radius: 10px;
      max-width: 800px;
      margin: auto;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    h2 {
      color: #003366;
      text-align: center;
    }
    .msg {
      background: #d4edda;
      color: #155724;
      padding: 10px;
      border-radius: 5px;
      margin: 20px 0;
    }
    ul {
      margin-top: 15px;
      padding-left: 20px;
    }
    .voltar {
      display: block;
      text-align: center;
      margin-top: 30px;
    }
    .voltar a {
      background: #003366;
      color: white;
      padding: 10px 20px;
      text-decoration: none;
      border-radius: 6px;
      font-weight: bold;
    }
    .voltar a:hover {
      background: #0055aa;
    }
  </style>
</head>
<body>

<div class="caixa">
  <h2>Distribuição Finalizada</h2>

  <?php if (!empty($relatorio)): ?>
    <div class="msg">
      <strong><?= count($relatorio) ?> alunos foram distribuídos com sucesso:</strong>
      <ul>
        <?php foreach ($relatorio as $linha): ?>
          <li><?= htmlspecialchars($linha) ?></li>
        <?php endforeach; ?>
      </ul>
    </div>
  <?php else: ?>
    <div class="msg" style="background:#f8d7da; color:#721c24;">
      Nenhum aluno admitido encontrado para distribuição.
    </div>
  <?php endif; ?>

  <div class="voltar">
    <a href="painel.php">⬅ Voltar ao Painel</a>
  </div>
</div>

</body>
</html>
