<?php
//
// =========================================================================
// documento_oficial.php - Ficha de Avaliação para Impressão
// AJUSTADO PARA CABER NUMA ÚNICA FOLHA.
// =========================================================================
 
// --- CONFIGURAÇÃO DE CONEXÃO ---
define('DB_HOST', 'localhost');
define('DB_PORT', '3307');
define('DB_NAME', 'sismag'); 
define('DB_USER', 'root');
define('DB_PASS', '');
 
$pdo = null;
 
try {
    $dsn = "mysql:host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME . ";charset=utf8";
    $pdo = new PDO($dsn, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("ERRO DE CONEXÃO COM A BASE DE DADOS 'sismag': " . $e->getMessage());
}
 
// --- DEFINIÇÕES DE DATA E TRIMESTRE ---
$ANO_ATUAL = date('Y'); 
$TRIMESTRES_DISPONIVEIS = [
    1 => 'I Trimestre (Jan-Mar)',
    2 => 'II Trimestre (Abr-Jun)',
    3 => 'III Trimestre (Jul-Set)',
    4 => 'IV Trimestre (Out-Dez)',
];

// --- VARIÁVEIS DE REQUISIÇÃO ---
$id_selecionado = isset($_REQUEST['id']) ? (int)$_REQUEST['id'] : null;
$trimestre_url = isset($_REQUEST['trimestre']) ? (int)$_REQUEST['trimestre'] : null;
$modo = isset($_REQUEST['modo']) ? $_REQUEST['modo'] : 'trimestral'; // 'trimestral' ou 'anual'
$usuario_selecionado = null;
$dados_avaliacao = [];
$pontuacao_final = [
    'pontuacao_quantitativa' => 0,
    'classificacao_qualitativa' => 'N/A',
    'apreciacao_avaliador' => 'Nenhuma apreciação registrada.',
];
 
// --- DEFINIÇÕES DA AVALIAÇÃO COM PESOS E CRITÉRIOS ---
$detalhes_avaliacao = [
    'I. Qualidade do Ensino e Aprendizagem (Peso: 0,2)' => [
        'I_QA' => [
            'nome' => 'Qualidade do Processo de Ensino e Aprendizagem', 
            'peso' => 0.2,
            'criterios' => [5 => '...', 10 => '...', 15 => '...', 20 => '...']
        ],
    ],
    'II. Progresso do Aluno (Peso: 0,3)' => [
        'II_PA' => [
            'nome' => 'Progresso do Aluno ou Desenvolvimento do Aluno', 
            'peso' => 0.3,
            'criterios' => [5 => '...', 10 => '...', 15 => '...', 20 => '...']
        ],
    ],
    'IV. Aperfeiçoamento Profissional e Inovação Pedagógica (Peso: 0,2)' => [
        'IV_AP' => [
            'nome' => 'Aperfeiçoamento Profissional e Inovação Pedagógica', 
            'peso' => 0.2,
            'criterios' => [5 => '...', 10 => '...', 15 => '...', 20 => '...']
        ],
    ],
    'III. Responsabilidade (Peso: 0,1)' => [
        'III_R' => [
            'nome' => 'Responsabilidade', 
            'peso' => 0.1,
            'criterios' => [5 => '...', 10 => '...', 15 => '...', 20 => '...']
        ],
    ],
    'V. Relações Humanas (Peso: 0,2)' => [
        'V_RH' => [
            'nome' => 'Relações Humanas', 
            'peso' => 0.2,
            'criterios' => [5 => '...', 10 => '...', 15 => '...', 20 => '...']
        ],
    ],
];

// Mapeamento dos códigos internos para a ordem exibida nas tabelas
$mapa_indicadores = [
    'I_QA' => 'Qualidade do Processo de Ensino e Aprendizagem', 
    'II_PA' => 'Progresso do Aluno ou Desenvolvimento do Aluno', 
    'IV_AP' => 'Aperfeiçoamento Profissional e Inovação Pedagógica', 
    'III_R' => 'Responsabilidade', 
    'V_RH' => 'Relações Humanas', 
];

// --- LÓGICA DE BUSCA E AGREGAÇÃO DE DADOS ---
$data_avaliacao_str = date('d/m/Y'); 
$agente_numero = '___________________'; // Valor padrão caso não encontre

if ($id_selecionado) {
    // 1. Busca dados do funcionário
    $stmt = $pdo->prepare("SELECT id, nome, perfil, agente FROM usuarios WHERE id = ?");
    $stmt->execute([$id_selecionado]);
    $usuario_selecionado = $stmt->fetch();
    
    if ($usuario_selecionado) {
        $agente_numero = $usuario_selecionado['agente'] ?? '___________________';
        
        // Fetch the last saved date for 'Data da Avaliação'
        $stmt_last_save = $pdo->prepare("SELECT MAX(data_avaliacao) as last_date FROM avaliacao_item WHERE usuario_id = ?");
        $stmt_last_save->execute([$id_selecionado]);
        $last_save_date = $stmt_last_save->fetch();
        if ($last_save_date && $last_save_date['last_date']) {
            $data_avaliacao_str = (new DateTime($last_save_date['last_date']))->format('d/m/Y');
        }
        
        $trimestres_a_buscar = array_keys($TRIMESTRES_DISPONIVEIS);
        $dados_anual_sumario = []; 
        
        // Inicializa a estrutura do sumário anual
        foreach ($mapa_indicadores as $codigo => $nome) {
            $dados_anual_sumario[$codigo] = [
                'nome' => $nome,
                'trimestres' => array_fill_keys($trimestres_a_buscar, null)
            ];
        }
        
        $total_final_ponderado_anual = 0;
        $total_avaliacoes_anual = 0;

        foreach ($trimestres_a_buscar as $trimestre) {
            
            $stmt_final = $pdo->prepare("SELECT pontuacao_quantitativa, classificacao_qualitativa, apreciacao_avaliador FROM avaliacao_final WHERE usuario_id = ? AND ano = ? AND trimestre = ?");
            $stmt_final->execute([$id_selecionado, $ANO_ATUAL, $trimestre]);
            $resultado_final = $stmt_final->fetch();

            $stmt_itens = $pdo->prepare("SELECT item_codigo, pontuacao_atribuida FROM avaliacao_item WHERE usuario_id = ? AND ano = ? AND trimestre = ?");
            $stmt_itens->execute([$id_selecionado, $ANO_ATUAL, $trimestre]);
            $itens_avaliados = $stmt_itens->fetchAll(PDO::FETCH_KEY_PAIR);
            
            if ($resultado_final || $itens_avaliados) {
                
                // --- MODO TRIMESTRAL: Captura dados específicos ---
                if ($modo === 'trimestral' && $trimestre == $trimestre_url) {
                    // Substituído '?:' e '??' por operadores ternários completos para compatibilidade
                    $pontuacao_final = $resultado_final ? $resultado_final : $pontuacao_final;
                    $pontuacao_final['apreciacao_avaliador'] = (isset($resultado_final['apreciacao_avaliador']) && $resultado_final['apreciacao_avaliador'] !== null) ? $resultado_final['apreciacao_avaliador'] : 'Nenhuma apreciação registrada.';

                    $total_ponderado_trimestre = 0;
                    $detalhes_trimestre = [];
                    foreach ($detalhes_avaliacao as $seccao_titulo => $itens_seccao) {
                             foreach ($itens_seccao as $codigo => $detalhe) {
                                // Substituído '??' por ternário completo
                                $ponto_atribuido = isset($itens_avaliados[$codigo]) ? $itens_avaliados[$codigo] : 0;
                                $pontuacao_ponderada = $ponto_atribuido * $detalhe['peso'];
                                $total_ponderado_trimestre += $pontuacao_ponderada;
                                
                                $detalhes_trimestre[$codigo] = [
                                    'ponto_atribuido' => $ponto_atribuido,
                                    'pontuacao_ponderada' => $pontuacao_ponderada,
                                ];
                            }
                    }
                    $dados_avaliacao[$trimestre] = [
                        'detalhes_itens' => $detalhes_trimestre,
                        'total_ponderado' => $total_ponderado_trimestre,
                        'classificacao_final' => (isset($resultado_final['classificacao_qualitativa']) && $resultado_final['classificacao_qualitativa'] !== null) ? $resultado_final['classificacao_qualitativa'] : 'N/A'
                    ];
                }
                
                // --- MODO ANUAL: Agrega pontos por indicador ---
                if ($resultado_final && $resultado_final['pontuacao_quantitativa'] > 0) {
                    $total_final_ponderado_anual += $resultado_final['pontuacao_quantitativa'];
                    $total_avaliacoes_anual++;
                    
                    foreach ($mapa_indicadores as $codigo => $nome) {
                        $ponto_atribuido = isset($itens_avaliados[$codigo]) ? $itens_avaliados[$codigo] : null;
                        if (isset($dados_anual_sumario[$codigo]) && $ponto_atribuido !== null) {
                             $dados_anual_sumario[$codigo]['trimestres'][$trimestre] = $ponto_atribuido;
                        }
                    }
                }
            }
        }
        
        // --- CÁLCULO FINAL ANUAL ---
        if ($modo === 'anual' && $total_avaliacoes_anual > 0) {
            $media_ponderada_anual = $total_final_ponderado_anual / $total_avaliacoes_anual;
            $classif_qualitativa_anual = ($media_ponderada_anual > 17) ? 'Excelente' : ($media_ponderada_anual > 14 ? 'Muito Bom' : 'Bom');
            
            $pontuacao_final['pontuacao_quantitativa'] = $media_ponderada_anual;
            $pontuacao_final['classificacao_qualitativa'] = $classif_qualitativa_anual;
            
            // Calcula o 'Pontos' (Média Arredondada dos pontos atribuídos)
            foreach ($dados_anual_sumario as $codigo => &$dados_item) {
                $total_pontos = 0;
                $count_pontos = 0;
                foreach ($dados_item['trimestres'] as $ponto) {
                    if ($ponto !== null && $ponto > 0) {
                        $total_pontos += $ponto;
                        $count_pontos++;
                    }
                }
                $dados_item['pontos_anual'] = $count_pontos > 0 ? number_format($total_pontos / $count_pontos, 0) : ''; 
            }
            unset($dados_item); 
        }
    }
}

if (!$usuario_selecionado || ($modo === 'trimestral' && empty($dados_avaliacao[$trimestre_url])) || ($modo === 'anual' && $total_avaliacoes_anual === 0)) {
    die("<h1>Erro</h1><p>Nenhum dado de avaliação encontrado para este funcionário e período.</p>");
}

$titulo_documento = ($modo === 'anual') ? "FICHA DE AVALIAÇÃO DE DESEMPENHO ANUAL DO PROFESSOR" : "FICHA DE AVALIAÇÃO DE DESEMPENHO TRIMESTRAL DO PROFESSOR";

?>
 
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $titulo_documento ?></title>
    <style>
        /* AJUSTES CRÍTICOS PARA CABER NUMA ÚNICA FOLHA A4 */
        body { 
            font-family: 'Times New Roman', Times, serif; 
            margin: 0; 
            padding: 10mm; /* Reduzido de 20mm */
            font-size: 10pt; /* Reduzido de 11pt */
            line-height: 1.2; 
        }
        .document-container { 
            width: 100%; 
            max-width: 190mm; /* Uso máximo do espaço */
            margin: 0 auto; 
        }
        
        /* Cabeçalho */
        .header { text-align: center; margin-bottom: 5px; /* Reduzido */ }
        .header img { width: 50px; height: auto; margin: 0 auto 5px auto; display: block; } /* Imagem menor */
        .header h2 { font-size: 12pt; margin-top: 2px; } /* Reduzido */
        .header h3 { font-size: 10.5pt; font-weight: normal; } /* Reduzido */
        .header .document-title { font-size: 11.5pt; font-weight: bold; margin-top: 8px; text-decoration: underline; } 
        .header .anexo-ref { font-size: 8.5pt; margin-top: 3px; } /* Reduzido */

        /* Metadados */
        .metadata-fields { margin-top: 10px; font-size: 10pt; } 
        .metadata-fields p { margin: 5px 0; } /* Reduzido */
        .metadata-fields strong { font-weight: bold; margin-right: 5px; }
        .metadata-fields span { border-bottom: 1px solid #000; padding: 0 5px; display: inline-block; min-width: 150px; }
        
        /* Tabelas */
        .evaluation-table, .simple-table { width: 100%; border-collapse: collapse; margin-top: 10px; font-size: 9.5pt; /* Reduzido */ }
        .evaluation-table th, .evaluation-table td, .simple-table th, .simple-table td { 
            border: 1px solid #000; 
            padding: 4px; /* Reduzido de 6px/8px */ 
            text-align: left; 
            vertical-align: top; 
        }
        .evaluation-table th, .simple-table th { background-color: #f0f0ff; text-align: center; font-weight: bold; }
        
        /* Classificação final */
        .final-classification th, .final-classification td { text-align: left; }
        .final-classification .pontuacao-final { text-align: center; font-weight: bold; }

        /* Apreciação e Comentários */
        .apreciacao-section { margin-top: 10px; } /* Reduzido */
        .apreciacao-section h4 { font-size: 10.5pt; border-bottom: 1px solid #000; padding-bottom: 3px; margin-bottom: 5px; } /* Reduzido */
        .apreciacao-box { 
            border: 1px solid #000; 
            min-height: 50px; /* REDUÇÃO SIGNIFICATIVA */ 
            padding: 5px; 
            white-space: pre-wrap; 
            overflow: hidden;
        }

        /* Assinaturas */
        .assinaturas { margin-top: 20px; font-size: 9pt; /* Reduzido */ }
        .assinaturas table { width: 100%; border: none; border-collapse: collapse; }
        .assinaturas td { border: none; text-align: center; padding: 10px 0; vertical-align: top; } /* Padding reduzido */
        .assinaturas .line { border-top: 1px solid #000; margin-top: 5px; display: block; }
        .assinaturas p { margin: 1px 0; } /* Margem mínima */
        
        /* Estilo para impressão */
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; padding: 5mm; /* Margem mínima */ }
            .document-container { max-width: none; margin: 0; }
        }
    </style>
</head>
<body>
 
<div class="document-container">

    <div class="no-print" style="margin-bottom: 20px; text-align: center;">
        <button onclick="window.print()" style="padding: 10px 20px; background-color: #3498db; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 1em;">
            🖨️ Imprimir Documento Oficial
        </button>
    </div>
    
    <div class="header">
        <img src="insignia/insignia.png" alt="Insígnia Oficial">
        <h2>REPÚBLICA DE ANGOLA</h2>
        <h3>GOVERNO PROVINCIAL DE BENGUELA</h3>
        <h3>GABINETE PROVINCIAL DA EDUCAÇÃO</h3>
        <h3>COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK-CATUMBELA</h3>
        <p class="document-title"><?= $titulo_documento ?></p>
        <p class="anexo-ref">
            <?= ($modo === 'anual') 
                ? 'Anexo III a que se refere o nº 3 do Artigo 17º do Decreto Presidencial n°28/22, de 27 de Janeiro' 
                : 'Anexo II a que se refere o nº 3 do Artigo 17º do Decreto Presidencial nº28/22, de 27 de Janeiro' 
            ?>
        </p>
    </div>
    
    <div class="metadata-fields">
        <p><strong>Nome completo:</strong> <span><?= htmlspecialchars($usuario_selecionado['nome']) ?></span></p>
        <p><strong>Categoria:</strong> <span><?= htmlspecialchars($usuario_selecionado['perfil']) ?></span></p>
        <p><strong>Agente N°:</strong> <span><?= htmlspecialchars($agente_numero) ?></span></p>
        <p><strong>Trimestre/Ano Lectivo:</strong> <span><?= ($modo === 'anual') ? $ANO_ATUAL : $TRIMESTRES_DISPONIVEIS[$trimestre_url] . ' / ' . $ANO_ATUAL ?></span></p>
        <p><strong>Data da Avaliação:</strong> <span><?= $data_avaliacao_str ?></span></p>
        <p><strong>Período a que respeita a Avaliação:</strong> De <span>___________</span> a <span>___________</span></p>
    </div>

    <?php if ($modo !== 'anual'): ?>
        <h4 style="margin-top: 20px; font-weight: bold; border-bottom: 1px solid #000; padding-bottom: 5px;">Pontuação dos Indicadores</h4>
    <?php endif; ?>

    <?php if ($modo === 'anual'): 
        // --- TABELA ANUAL (SUMÁRIO POR TRIMESTRE) ---
        ?>
        <h4 style="margin-top: 15px; font-weight: bold; border-bottom: 1px solid #000; padding-bottom: 3px;">Classificação Anual Trimestral dos Indicadores</h4>
        <table class="evaluation-table">
            <thead>
                <tr>
                    <th style="width: 5%;">N°</th>
                    <th style="width: 55%;">Indicadores</th>
                    <th style="width: 10%;">I Trim</th>
                    <th style="width: 10%;">II Trim</th>
                    <th style="width: 10%;">III Trim</th>
                    <th style="width: 10%;">Pontos (Média)</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $i = 1;
                foreach ($mapa_indicadores as $codigo => $nome): 
                    $dados_item = $dados_anual_sumario[$codigo] ?? [];
                ?>
                    <tr>
                        <td style="text-align: center;"><?= $i++ ?></td>
                        <td><?= htmlspecialchars($nome) ?></td>
                        <td style="text-align: center;"><?= $dados_item['trimestres'][1] ?? '' ?></td>
                        <td style="text-align: center;"><?= $dados_item['trimestres'][2] ?? '' ?></td>
                        <td style="text-align: center;"><?= $dados_item['trimestres'][3] ?? '' ?></td>
                        <td style="text-align: center; font-weight: bold;"><?= $dados_item['pontos_anual'] ?? '' ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: 
        // --- TABELA TRIMESTRAL (DETALHES DA PONTUAÇÃO PONDERADA) ---
        $dados = $dados_avaliacao[$trimestre_url];
        ?>
        <table class="simple-table">
            <thead>
                <tr>
                    <th style="width: 5%;">N°</th>
                    <th style="width: 70%;">Indicadores</th>
                    <th style="width: 25%;">Pontos</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $i = 1;
                $total_final_ponderado = 0;
                foreach ($mapa_indicadores as $codigo => $nome_indicador): 
                    $ponto_ponderado = $dados['detalhes_itens'][$codigo]['pontuacao_ponderada'] ?? 0;
                    $total_final_ponderado += $ponto_ponderado;
                ?>
                    <tr>
                        <td style="text-align: center;"><?= $i++ ?></td>
                        <td><?= htmlspecialchars($nome_indicador) ?></td>
                        <td style="text-align: center; font-weight: bold;"><?= number_format($ponto_ponderado, 2, '.', '') ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>

    <h4 style="margin-top: 15px; font-weight: bold; border-bottom: 1px solid #000; padding-bottom: 3px;">Classificação final</h4>
    <table class="simple-table final-classification">
        <tbody>
            <tr>
                <td style="width: 75%;">1. Quantitativa</td>
                <td class="pontuacao-final"><?= number_format($pontuacao_final['pontuacao_quantitativa'], 2, '.', '') ?></td>
            </tr>
            <tr>
                <td>2. Qualitativa</td>
                <td class="pontuacao-final"><?= htmlspecialchars($pontuacao_final['classificacao_qualitativa']) ?></td>
            </tr>
        </tbody>
    </table>

    <div class="apreciacao-section">
        <h4>Apreciação geral (Comentários dos Avaliadores)</h4>
        <div class="apreciacao-box">
            <?= nl2br(htmlspecialchars($pontuacao_final['apreciacao_avaliador'])) ?>
        </div>
    </div>
    
    <div class="assinaturas">
        <table style="width: 100%;">
            <tr>
                <td style="width: 33%;">
                    <span class="line">_____________________________________</span>
                    <p>O Avaliador</p>
                    <p>Nome: _______________________________</p>
                    <p>Função: _______________________________</p>
                    <p>Data: _______________________________</p>
                    <p style="margin-top: 5px;">
                        Concordância com a Avaliação: 
                        <span style="border: 1px solid #000; padding: 0 5px;">☐ Concordo</span> 
                        <span style="border: 1px solid #000; padding: 0 5px;">☐ Não concordo</span>
                    </p>
                </td>
                <td style="width: 33%;">
                    <span class="line">_____________________________________</span>
                    <p>O Avaliado</p>
                    <p>Nome: _______________________________</p>
                    <p>Data: _______________________________</p>
                </td>
                <td style="width: 33%;">
                    <span class="line">_____________________________________</span>
                    <p>O HOMOLOGANTE</p>
                    <p>Nome: _______________________________</p>
                    <p>Data: _______________________________</p>
                </td>
            </tr>
        </table>
    </div>
 
</div>
 
</body>
</html>