<?php
session_start();
include 'conexao.php'; 

$mensagem = '';
$aluno_preenchido = null;

// --- TRATAMENTO DO FORMULÁRIO DE EDIÇÃO (POST) ---
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['salvar_edicao'])) {
    
    // Coleta dos dados
    $aluno_id = $_POST['aluno_id'] ?? null;
    $nome_completo = trim($_POST['nome_completo'] ?? '');
    $idade = $_POST['idade'] ?? null;
    $genero = $_POST['genero'] ?? null;
    $data_nascimento = $_POST['data_nascimento'] ?? null;
    $contacto = $_POST['contacto'] ?? null;
    $endereco = $_POST['endereco'] ?? null;
    $opcao_lingua = $_POST['opcao_lingua'] ?? 'Português';
    $vez = $_POST['vez'] ?? 1;
    $observacoes = $_POST['observacoes'] ?? null;
    $foto_nome_atual = $_POST['foto_existente'] ?? null; 
    
    // O ID da turma é mantido apenas para referência no DB e não é editado neste painel
    $turma_id = $_POST['turma_id'] ?? null; 

    if ($aluno_id) {
        // Lógica de upload de foto
        if (isset($_FILES['foto']) && $_FILES['foto']['error'] === UPLOAD_ERR_OK) {
            $ext = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
            $foto_nome_atual = uniqid('foto_') . '.' . $ext;
            move_uploaded_file($_FILES['foto']['tmp_name'], "fotos_alunos/$foto_nome_atual");
        }
        
        // Prepara a query de atualização dos dados pessoais
        $stmt = $conn->prepare("UPDATE alunos SET 
            nome = ?, idade = ?, genero = ?, data_nascimento = ?, contacto = ?, 
            endereco = ?, foto = ?, opcao_lingua = ?, vez = ?, observacoes = ? 
            WHERE id = ?");
        
        if ($stmt === false) {
            $mensagem = "❌ Erro na preparação da query: " . $conn->error;
        } else {
            $stmt->bind_param("sisssssisii", 
                $nome_completo, $idade, $genero, $data_nascimento, $contacto, $endereco, 
                $foto_nome_atual, $opcao_lingua, $vez, $observacoes, $aluno_id);
            
            if ($stmt->execute()) {
                $mensagem = "✅ Dados do aluno atualizados com sucesso! ID: " . $aluno_id;
            } else {
                $mensagem = "❌ Erro ao atualizar dados do aluno: " . $stmt->error;
            }
            $stmt->close();
        }
    } else {
        $mensagem = "⚠️ Erro: Nenhum aluno selecionado para edição.";
    }
}

// Busca todos os alunos para o SELECT (APENAS ID E NOME)
$alunos = $conn->query("SELECT id, nome FROM alunos ORDER BY nome")->fetch_all(MYSQLI_ASSOC);

// Dropdowns de Turma (Apenas para exibir a informação atual)
$turmas = $conn->query("SELECT id, classe, nome, curso, turno, ano FROM turmas ORDER BY classe, sala")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Editar Aluno</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <style>
        * { box-sizing: border-box; }
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background-color: #f0f2f5; }
        .topbar { background-color: #007bff; color: white; padding: 15px 20px; font-size: 20px; position: fixed; top: 0; left: 0; right: 0; z-index: 1000; }
        .sidebar { position: fixed; top: 60px; left: 0; width: 220px; height: 100%; background-color: #111827; padding-top: 20px; }
        .sidebar a { display: block; color: white; padding: 12px 20px; text-decoration: none; font-weight: 500; }
        .sidebar a:hover { background-color: #1e3a8a; }
        .main { margin-left: 220px; padding: 80px 30px 30px 30px; }
        .container { max-width: 900px; background: #fff; padding: 30px; border-radius: 12px; box-shadow: 0 8px 20px rgba(0,0,0,0.1); }
        h2 { text-align: center; color: #007bff; margin-bottom: 25px; }
        form { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        .full { grid-column: 1 / 3; }
        label { display: block; font-weight: 600; margin-bottom: 5px; }
        input, select, textarea { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 8px; font-size: 14px; }
        input[type="file"] { padding: 6px; }
        button { background-color: #007bff; border: none; color: white; padding: 12px 20px; font-size: 16px; border-radius: 8px; cursor: pointer; transition: 0.3s; }
        button:hover { background-color: #0056b3; }
        .mensagem { margin-top: 20px; text-align: center; font-size: 16px; }
        .button-group { display: flex; justify-content: center; gap: 10px; }
        .info-box { background-color: #f9f9f9; padding: 10px; border: 1px dashed #ccc; border-radius: 8px; margin-top: 5px; }

        @media (max-width: 768px) {
            .sidebar { width: 100%; height: auto; position: relative; }
            .main { margin-left: 0; padding-top: 120px; }
            form { grid-template-columns: 1fr; }
            .full { grid-column: 1 / 2; }
            .button-group { flex-direction: column; }
        }
    </style>
</head>
<body>

<div class="topbar">
    📚 EMIL FRICK - Sistema de Gestão Escolar
</div>

<div class="sidebar">
    <a href="painel_secretaria_geral.php">🏠 Início</a>
    <a href="matricular_aluno.php">📋 Matricular Novo</a>
    <a href="editar_aluno.php">✏️ Editar Alunos</a>
    <a href="cadastrar_turma1.php">🏫 Turmas</a>
    <a href="login.php">🔓 Sair</a>
</div>

<div class="main">
    <div class="container">
        <h2>✏️ Editar Dados do Aluno</h2>
        <div class="full" style="text-align: center;">
            <?php if (!empty($mensagem)): ?>
                <div class="mensagem">
                    <?= $mensagem ?>
                </div>
            <?php endif; ?>
        </div>

        <form method="POST" action="" enctype="multipart/form-data" id="formEdicao">
            <input type="hidden" name="aluno_id" id="aluno_id" value="">
            <input type="hidden" name="foto_existente" id="foto_existente" value="">
            <input type="hidden" name="turma_id" id="turma_id_edicao" value="">

            <div class="full" style="margin-bottom: 20px;">
                <label>Selecionar Aluno para Edição:</label>
                <select id="aluno_select_completa" class="aluno_select">
                    <option value="">-- Selecione um aluno para carregar os dados --</option>
                    <?php foreach ($alunos as $a): ?>
                        <option value="<?= $a['id'] ?>">
                            <?= htmlspecialchars($a['nome']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="full">
                <label>Nome Completo:</label>
                <input type="text" name="nome_completo" id="nome_completo" value="" required disabled>
            </div>

            <div>
                <label>Idade:</label>
                <select name="idade" id="idade" required disabled>
                    <option value="">-- Selecione --</option>
                    <?php for ($i = 12; $i <= 60; $i++): ?>
                        <option value="<?= $i ?>"><?= $i ?> anos</option>
                    <?php endfor; ?>
                </select>
            </div>

            <div>
                <label>Género:</label>
                <select name="genero" id="genero" required disabled>
                    <option value="">-- Selecione --</option>
                    <option value="Masculino">Masculino</option>
                    <option value="Feminino">Feminino</option>
                    <option value="Outro">Outro</option>
                </select>
            </div>

            <div>
                <label>Data de Nascimento:</label>
                <input type="date" name="data_nascimento" id="data_nascimento" value="" disabled>
            </div>

            <div>
                <label>Contacto:</label>
                <input type="text" name="contacto" id="contacto" value="" disabled>
            </div>

            <div class="full">
                <label>Endereço:</label>
                <input type="text" name="endereco" id="endereco" value="" disabled>
            </div>
            
            <div class="full" id="turma_selecao_container">
                <label>Turma Atual:</label>
                <div class="info-box" id="turma_display">Selecione um aluno acima.</div>
            </div>
            
            <div class="full">
                <label>Foto do Aluno (Substituir):</label>
                <input type="file" name="foto" disabled id="foto_input">
            </div>

            <div>
                <label>Opção de Língua:</label>
                <select name="opcao_lingua" id="opcao_lingua" required disabled>
                    <option value="Português">Português</option>
                    <option value="Inglês">Inglês</option>
                    <option value="Francês">Francês</option>
                </select>
            </div>

            <div>
                <label>Vez da Matrícula:</label>
                <select name="vez" id="vez" required disabled>
                    <?php for ($i = 1; $i <= 5; $i++): ?>
                        <option value="<?= $i ?>"><?= $i ?>ª Vez</option>
                    <?php endfor; ?>
                </select>
            </div>
            
            <div class="full">
                <label>Observações:</label>
                <textarea name="observacoes" id="observacoes" rows="4" disabled></textarea>
            </div>

            <div class="full" style="text-align:center;">
                <div class="button-group">
                    <button type="submit" name="salvar_edicao" id="btn_salvar_edicao" disabled>✅ Salvar Alterações</button>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
$(function() {
    
    const camposFormulario = [
        '#nome_completo', '#idade', '#genero', '#data_nascimento', 
        '#contacto', '#endereco', '#opcao_lingua', '#vez', '#observacoes', 
        '#foto_input', '#btn_salvar_edicao'
    ];

    // 1. Função para habilitar/desabilitar o formulário
    function toggleFormulario(habilitar) {
        camposFormulario.forEach(selector => {
            $(selector).prop('disabled', !habilitar);
        });
    }

    // 2. Função para preencher os campos do formulário
    function preencherDadosAluno(dados) {
        // Preenche campos hidden e de texto
        $("#aluno_id").val(dados.id);
        $("#foto_existente").val(dados.foto); 
        $("#nome_completo").val(dados.nome);
        $("#data_nascimento").val(dados.data_nascimento);
        $("#contacto").val(dados.contacto);
        $("#endereco").val(dados.endereco);
        $("#observacoes").val(dados.observacoes);
        
        // Preenche selects
        $("#idade").val(dados.idade);
        $("#genero").val(dados.genero);
        $("#opcao_lingua").val(dados.opcao_lingua);
        $("#vez").val(dados.vez);
        
        // Exibe a informação de turma
        const turmaTexto = `${dados.classe ? dados.classe + 'ª ' : ''}${dados.nome_turma || 'N/A'} - ${dados.curso || 'N/A'} (${dados.turno || 'N/A'})`;
        $('#turma_display').text(turmaTexto);
        $('#turma_id_edicao').val(dados.turma_id); 
        
        // Habilita a edição
        toggleFormulario(true);
    }
    
    // 3. Listener para o campo SELECT
    $("#aluno_select_completa").on("change", function() {
        const alunoId = $(this).val();
        
        if (alunoId === "") {
            // Selecionou a opção inicial - limpa e desabilita
            $("#aluno_id").val("");
            $("#formEdicao")[0].reset();
            $('#turma_display').text("Selecione um aluno acima.");
            toggleFormulario(false);
            
        } else {
            // Selecionou um aluno existente - faz a busca via AJAX
            $('#turma_display').text("Carregando..."); // Feedback visual

            $.ajax({
                url: "buscar_aluno_dados.php",
                type: "GET",
                dataType: "json",
                // Passamos o ID do aluno e o flag 'full_id'
                data: { aluno_id: alunoId, full_id: true }, 
                success: function(response) {
                    if (response.length > 0) {
                        const dadosAluno = response[0];
                        preencherDadosAluno(dadosAluno);
                    } else {
                        alert("Erro: Dados do aluno não encontrados.");
                        $("#aluno_select_completa").val(""); 
                        $('#turma_display').text("Erro ao carregar.");
                        toggleFormulario(false);
                    }
                },
                error: function(xhr, status, error) {
                    alert("Erro ao buscar dados do aluno: " + status + " " + error);
                    $('#turma_display').text("Erro de comunicação.");
                    toggleFormulario(false);
                }
            });
        }
    });

    // Inicializa o formulário desabilitado ao carregar a página
    toggleFormulario(false); 
});
</script>

</body>
</html>