<?php
session_start();
include 'conexao.php';

if (!isset($_SESSION['usuario']) || !isset($_GET['id'])) {
    header("Location: painel_professor.php");
    exit;
}

$id_mensagem = $_GET['id'];
$id_autor = $_SESSION['usuario']['id'];

// Verifica se a mensagem existe e se o usuário é o autor
$stmt = $conn->prepare("SELECT * FROM mensagens_prof WHERE id = ? AND id_autor = ?");
$stmt->bind_param("ii", $id_mensagem, $id_autor);
$stmt->execute();
$res = $stmt->get_result();

if ($res->num_rows === 0) {
    echo "Você não tem permissão para editar esta mensagem.";
    exit;
}

$mensagem_antiga = $res->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['nova_mensagem'])) {
    $nova_mensagem = trim($_POST['nova_mensagem']);

    $stmt = $conn->prepare("UPDATE mensagens_prof SET mensagem = ? WHERE id = ?");
    $stmt->bind_param("si", $nova_mensagem, $id_mensagem);
    
    if ($stmt->execute()) {
        header("Location: painel_professor.php");
    } else {
        echo "Erro ao atualizar a mensagem.";
    }
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Editar Mensagem</title>
</head>
<body>
    <h2>Editar Mensagem</h2>
    <form method="POST">
        <textarea name="nova_mensagem" rows="5" cols="50" required><?= htmlspecialchars($mensagem_antiga['mensagem']) ?></textarea><br>
        <button type="submit">Salvar Edição</button>
        <button type="button" onclick="window.location.href='painel_professor.php'">Cancelar</button>
    </form>
</body>
</html>