<?php
session_start();
include 'conexao.php';

if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}

$aluno_id = isset($_GET['aluno_id']) ? intval($_GET['aluno_id']) : 0;
$aluno_nome = '';
$turma_id = 0;
$disciplinas = [];
$notas = [];

if ($aluno_id > 0) {
    // Dados do aluno e turma
    $stmt = $conn->prepare("SELECT nome, turma_id FROM alunos WHERE id = ?");
    $stmt->bind_param("i", $aluno_id);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($res->num_rows > 0) {
        $aluno = $res->fetch_assoc();
        $aluno_nome = $aluno['nome'];
        $turma_id = $aluno['turma_id'];
    }

    // Disciplinas da turma
    $res = $conn->query("SELECT id, nome FROM disciplinas WHERE turma_id = $turma_id ORDER BY nome");
    while ($row = $res->fetch_assoc()) {
        $disciplinas[] = $row;
    }

    // Buscar todas as notas por disciplina e trimestre
    foreach ($disciplinas as $disc) {
        $id_disc = $disc['id'];
        $notas_disciplina = [];

        for ($t = 1; $t <= 3; $t++) {
            $stmt = $conn->prepare("SELECT mac1, mac2, mac3, npt, exame FROM notas WHERE aluno_id = ? AND disciplina_id = ? AND turma_id = ? AND trimestre = ?");
            $stmt->bind_param("iiii", $aluno_id, $id_disc, $turma_id, $t);
            $stmt->execute();
            $nota = $stmt->get_result()->fetch_assoc();

            $mac1 = floatval($nota['mac1'] ?? 0);
            $mac2 = floatval($nota['mac2'] ?? 0);
            $mac3 = floatval($nota['mac3'] ?? 0);
            $npt  = floatval($nota['npt']  ?? 0);
            $exame = floatval($nota['exame'] ?? 0);

            $mt = round(($mac1 + $mac2 + $mac3 + $npt) / 4, 1);
            $notas_disciplina["T$t"] = [
                'MT' => $mt,
                'MAC1' => $mac1,
                'MAC2' => $mac2,
                'MAC3' => $mac3,
                'NPT' => $npt,
                'EXAME' => $t == 3 ? $exame : null
            ];
        }

        // MFD e MF
        $mt1 = $notas_disciplina['T1']['MT'];
        $mt2 = $notas_disciplina['T2']['MT'];
        $mt3 = $notas_disciplina['T3']['MT'];
        $mfd = round(($mt1 + $mt2 + $mt3) / 3, 2);
        $exame3 = $notas_disciplina['T3']['EXAME'];
        $mf = ($exame3 !== null) ? round(($mfd * 0.6 + $exame3 * 0.4), 0) : round($mfd, 0);

        $notas[$disc['nome']] = [
            'T1' => $notas_disciplina['T1'],
            'T2' => $notas_disciplina['T2'],
            'T3' => $notas_disciplina['T3'],
            'MFD' => $mfd,
            'MF' => $mf
        ];
    }
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Monotonia de Notas do Aluno</title>
  <style>
    body { font-family: Arial, sans-serif; background: #f0f2f5; padding: 20px; }
    h2 { text-align: center; color: #003366; }
    table { width: 100%; border-collapse: collapse; margin-top: 20px; background: white; }
    th, td { border: 1px solid #ccc; padding: 6px; text-align: center; }
    th { background: #003366; color: white; }
    tr:nth-child(even) { background: #f9f9f9; }
  </style>
</head>
<body>
  <h2>Monotonia das Notas de <?= htmlspecialchars($aluno_nome) ?></h2>

  <table>
    <thead>
      <tr>
        <th rowspan="2">Disciplina</th>
        <th colspan="4">Trimestre 1</th>
        <th colspan="4">Trimestre 2</th>
        <th colspan="5">Trimestre 3</th>
        <th rowspan="2">MFD</th>
        <th rowspan="2">MF</th>
      </tr>
      <tr>
        <th>MAC1</th><th>MAC2</th><th>MAC3</th><th>NPT</th>
        <th>MAC1</th><th>MAC2</th><th>MAC3</th><th>NPT</th>
        <th>MAC1</th><th>MAC2</th><th>MAC3</th><th>NPT</th><th>EXAME</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($notas as $disciplina => $n): ?>
        <tr>
          <td><?= htmlspecialchars($disciplina) ?></td>
          <?php for ($t = 1; $t <= 3; $t++): ?>
            <td><?= $n["T$t"]['MAC1'] ?></td>
            <td><?= $n["T$t"]['MAC2'] ?></td>
            <td><?= $n["T$t"]['MAC3'] ?></td>
            <td><?= $n["T$t"]['NPT'] ?></td>
          <?php endfor; ?>
          <td><?= $n['T3']['EXAME'] ?? '--' ?></td>
          <td><?= $n['MFD'] ?></td>
          <td><?= $n['MF'] ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</body>
</html>
