<?php
session_start();
include 'conexao.php';

// Verifica se ID foi passado
if (!isset($_GET['id'])) {
    die("Usuário não especificado.");
}

$id = intval($_GET['id']);
$mensagem = "";

// Buscar dados atuais do usuário
$sql = "SELECT * FROM usuarios WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$res = $stmt->get_result();

if ($res->num_rows != 1) {
    die("Usuário não encontrado.");
}

$usuario = $res->fetch_assoc();

// Atualizar dados se o formulário for enviado
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $novo_usuario = $_POST['usuario'] ?? '';
    $novo_agente = $_POST['agente'] ?? '';
    $novo_perfil = $_POST['perfil'] ?? '';

    if ($novo_usuario && $novo_agente && $novo_perfil) {
        $update = $conn->prepare("UPDATE usuarios SET usuario = ?, agente = ?, perfil = ? WHERE id = ?");
        $update->bind_param("sssi", $novo_usuario, $novo_agente, $novo_perfil, $id);

        if ($update->execute()) {
            $mensagem = "Usuário atualizado com sucesso!";
            // Atualiza os dados exibidos
            $usuario['usuario'] = $novo_usuario;
            $usuario['agente'] = $novo_agente;
            $usuario['perfil'] = $novo_perfil;
        } else {
            $mensagem = "Erro ao atualizar usuário.";
        }
    } else {
        $mensagem = "Preencha todos os campos.";
    }
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Editar Usuário</title>
  <link rel="stylesheet" href="adminlte/plugins/fontawesome-free/css/all.min.css">
  <style>
    body {
      background-color: #f4f6f9;
      font-family: 'Segoe UI', sans-serif;
      margin: 0;
      padding: 0;
    }

    .container {
      max-width: 600px;
      margin: 80px auto;
      padding: 30px;
      background: white;
      border-radius: 10px;
      box-shadow: 0 5px 10px rgba(0,0,0,0.1);
    }

    h2 {
      text-align: center;
      color: #003366;
      margin-bottom: 20px;
    }

    label {
      font-weight: bold;
    }

    input, select {
      width: 100%;
      padding: 10px;
      margin-bottom: 15px;
      border-radius: 5px;
      border: 1px solid #ccc;
    }

    button {
      background-color: #007bff;
      color: white;
      padding: 10px 15px;
      border: none;
      border-radius: 5px;
      font-weight: bold;
      cursor: pointer;
    }

    .mensagem {
      margin-top: 10px;
      color: green;
      font-weight: bold;
    }

    .voltar {
      text-align: center;
      margin-top: 20px;
    }

    .voltar a {
      text-decoration: none;
      color: #007bff;
      font-weight: bold;
    }
  </style>
</head>
<body>

  <div class="container">
    <h2>Editar Usuário</h2>
    <?php if ($mensagem): ?>
      <div class="mensagem"><?= $mensagem ?></div>
    <?php endif; ?>

    <form method="post">
      <label for="usuario">Nome de Usuário:</label>
      <input type="text" id="usuario" name="usuario" value="<?= htmlspecialchars($usuario['usuario']) ?>" required>

      <label for="agente">Nº de Agente:</label>
      <input type="text" id="agente" name="agente" value="<?= htmlspecialchars($usuario['agente']) ?>" required>

      <label for="perfil">Perfil:</label>
      <select name="perfil" id="perfil" required>
        <?php
        $perfis = [
          "ADMINISTRADOR",
          "SUBDIRECTOR(A) ADMIN",
          "SUBDIRECTOR(A) PEDAG",
          "SECRETARIA GERAL",
          "SECRETARIA PEDAG",
          "PROFESSOR",
          "OUTROS"
        ];
        foreach ($perfis as $p) {
          $selected = ($usuario['perfil'] == $p) ? "selected" : "";
          echo "<option value=\"$p\" $selected>$p</option>";
        }
        ?>
      </select>

      <button type="submit">Salvar Alterações</button>
    </form>

    <div class="voltar">
      <a href="ver_usuarios.php">← Voltar à Lista de Usuários</a>
    </div>
  </div>
</body>
</html>
