<?php
session_start();
include 'conexao.php'; // Incluindo a conexão para buscar os alunos

// Buscar lista de alunos
$alunos = [];
$res = $conn->query("SELECT id, nome FROM alunos ORDER BY nome");
while ($row = $res->fetch_assoc()) {
    $alunos[] = $row;
}

// Gerar anos letivos
$anos_lectivos = [];
for ($ano = 2020; $ano <= 2035; $ano++) {
    $proximo = $ano + 1;
    $anos_lectivos[] = "$ano/$proximo";
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Emitir Declarações</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f4f6f9;
            margin: 0; padding: 40px;
        }
        .container {
            background: white;
            padding: 30px;
            max-width: 800px;
            margin: auto;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        h2 {
            text-align: center;
            color: #003366;
            margin-bottom: 30px;
        }
        label {
            font-weight: bold;
            margin-top: 10px;
            display: block;
        }
        select, button {
            padding: 10px;
            width: 100%;
            margin-bottom: 20px;
            border-radius: 6px;
            border: 1px solid #ccc;
            font-size: 16px;
        }
        button {
            background: #003366;
            color: white;
            font-weight: bold;
            cursor: pointer;
        }
        button:hover {
            background: #00509e;
        }
        .hidden {
            display: none;
        }
    </style>
    <script>
        function atualizarFormulario() {
            const tipo = document.getElementById('tipo').value;
            const form = document.getElementById('form-declaracao');
            const seletorSemNotas = document.getElementById('seletor-sem-notas');
            const alunoSelect = document.getElementById('aluno');
            const anoLectivoSelect = document.getElementById('ano_lectivo');
            
            if (tipo === 'com_notas') {
                form.action = 'gerar_declaracao_com_notas.php';
                seletorSemNotas.classList.add('hidden');
                
                // Remove o atributo 'required' para evitar validação
                alunoSelect.removeAttribute('required');
                anoLectivoSelect.removeAttribute('required');

            } else {
                form.action = 'gerar_declaracao.php';
                seletorSemNotas.classList.remove('hidden');
                
                // Adiciona o atributo 'required' de volta
                alunoSelect.setAttribute('required', 'required');
                anoLectivoSelect.setAttribute('required', 'required');
            }
        }
        
        // Garante que a função é executada ao carregar a página
        window.onload = atualizarFormulario;
    </script>
</head>
<body>

<div class="container">
    <h2>📝 Emissão de Declarações</h2>

    <form id="form-declaracao" action="gerar_declaracao.php" method="get" target="_blank">

        <label for="tipo">Tipo de Declaração:</label>
        <select name="tipo" id="tipo" onchange="atualizarFormulario()" required>
            <option value="sem_notas">Declaração Sem Notas</option>
            <option value="com_notas">Declaração Com Notas</option>
        </select>
        
        <div id="seletor-sem-notas">
            <label for="aluno">Selecionar Aluno:</label>
            <select name="aluno_id" id="aluno" required>
                <option value="">-- Escolher Aluno --</option>
                <?php foreach ($alunos as $a): ?>
                    <option value="<?= $a['id'] ?>"><?= htmlspecialchars($a['nome']) ?></option>
                <?php endforeach; ?>
            </select>

            <label for="ano_lectivo">Ano Lectivo:</label>
            <select name="ano_lectivo" id="ano_lectivo" required>
                <option value="">-- Selecionar Ano Lectivo --</option>
                <?php foreach ($anos_lectivos as $ano): ?>
                    <option value="<?= $ano ?>"><?= $ano ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <button type="submit">📄 Gerar Declaração</button>
    </form>
</div>

</body>
</html>