<?php
// Inicia a sessão para acessar os dados do usuário.
session_start();

// Verifica se o usuário está logado e se o perfil é de professor.
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'PROFESSOR') {
    header("Location: login.php");
    exit;
}

// Inclui o arquivo de conexão com o banco de dados.
include 'conexao.php';
// Inclui o arquivo que verifica o login, se necessário.
include 'verifica_login.php';

// Obtém os dados do usuário da sessão.
$usuario = $_SESSION['usuario'];
$nome_usuario = $usuario['nome'] ?? 'Professor';

// Lógica de processamento do formulário de sugestão
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $sugestao = trim($_POST['sugestao']);

    if (!empty($sugestao)) {
        // Aqui você colocaria a lógica para salvar a sugestão no banco de dados.
        // Exemplo:
        // $stmt = $conn->prepare("INSERT INTO sugestoes (autor_id, autor_nome, sugestao) VALUES (?, ?, ?)");
        // $stmt->bind_param("iss", $usuario['id'], $nome_usuario, $sugestao);
        // $stmt->execute();
        // $stmt->close();
        echo "<script>alert('Sugestão enviada com sucesso!'); window.location.href='emitir_sugestao.php';</script>";
    } else {
        echo "<script>alert('A sugestão não pode estar vazia.');</script>";
    }
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Emitir Sugestão - SISMAG</title>
    <link rel="stylesheet" href="https://rsms.me/inter/inter.css">
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-8">

<div class="max-w-4xl mx-auto bg-white p-6 rounded-xl shadow-md">
    <h1 class="text-2xl font-bold text-gray-800 mb-6">Emitir Sugestão</h1>
    <p class="text-gray-600 mb-4">Olá, professor(a) <?= htmlspecialchars($nome_usuario) ?>. Use este formulário para enviar suas sugestões ou feedback à administração.</p>

    <form action="emitir_sugestao.php" method="POST" class="space-y-4">
        <div>
            <label for="sugestao" class="block text-sm font-medium text-gray-700">Sua Sugestão</label>
            <textarea id="sugestao" name="sugestao" rows="5" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm" placeholder="Escreva sua sugestão aqui..." required></textarea>
        </div>
        <div>
            <button type="submit" class="w-full inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-purple-600 hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500">
                Enviar Sugestão
            </button>
        </div>
    </form>
</div>

</body>
</html>

