<?php
// ============================================================
// PAINEL DE ESTATÍSTICAS DE ALUNOS (VERSÃO WEB) - CÓDIGO REVISADO
// ============================================================

// --- 1. INÍCIO DA SESSÃO ---
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// ----------------------
// Conexão com o Banco de Dados
// ----------------------
$host = "localhost";
$user = "root";
$pass = "";
$db = "sismag";
$port = 3307; // ajuste se necessário

$conn = new mysqli($host, $user, $pass, $db, $port);
if ($conn->connect_error) {
    die("Erro de conexão: " . $conn->connect_error);
}

// ----------------------
// Lógica de Processamento da Matrícula (REVISADA)
// ----------------------
$mensagemMatricula = '';

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['matricular_aluno'])) {
    $aluno_id = $_POST['aluno_id'] ?? null;
    $turma_id = $_POST['turma_id'] ?? null;
    $data_matricula = date('Y-m-d'); // Usando apenas a data

    // --- DEFINIÇÃO DO USUÁRIO E OBSERVAÇÃO ---
    // Tenta obter o ID do usuário logado. 
    $usuario_id_raw = $_SESSION['usuario_id'] ?? null; 
    
    // Observação definida como "TRANSITA"
    $observacoes = "TRANSITA";
    // ------------------------------------------


    if ($aluno_id && $turma_id) {
        // Escapando e preparando variáveis
        $aluno_id_safe = $conn->real_escape_string($aluno_id);
        $turma_id_safe = $conn->real_escape_string($turma_id);
        $observacoes_safe = $conn->real_escape_string($observacoes);
        
        // Trata o usuario_id para o SQL: usa o ID se existir, senão usa NULL
        $usuario_id_sql = ($usuario_id_raw !== null) ? "'" . $conn->real_escape_string($usuario_id_raw) . "'" : 'NULL';


        // 1. Obter Detalhes da Turma e o Próximo Número
        // CORREÇÃO 1: Selecionando 'ano' em vez de 'ano_letivo'
        $sqlTurmaDetalhes = "SELECT curso, classe, sala, turno, ano FROM turmas WHERE id = '$turma_id_safe'";
        $resDetalhes = $conn->query($sqlTurmaDetalhes);
        
        // Determina o próximo número de ordem na turma
        $sqlProximoNumero = "SELECT MAX(numero) AS max_numero FROM matriculas WHERE turma_id = '$turma_id_safe'";
        $resNum = $conn->query($sqlProximoNumero)->fetch_assoc();

        $proximo_numero = (($resNum['max_numero'] ?? 0) + 1);

        if ($resDetalhes && $resDetalhes->num_rows > 0) {
            $detalhes = $resDetalhes->fetch_assoc();
            
            // Atribuindo valores
            $curso = $conn->real_escape_string($detalhes['curso']);
            $classe = $conn->real_escape_string($detalhes['classe']);
            $sala = $conn->real_escape_string($detalhes['sala']);
            $turno = $conn->real_escape_string($detalhes['turno']);
            
            // CORREÇÃO 2: Lendo 'ano' da consulta e usando como $ano_letivo
            $ano_letivo = $conn->real_escape_string($detalhes['ano']); 
            
            $numero_processo = "PROC-{$aluno_id_safe}-{$ano_letivo}";


            // 2. Consulta de Inserção com todos os campos (USANDO O FORMATO DA SUA TABELA)
            $sqlInsert = "
                INSERT INTO matriculas (
                    aluno_id, turma_id, curso, classe, numero, sala, turno, ano_letivo, 
                    data_matricula, numero_processo, usuario_id, observacoes
                ) VALUES (
                    '$aluno_id_safe', '$turma_id_safe', '$curso', '$classe', '$proximo_numero', '$sala', '$turno', '$ano_letivo', 
                    '$data_matricula', '$numero_processo', {$usuario_id_sql}, '$observacoes_safe'
                )
            ";
            
            if ($conn->query($sqlInsert) === TRUE) {
                $mensagemMatricula = "<div style='padding: 10px; background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; border-radius: 5px; margin-bottom: 20px;'>✅ Matrícula do Aluno ID **$aluno_id_safe** (Nº {$proximo_numero}) na **{$classe}/{$curso}** realizada com sucesso! A lista será atualizada.</div>";
                
                // Redireciona para recarregar a página e atualizar as contagens
                echo $mensagemMatricula;
                header('Location: ' . $_SERVER['PHP_SELF']); 
                exit;
            } else {
                $mensagemMatricula = "<div style='padding: 10px; background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; border-radius: 5px; margin-bottom: 20px;'>❌ Erro ao matricular o aluno ID $aluno_id_safe: " . $conn->error . "</div>";
            }
        } else {
             $mensagemMatricula = "<div style='padding: 10px; background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; border-radius: 5px; margin-bottom: 20px;'>❌ Turma selecionada não encontrada.</div>";
        }
    }
}

// ----------------------
// Consultas SQL de Contagem
// ----------------------

// 1. Contagem TOTAL ÚNICO DE ALUNOS (Pessoas cadastradas) - Prioritária
$sqlTotalAlunosTable = "SELECT COUNT(*) AS total_alunos_tabela FROM alunos";
$totalAlunosTable = ($conn->query($sqlTotalAlunosTable)->fetch_assoc()['total_alunos_tabela']) ?? 0;

// 2. Contagem Total de Registros na tabela MATRICULAS (Matrículas ativas/histórico - Eventos)
$sqlTotalMatriculasTable = "SELECT COUNT(*) AS total_matriculas_tabela FROM matriculas";
$totalMatriculasTable = ($conn->query($sqlTotalMatriculasTable)->fetch_assoc()['total_matriculas_tabela']) ?? 0;

// 3. Contagem de Alunos MATRICULADOS (Join: Alunos com matrículas válidas/histórico)
$sqlTotal = "SELECT COUNT(DISTINCT a.id) AS total_alunos FROM alunos a INNER JOIN matriculas m ON a.id = m.aluno_id";
$totalAlunosMatriculados = ($conn->query($sqlTotal)->fetch_assoc()['total_alunos']) ?? 0;


// ----------------------
// CONSULTA: Alunos sem Matrícula (Cadastro Único Sem Vínculo)
// ----------------------
$sqlAlunosSemMatricula = "
    SELECT
        a.id AS aluno_id,
        a.nome,           
        a.genero
    FROM
        alunos a
    LEFT JOIN
        matriculas m ON a.id = m.aluno_id
    WHERE
        m.aluno_id IS NULL
    ORDER BY
        a.nome ASC
";
$resAlunosSemMatricula = $conn->query($sqlAlunosSemMatricula);
$totalAlunosSemMatricula = ($resAlunosSemMatricula) ? $resAlunosSemMatricula->num_rows : 0;


// ----------------------
// CONSULTA: Turmas Disponíveis para Matrícula 
// CORREÇÃO 3: Selecionando 'ano' em vez de 'ano_letivo'
// ----------------------
$sqlTurmas = "SELECT id, nome, classe, curso, sala, turno, ano FROM turmas ORDER BY classe, curso, nome";
$resTurmas = $conn->query($sqlTurmas);

$turmasDisponiveis = [];
if ($resTurmas) {
    while ($row = $resTurmas->fetch_assoc()) {
        
        // Mapeamos a coluna 'ano' para o display como 'ano_letivo'
        $row['ano_letivo'] = $row['ano'];
        
        $turmasDisponiveis[] = $row;
    }
}


// ----------------------
// Consultas SQL e Agrupamento de Dados (MANTIDAS)
// ----------------------

// Estatística por género
$sqlGenero = "SELECT a.genero, COUNT(*) AS total FROM alunos a INNER JOIN matriculas m ON a.id = m.aluno_id GROUP BY a.genero";
$resGenero = $conn->query($sqlGenero);

// Estatística por Idade e Género (Seção 2 do PDF)
$sqlIdadeGenero = "
    SELECT a.idade, a.genero, COUNT(*) AS total
    FROM alunos a
    INNER JOIN matriculas m ON a.id = m.aluno_id
    GROUP BY a.idade, a.genero
    ORDER BY a.idade ASC, a.genero ASC
";
$resIdadeGenero = $conn->query($sqlIdadeGenero);

$estatisticasPorIdade = [];
if ($resIdadeGenero) {
    while ($row = $resIdadeGenero->fetch_assoc()) {
        $idade = $row['idade'];
        if (!isset($estatisticasPorIdade[$idade])) {
            $estatisticasPorIdade[$idade] = ['total_idade' => 0, 'detalhes' => []];
        }
        $estatisticasPorIdade[$idade]['total_idade'] += $row['total'];
        $estatisticasPorIdade[$idade]['detalhes'][] = $row;
    }
}

// Estatística por Turma, Idade e Género (Seção 3 do PDF)
$sqlTurmaIdadeGenero = "
    SELECT t.nome AS nome_turma, a.idade, a.genero, t.classe, t.curso, t.sala, COUNT(*) AS total
    FROM alunos a
    INNER JOIN matriculas m ON a.id = m.aluno_id
    INNER JOIN turmas t ON m.turma_id = t.id
    GROUP BY t.nome, a.idade, a.genero, t.classe, t.curso, t.sala
    ORDER BY t.classe, t.curso, t.nome, a.idade, a.genero
";
$resTurmaIdadeGenero = $conn->query($sqlTurmaIdadeGenero);

$estatisticasPorTurmaAgrupada = [];
if ($resTurmaIdadeGenero) {
    while ($row = $resTurmaIdadeGenero->fetch_assoc()) {
        $turma = "{$row['classe']} - {$row['curso']} - {$row['nome_turma']} ({$row['sala']})"; 
        $idade = $row['idade'];

        if (!isset($estatisticasPorTurmaAgrupada[$turma])) {
            $estatisticasPorTurmaAgrupada[$turma] = ['total_turma' => 0, 'idades' => []];
        }
        if (!isset($estatisticasPorTurmaAgrupada[$turma]['idades'][$idade])) {
            $estatisticasPorTurmaAgrupada[$turma]['idades'][$idade] = ['total_idade' => 0, 'generos' => []];
        }

        $estatisticasPorTurmaAgrupada[$turma]['total_turma'] += $row['total'];
        $estatisticasPorTurmaAgrupada[$turma]['idades'][$idade]['total_idade'] += $row['total'];
        $estatisticasPorTurmaAgrupada[$turma]['idades'][$idade]['generos'][] = $row;
    }
}

// Fecha a conexão após todas as consultas
$conn->close();
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estatística de Alunos Matriculados - SISMAG</title>
    <style>
        /* Estilos base (Mantidos) */
        body { margin: 0; font-family: 'Inter', Arial, sans-serif; background: #f0f2f5; color: #333; }
        .topbar { background: #004d99; color: white; padding: 15px; font-size: 20px; font-weight: bold; position: fixed; top: 0; left: 0; right: 0; z-index: 1000; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        .sidebar { background: #111827; width: 220px; height: 100vh; position: fixed; top: 50px; left: 0; padding-top: 20px; color: white; box-shadow: 2px 0 5px rgba(0,0,0,0.1); }
        .sidebar a { display: block; color: white; padding: 12px; text-decoration: none; transition: 0.3s; border-radius: 4px; margin: 5px 10px; }
        .sidebar a:hover { background: #1f2937; }
        .content { margin-left: 230px; margin-top: 75px; padding: 20px; }
        h1 { color: #004d99; }
        h2 { color: #004d99; margin-top: 30px; border-bottom: 2px solid #ddd; padding-bottom: 5px; }
        h3 { color: #555; margin-top: 30px; font-size: 1.25em; }
        .stats-dashboard { display: flex; gap: 20px; margin-bottom: 30px; flex-wrap: wrap; }
        .stats-card { background: white; border-radius: 8px; padding: 20px; box-shadow: 0 4px 10px rgba(0,0,0,0.1); flex: 1; min-width: 200px; transition: transform 0.3s; }
        .stats-card:hover { transform: translateY(-5px); }
        .stats-card p { margin: 0; font-size: 14px; color: #666; }
        .stats-card .count { font-size: 2.2em; font-weight: bold; color: #007bff; margin-top: 5px; }
        .stats-card.primary-total { border-left: 5px solid #004d99; background: #e6f7ff; }
        .stats-card.secondary-matriculados { border-left: 5px solid #28a745; }
        .stats-card.secondary-matriculas { border-left: 5px solid #ffc107; }
        .stats-card.danger-nomatricula { border-left: 5px solid #dc3545; background: #fff0f0; }
        .print-button { background: #28a745; color: white; padding: 10px 20px; border-radius: 5px; text-decoration: none; font-weight: bold; display: inline-block; margin-bottom: 20px; transition: background 0.3s; box-shadow: 0 2px 4px rgba(0,0,0,0.2); }
        .print-button:hover { background: #218838; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 30px; background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 4px 10px rgba(0,0,0,0.1); }
        th, td { border: 1px solid #ddd; padding: 12px; text-align: center; }
        th { background: #007bff; color: white; font-weight: bold; }
        .row-total-idade { background: #e6ffe6; font-weight: bold; color: #006600; }
        .row-total-turma { background: #cceeff; font-weight: bold; color: #004d99; font-size: 1.1em; }
        .section-header { background: #f0f8ff; font-weight: bold; }
        .row-sem-matricula td { background-color: #fcecec; color: #333; }
    </style>
</head>
<body>

    <div class="topbar">
        📊 Estatística de Alunos Matriculados - SISMAG
    </div>

    <div class="sidebar">
        <a href="painel_secretaria_geral.php">🏠 Início</a>
    </div>

    <div class="content">
        <h1>Estatísticas de Alunos</h1>

        <div class="stats-dashboard">
            <div class="stats-card primary-total">
                <p>Total de Alunos no Sistema (Cadastros Únicos)</p>
                <div class="count"><?php echo $totalAlunosTable; ?></div>
            </div>
            <div class="stats-card secondary-matriculados">
                <p>Alunos com Matrícula Ativa/Histórico (Com Vínculo)</p>
                <div class="count"><?php echo $totalAlunosMatriculados; ?></div>
            </div>
            <div class="stats-card danger-nomatricula">
                <p>Alunos sem Matrícula (Cadastro Sem Vínculo)</p>
                <div class="count"><?php echo $totalAlunosSemMatricula; ?></div>
            </div>
            <div class="stats-card secondary-matriculas">
                <p>Total de Registros de Matrículas (Eventos)</p>
                <div class="count"><?php echo $totalMatriculasTable; ?></div>
            </div>
        </div>
        <a href="estatistica_print.php" target="_blank" class="print-button">
            Imprimir Estatísticas (PDF)
        </a>

        ---

        <?php if (!empty($mensagemMatricula)): ?>
            <?php echo $mensagemMatricula; ?>
        <?php endif; ?>
        
        <h2>4. Alunos no Sistema SEM Vínculo (Cadastros Únicos)</h2>
        <p>Estes alunos estão cadastrados na tabela `alunos`, mas não possuem **nenhum** registro na tabela `matriculas`. Use o formulário abaixo para realizar a matrícula e movê-los para a lista de alunos com vínculo.</p>
        
        <table>
            <tr>
                <th>ID Aluno</th>
                <th style="text-align: left;">Nome do Aluno</th>
                <th>Gênero</th>
                <th style="width: 35%;">Matricular na Turma</th>
                <th>Ação</th>
            </tr>
            <?php if ($resAlunosSemMatricula && $resAlunosSemMatricula->num_rows > 0): ?>
                <?php $resAlunosSemMatricula->data_seek(0); // Reinicia o ponteiro ?>
                <?php while($row = $resAlunosSemMatricula->fetch_assoc()): ?>
                <tr class="row-sem-matricula">
                    <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
                        <input type="hidden" name="aluno_id" value="<?php echo htmlspecialchars($row['aluno_id']); ?>">
                        <td><?php echo htmlspecialchars($row['aluno_id']); ?></td>
                        <td style="text-align: left;"><?php echo htmlspecialchars($row['nome']); ?></td>
                        <td><?php echo htmlspecialchars($row['genero']); ?></td>
                        <td>
                            <?php if (!empty($turmasDisponiveis)): ?>
                            <select name="turma_id" required style="width: 100%; padding: 8px; border-radius: 4px; border: 1px solid #ccc;">
                                <option value="">--- Selecione a Turma ---</option>
                                <?php foreach ($turmasDisponiveis as $turma): ?>
                                    <option value="<?php echo htmlspecialchars($turma['id']); ?>">
                                        <?php echo htmlspecialchars("{$turma['classe']} - {$turma['curso']} - {$turma['nome']} ({$turma['sala']} | {$turma['turno']} | {$turma['ano_letivo']})"); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <?php else: ?>
                                <span style="color: red;">Nenhuma Turma Encontrada</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if (!empty($turmasDisponiveis)): ?>
                            <button type="submit" name="matricular_aluno" style="background-color: #007bff; color: white; padding: 8px 15px; border: none; border-radius: 4px; cursor: pointer; transition: background-color 0.2s;">
                                Matricular
                            </button>
                            <?php endif; ?>
                        </td>
                    </form>
                </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="5">Parabéns! Todos os <?php echo $totalAlunosTable; ?> alunos cadastrados possuem algum vínculo de matrícula.</td>
                </tr>
            <?php endif; ?>
        </table>

        ---

        <h2>1. Estatística por Género (Alunos Matriculados)</h2>
        <table>
            <tr>
                <th>Género</th>
                <th>Total</th>
            </tr>
            <?php if ($resGenero && $resGenero->num_rows > 0): ?>
                <?php $resGenero->data_seek(0); while($row = $resGenero->fetch_assoc()): ?>
                <tr>
                    <td><?php echo htmlspecialchars($row['genero']); ?></td>
                    <td><?php echo htmlspecialchars($row['total']); ?></td>
                </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="2">Sem dados disponíveis.</td></tr>
            <?php endif; ?>
        </table>
        
        ---

        <h2>2. Estatística por Idade e Género (Alunos Matriculados)</h2>
        <table>
            <tr>
                <th style="width: 30%;">Idade</th>
                <th style="width: 30%;">Género</th>
                <th style="width: 20%;">Total</th>
            </tr>
            <?php if (!empty($estatisticasPorIdade)): ?>
                <?php foreach ($estatisticasPorIdade as $idade => $dados): ?>
                    <?php
                    $rowspan = count($dados['detalhes']);
                    $isFirst = true;
                    ?>
                    <?php foreach ($dados['detalhes'] as $detalhe): ?>
                    <tr>
                        <?php if ($isFirst): ?>
                        <td rowspan="<?= $rowspan; ?>" style="vertical-align: middle; background: #f0f0f0;">
                            <?= htmlspecialchars($idade); ?> Anos
                        </td>
                        <?php $isFirst = false; endif; ?>
                        <td><?= htmlspecialchars($detalhe['genero']); ?></td>
                        <td><?= htmlspecialchars($detalhe['total']); ?></td>
                    </tr>
                    <?php endforeach; ?>
                    <tr class="row-total-idade">
                        <td colspan="2">Total Idade <?= htmlspecialchars($idade); ?></td>
                        <td><?= htmlspecialchars($dados['total_idade']); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr><td colspan="3">Sem dados detalhados por idade e género disponíveis.</td></tr>
            <?php endif; ?>
        </table>
        
        ---

        <h2>3. Estatística Detalhada por Turma, Idade e Gênero (Alunos Matriculados)</h2>
        
        <?php if (!empty($estatisticasPorTurmaAgrupada)): ?>
            <?php foreach ($estatisticasPorTurmaAgrupada as $turma => $dadosTurma): ?>
                
                <h3>Turma: <?= htmlspecialchars($turma); ?> (Total: <?= $dadosTurma['total_turma']; ?>)</h3>
                
                <table>
                    <tr class="section-header">
                        <th style="width: 30%;">Idade</th>
                        <th style="width: 30%;">Género</th>
                        <th style="width: 20%;">Total</th>
                    </tr>
                    
                    <?php foreach ($dadosTurma['idades'] as $idade => $dadosIdade): ?>
                        <?php
                        $detalhes = $dadosIdade['generos'];
                        $rowspan = count($detalhes);
                        $isFirst = true;
                        ?>
                        
                        <?php foreach ($detalhes as $detalhe): ?>
                        <tr>
                            <?php if ($isFirst): ?>
                            <td rowspan="<?= $rowspan; ?>" style="vertical-align: middle; background: #f0f0f0;">
                                <?= htmlspecialchars($idade); ?> Anos
                            </td>
                            <?php $isFirst = false; endif; ?>
                            <td><?= htmlspecialchars($detalhe['genero']); ?></td>
                            <td><?= htmlspecialchars($detalhe['total']); ?></td>
                        </tr>
                        <?php endforeach; ?>
                        
                        <tr class="row-total-idade">
                            <td colspan="2">Subtotal Idade <?= htmlspecialchars($idade); ?></td>
                            <td><?= htmlspecialchars($dadosIdade['total_idade']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                    
                    <tr class="row-total-turma">
                        <td colspan="2">TOTAL GERAL DA TURMA</td>
                        <td><?= htmlspecialchars($dadosTurma['total_turma']); ?></td>
                    </tr>
                </table>
            <?php endforeach; ?>
        <?php else: ?>
            <p>Sem dados detalhados por turma, idade e género disponíveis.</p>
        <?php endif; ?>
    </div>

</body>
</html>