<?php

// --- Configurações do Banco de Dados ---
$usuario = 'root';
$senha = '';
$host = 'localhost';
$banco = 'sismag'; // Define o banco de dados a ser exportado

// --- Configurações do mysqldump ---
// ATENÇÃO: Verifique e ajuste este caminho para a sua instalação do XAMPP/WAMP.
// Se estiver em Linux, geralmente é apenas 'mysqldump'.
$mysqldump = 'C:\\xampp\\mysql\\bin\\mysqldump.exe';

// --- Processo de Exportação ---

// 1. Define o nome do arquivo com a data e hora para ser único
$arquivo = "{$banco}_" . date('Y-m-d_H-i-s') . ".sql";

// 2. Configura os cabeçalhos para forçar o download do arquivo
header('Content-Type: application/sql');
header('Content-Disposition: attachment; filename="' . $arquivo . '"');
header('Pragma: no-cache');
header('Expires: 0');

// 3. Protege o nome do banco para evitar injeção de comandos
$banco_seguro = escapeshellarg($banco);

// 4. Monta o comando completo
$comando = "\"$mysqldump\" -h $host -u $usuario " . ($senha ? "-p$senha " : "") . $banco_seguro;

// 5. Executa o comando e envia a saída diretamente para o navegador
passthru($comando, $retorno);

// 6. Verifica se houve algum erro
if ($retorno !== 0) {
    // Se houver erro, exibe uma mensagem no arquivo de download
    echo "\nErro ao exportar o banco de dados. Verifique as credenciais ou o caminho do mysqldump.";
}

exit;

?>