<?php
session_start();
include 'conexao.php';

// Restringir o acesso apenas ao Diretor Pedagógico
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'SUBDIRECÇÃO PEDAGÓGICA') {
    header("Location: login.php");
    exit;
}

$mensagem = '';
$turma_id_selecionada = $_GET['turma_id'] ?? null;
$trimestre_selecionado = $_GET['trimestre'] ?? null;
$ano_lectivo_atual = '2025/2026'; // Defina o ano letivo atual

// Processar o fechamento do trimestre
if ($turma_id_selecionada && $trimestre_selecionado) {
    try {
        // Buscar todas as disciplinas da turma
        $stmt_disciplinas = $conn->prepare("SELECT disciplina_id FROM pautas_gerais WHERE turma_id = ? AND ano_lectivo = ?");
        $stmt_disciplinas->bind_param("is", $turma_id_selecionada, $ano_lectivo_atual);
        $stmt_disciplinas->execute();
        $disciplinas = $stmt_disciplinas->get_result()->fetch_all(MYSQLI_ASSOC);
        $stmt_disciplinas->close();

        if (empty($disciplinas)) {
            throw new Exception("Nenhuma disciplina encontrada para a turma selecionada.");
        }

        $conn->begin_transaction();

        foreach ($disciplinas as $disciplina) {
            $disciplina_id = $disciplina['disciplina_id'];

            // Inserir o registro de fechamento para cada disciplina
            $stmt_fecho = $conn->prepare("INSERT INTO fecho_trimestre (turma_id, disciplina_id, ano_lectivo, trimestre) VALUES (?, ?, ?, ?)");
            $stmt_fecho->bind_param("iisi", $turma_id_selecionada, $disciplina_id, $ano_lectivo_atual, $trimestre_selecionado);
            $stmt_fecho->execute();
            $stmt_fecho->close();
        }

        $conn->commit();
        $mensagem = "<div style='color: green;'>Trimestre {$trimestre_selecionado} fechado com sucesso para a turma e ano letivo selecionados! As notas não podem mais ser alteradas.</div>";
    } catch (Exception $e) {
        $conn->rollback();
        $mensagem = "<div style='color: red;'>Erro ao fechar o trimestre: " . $e->getMessage() . "</div>";
    }
}

// **MODIFICAÇÃO AQUI: Buscar turmas para o select com classe e curso**
$turmas = $conn->query("SELECT id, nome, classe, curso FROM turmas ORDER BY nome")->fetch_all(MYSQLI_ASSOC);

?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Fechar Trimestre Geral</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .container { max-width: 600px; margin: auto; padding: 20px; border: 1px solid #ccc; border-radius: 5px; }
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; font-weight: bold; }
        select, button { width: 100%; padding: 10px; box-sizing: border-box; }
        button { background-color: #007bff; color: white; border: none; cursor: pointer; }
        button:hover { background-color: #0056b3; }
    </style>
</head>
<body>

<div class="container">
    <h2>Fecho de Trimestre por Turma</h2>
    <?= $mensagem ?>
    <form method="GET">
        <div class="form-group">
            <label for="turma_id">Selecionar Turma:</label>
            <select name="turma_id" id="turma_id" required>
                <option value="">-- Selecione uma turma --</option>
                <?php foreach ($turmas as $turma): ?>
                    <option value="<?= htmlspecialchars($turma['id']) ?>" <?= ($turma_id_selecionada == $turma['id']) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($turma['classe'] . "-" . $turma['nome'] . "-" . $turma['curso']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label for="trimestre">Selecionar Trimestre:</label>
            <select name="trimestre" id="trimestre" required>
                <option value="">-- Selecione um trimestre --</option>
                <option value="1" <?= ($trimestre_selecionado == '1') ? 'selected' : '' ?>>1º Trimestre</option>
                <option value="2" <?= ($trimestre_selecionado == '2') ? 'selected' : '' ?>>2º Trimestre</option>
                <option value="3" <?= ($trimestre_selecionado == '3') ? 'selected' : '' ?>>3º Trimestre</option>
            </select>
        </div>
        <button type="submit">Fechar Trimestre</button>
    </form>
</div>

</body>
</html>