<?php
ob_start();
session_start();
require 'fpdf/fpdf.php';
include 'conexao.php';

/**
 * Prepara imagem para o FPDF:
 * - Corrige orientação via EXIF
 * - Converte formatos incompatíveis para JPG
 * - Retorna caminho temporário
 */
function prepararImagemParaFPDF($caminho) {
    if (!file_exists($caminho)) {
        return null;
    }

    $info = getimagesize($caminho);
    if ($info === false) {
        return null;
    }

    $tipo = $info[2];
    if (!is_dir('fotos_alunos')) {
        @mkdir('fotos_alunos', 0755, true);
    }
    $tempPath = 'fotos_alunos/temp_' . uniqid() . '.jpg';

    switch ($tipo) {
        case IMAGETYPE_JPEG:
            $img = imagecreatefromjpeg($caminho);
            if (function_exists('exif_read_data')) {
                $exif = @exif_read_data($caminho);
                if (!empty($exif['Orientation'])) {
                    switch ($exif['Orientation']) {
                        case 3: $img = imagerotate($img, 180, 0); break;
                        case 6: $img = imagerotate($img, -90, 0); break;
                        case 8: $img = imagerotate($img, 90, 0); break;
                    }
                }
            }
            imagejpeg($img, $tempPath, 90);
            imagedestroy($img);
            break;

        case IMAGETYPE_PNG:
            $img = imagecreatefrompng($caminho);
            imagejpeg($img, $tempPath, 90);
            imagedestroy($img);
            break;

        case IMAGETYPE_GIF:
            $img = imagecreatefromgif($caminho);
            imagejpeg($img, $tempPath, 90);
            imagedestroy($img);
            break;

        case IMAGETYPE_WEBP:
            if (function_exists('imagecreatefromwebp')) {
                $img = imagecreatefromwebp($caminho);
                imagejpeg($img, $tempPath, 90);
                // A função imagerotate está incorreta aqui sem parâmetros.
                // Mas vamos focar na correção do loop principal.
                // imagerotate($img); 
            } else {
                return null;
            }
            break;

        default:
            return null;
    }

    return $tempPath;
}

$ano_letivo = $_POST['ano_letivo'] ?? '';
$alunos_selecionados = $_POST['alunos'] ?? [];

// Garantir 6 slots (IMPORTANTE)
while (count($alunos_selecionados) < 6) {
    $alunos_selecionados[] = null;
}

// ...
$dados_alunos = [];
foreach ($alunos_selecionados as $id) {
    if (!$id) {
        $dados_alunos[] = null;
        continue;
    }

    $stmt = $conn->prepare("SELECT a.nome, a.numero_processo, a.numero, a.foto, a.numero_cartao, 
                                 t.classe, t.nome AS turma, t.curso, t.turno
        FROM matriculas m
        LEFT JOIN alunos a ON a.id = m.aluno_id
        JOIN turmas t ON t.id = m.turma_id
        WHERE m.aluno_id = ? AND m.ano_letivo = ?
        LIMIT 1
    ");

    $stmt->bind_param("is", $id, $ano_letivo);
    $stmt->execute();
    $res = $stmt->get_result();
    $dados = $res->fetch_assoc();

    if ($dados) {
        $dados['ano_letivo'] = $ano_letivo;
    }

    $dados_alunos[] = $dados ?: null;
}

$pdf = new FPDF('P', 'mm', 'A4');
$pdf->AddPage();

function gerarCartao($pdf, $x, $y, $dados_aluno, $numero) {
    $offsetSombra = 1.5;

    $pdf->SetFillColor(220, 220, 220);
    $pdf->Rect($x + $offsetSombra, $y + $offsetSombra, 90, 72, 'F');

    $pdf->SetFillColor(255, 255, 255);
    $pdf->SetDrawColor(150, 150, 150);
    $pdf->SetLineWidth(1.2);
    $pdf->Rect($x, $y, 90, 72, 'FD');

    $pdf->SetLineWidth(0.2);
    $pdf->SetDrawColor(0,0,0);

    $cabecalhoAltura = 25;
    $margemEsq = 4;
    $larguraCabecalho = 60;

    $posXInsignia = $x + ($larguraCabecalho - 8) / 2 + $margemEsq;
    if (file_exists('insignia/insigniacartao.png')) {
        $pdf->Image('insignia/insigniacartao.png', $posXInsignia, $y + 2, 8, 8);
    }

    $pdf->SetFont('Arial', '', 6);
    $pdf->SetXY($x + $margemEsq, $y + 11);
    $pdf->Cell($larguraCabecalho, 4, utf8_decode("REPÚBLICA DE ANGOLA"), 0, 1, 'C');

    $pdf->SetX($x + $margemEsq);
    $pdf->Cell($larguraCabecalho, 4, utf8_decode("GOVERNO PROVINCIAL DE BENGUELA"), 0, 1, 'C');

    $pdf->SetX($x + $margemEsq);
    $pdf->Cell($larguraCabecalho, 4, utf8_decode("GABINETE PROVINCIAL DA EDUCAÇÃO"), 0, 1, 'C');

    $pdf->SetFont('Arial', '', 4.5);
    $pdf->SetX($x + $margemEsq);
    $pdf->Cell($larguraCabecalho, 4, utf8_decode("COMPLEXO ESCOLAR CATÓLICO Nº 0026 BLA PADRE EMIL FRICK - CATUMBELA"), 0, 1, 'C');

    $yUltimaFrase = $pdf->GetY();

    $larguraFoto = 16;
    $alturaFoto = 21;
    $posXFoto = $x + 90 - $larguraFoto - 6; // deslocada mais para a esquerda
    $posYFoto = $yUltimaFrase - $alturaFoto + 1;

    $pdf->Rect($posXFoto, $posYFoto, $larguraFoto, $alturaFoto);

    if (!empty($dados_aluno['foto'])) {
        $caminhoFoto = prepararImagemParaFPDF("fotos_alunos/" . $dados_aluno['foto']);
        if ($caminhoFoto) {
            $pdf->Image($caminhoFoto, $posXFoto + 0.5, $posYFoto + 0.5, $larguraFoto - 1, $alturaFoto - 1);
            // APÓS USAR A FOTO TEMPORÁRIA, É BOM APAGÁ-LA:
            // @unlink($caminhoFoto); 
        }
    }

    $num_proc_db = $dados_aluno['numero_processo'] ?? 'N/D';
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetFont('Arial', '', 7);

    $num_limpo = str_ireplace(['PROC-', 'PROC.', 'PROC'], '', $num_proc_db);
    $num_proc_formatado = "Nº Proc. Ind. " . $num_limpo;

    $pdf->SetXY($posXFoto - 10, $posYFoto + $alturaFoto + 1);
    $pdf->Cell($larguraFoto + 10, 4, utf8_decode($num_proc_formatado), 0, 1, 'C');

    $ano = $dados_aluno['ano_letivo'] ?? '____';
    // $numero_aluno_formatado = intval($dados_aluno['numero']); // Não usado diretamente, mas mantido
    $numero_cartao = $dados_aluno['numero_cartao'] ?? 'N/D';  


    $pdf->SetFont('Arial', 'B', 7);
    $pdf->SetXY($x + $margemEsq + 4, $yUltimaFrase + 1);
    $pdf->Cell(90 - $margemEsq, 5, utf8_decode("CARTÃO DE ESTUDANTE Nº {$numero_cartao}/{$ano}"), 0, 1, 'L');

    $nome_aluno = $dados_aluno['nome'] ?? 'N/D';
    $yNome = $yUltimaFrase + 11;
    $larguraNome = 90 - $margemEsq;


    // 1. Imprime a palavra "Nome:" a preto (0, 0, 0)
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->SetXY($x + $margemEsq, $yNome);
    $pdf->Cell($pdf->GetStringWidth(utf8_decode("Nome:")), 5, utf8_decode("Nome:"), 0, 0, 'L');
    $xNomeAluno = $pdf->GetX(); 
    
    // 2. Imprime o nome do aluno a vermelho (204, 0, 0)
    $pdf->SetTextColor(204, 0, 0);
    $pdf->SetX($xNomeAluno);
    $pdf->Cell($larguraNome - ($xNomeAluno - ($x + $margemEsq)), 5, utf8_decode($nome_aluno), 0, 1, 'L');
    
    // Retorna a cor do texto para preto para o restante
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetFont('Arial', '', 7);
    $classe_aluno = $dados_aluno['classe'] ?? 'N/D';
    $turma_aluno = $dados_aluno['turma'] ?? 'N/D';
    $num_aluno = intval($dados_aluno['numero']);
    $turno_aluno = $dados_aluno['turno'] ?? 'N/D';
    $curso_aluno = $dados_aluno['curso'] ?? 'N/D';
    if (strtoupper($curso_aluno) === 'REGULAR') {
        $curso_aluno = 'R';
    }


    $pdf->SetXY($x + $margemEsq, $yUltimaFrase + 16);
    $linha = utf8_decode("Classe: {$classe_aluno}    Turma: {$turma_aluno}    Nº: {$num_aluno}    Curso: $curso_aluno    Período: $turno_aluno");
    $pdf->Cell(0, 5, $linha, 0, 1, 'L');

    $yAssinaturas = $yUltimaFrase + 25;

    // Ajustar assinaturas
    $pdf->SetFont('Arial', '', 6.5);

    // Aluno mais à esquerda
    $pdf->SetXY($x + $margemEsq - 4, $yAssinaturas);
    $pdf->Cell(35, 4, utf8_decode("O(A) ALUNO(A)"), 0, 0, 'C');
    // Diretor mais à direita
    $pdf->SetX($x + $margemEsq + 42);
    $pdf->Cell(35, 4, utf8_decode("O DIRECTOR"), 0, 1, 'C');

    // Linhas de assinatura
    $pdf->SetXY($x + $margemEsq - 4, $yAssinaturas + 3);
    $pdf->Cell(35, 4, "________________", 0, 0, 'C');
    // Ajustado para 25 sublinhados
    $pdf->SetX($x + $margemEsq + 42);
    $pdf->Cell(35, 4, "_________________________", 0, 1, 'C'); 

    // Nome do diretor
    $pdf->SetXY($x + $margemEsq + 42, $yAssinaturas + 7);
    $pdf->Cell(35, 4, utf8_decode("Eduardo Sanjambela Tchandja"), 0, 1, 'C');
}

$positions_frente = [
    [10, 30], [110, 30],
    [10, 120], [110, 120],
    [10, 210], [110, 210],
];

for ($i = 0; $i < 6; $i++) {
    // A função gerarCartao é chamada corretamente aqui, para a frente do cartão
    gerarCartao($pdf, $positions_frente[$i][0], $positions_frente[$i][1], $dados_alunos[$i], $i + 1);
}

$pdf->AddPage();

function gerarVersoCartao($pdf, $x, $y) {
    $offsetSombra = 1.5;

    $pdf->SetFillColor(220, 220, 220);
    $pdf->Rect($x + $offsetSombra, $y + $offsetSombra, 90, 60, 'F');

    $pdf->SetFillColor(255, 255, 255);
    $pdf->SetDrawColor(150, 150, 150);
    $pdf->SetLineWidth(1.2);
    $pdf->Rect($x, $y, 90, 60, 'FD');

    $pdf->SetLineWidth(0.2);
    $pdf->SetDrawColor(0,0,0);

    $pdf->SetFont('Arial', 'B', 8);
    $pdf->SetXY($x + 5, $y + 4);
    $pdf->Cell(80, 6, utf8_decode("CONTROLO DE PROPINA"), 0, 1, 'C');

    $pdf->SetFont('Arial', '', 7);
    $meses = [
        "Setembro/2025", "Outubro/2025", "Novembro/2025", "Dezembro/2025",
        "Janeiro/2026", "Fevereiro/2026", "Março/2026", "Abril/2026",
        "Maio/2026", "Junho/2026", "Julho/2026"
    ];

    $yLinha = $y + 12;
    foreach ($meses as $mes) {
        $linha = utf8_decode("{$mes} ________ Data:__/___/____  Ass:___________");
        $pdf->SetXY($x + 5, $yLinha);
        $pdf->Cell(0, 4, $linha, 0, 1, 'L');
        $yLinha += 4;
    }
}

$positions_verso = [
    [10, 15], [110, 15],
    [10, 95], [110, 95],
    [10, 175], [110, 175]
];

for ($i = 0; $i < 6; $i++) {
    // 🛑 AQUI ESTAVA O ERRO! Estava a chamar gerarCartao()
    // A correção é chamar gerarVersoCartao() com os argumentos corretos.
    if ($dados_alunos[$i] !== null) {
        // Gera o verso apenas se houver dados de aluno para manter a ordem
        // A função só precisa de $pdf, $x, $y
        gerarVersoCartao($pdf, $positions_verso[$i][0], $positions_verso[$i][1]); 
    }
}


ob_end_clean();
$pdf->Output();
exit;
?>