<?php 
require('fpdf/fpdf.php'); 
include 'conexao.php'; 

// Verifica se os parâmetros necessários foram passados 
if (!isset($_GET['aluno_id']) || !isset($_GET['ano_lectivo'])) { 
    die("Erro: Aluno ou ano letivo não informado."); 
} 

$aluno_id = intval($_GET['aluno_id']); 
$ano_lectivo = $_GET['ano_lectivo']; 

// Conexão com o banco de dados 
if ($conn->connect_error) { 
    die("Falha na conexão: " . $conn->connect_error); 
} 

// 1. Buscar dados completos do aluno 
$sql_aluno = "SELECT nome, nome_pai, nome_mae, data_nascimento, naturalidade, bi_numero FROM alunos WHERE id = ?"; 
$stmt_aluno = $conn->prepare($sql_aluno); 
$stmt_aluno->bind_param("i", $aluno_id); 
$stmt_aluno->execute(); 
$dados_aluno = $stmt_aluno->get_result()->fetch_assoc(); 
$stmt_aluno->close(); 

if (!$dados_aluno) { 
    die("Erro: Aluno não encontrado."); 
} 

// 2. Buscar dados da matrícula para o ano letivo informado 
$sql_matricula = " 
    SELECT  
        m.*,  
        t.nome AS turma_nome, 
        t.classe, 
        t.curso, 
        t.turno, 
        t.sala 
    FROM  
        matriculas m 
    JOIN  
        turmas t ON m.turma_id = t.id 
    WHERE  
        m.aluno_id = ? AND m.ano_letivo = ?  
    LIMIT 1"; 

$stmt_matricula = $conn->prepare($sql_matricula); 
$stmt_matricula->bind_param("is", $aluno_id, $ano_lectivo); 
$stmt_matricula->execute(); 
$dados_matricula = $stmt_matricula->get_result()->fetch_assoc(); 
$stmt_matricula->close(); 
$conn->close(); 

if (!$dados_matricula) { 
    die("Erro: Matrícula não encontrada para este ano letivo."); 
} 

// Preparar dados para o PDF 
setlocale(LC_TIME, 'pt_PT.utf8', 'pt_BR.utf8', 'Portuguese'); 
$dataExtenso = strftime('%d de %B de %Y'); 
$dataHoje = utf8_decode("Complexo Escolar BG0026 Padre Emil Frick-Catumbela, aos $dataExtenso"); 

// Criar PDF 
$pdf = new FPDF(); 
$pdf->AddPage(); 

// Insígnia centralizada 
$pageWidth = $pdf->GetPageWidth(); 
$logoWidth = 30; 
$logoX = ($pageWidth - $logoWidth) / 2; 
$pdf->Image('insignia/insignia.png', $logoX, 10, $logoWidth); 
$pdf->Ln(35); 

// Cabeçalho institucional 
$pdf->SetFont('Arial', 'B', 12); 
$pdf->Cell(0, 6, utf8_decode('REPÚBLICA DE ANGOLA'), 0, 1, 'C'); 
$pdf->Cell(0, 6, utf8_decode('GOVERNO PROVINCIAL DE BENGUELA'), 0, 1, 'C'); 
$pdf->Cell(0, 6, utf8_decode('GABINETE PROVINCIAL DA EDUCAÇÃO'), 0, 1, 'C'); 
$pdf->Cell(0, 6, utf8_decode('COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK - CATUMBELA'), 0, 1, 'C'); 
$pdf->Ln(10); 

// Título 
$pdf->SetFont('Arial', 'B', 14); 
$pdf->Cell(0, 10, utf8_decode('DECLARAÇÃO'), 0, 1, 'C'); 
$pdf->Ln(5); 

// Corpo da declaração 
$pdf->SetFont('Arial', '', 12); 

// Primeiro parágrafo (dividido para formatar o nome)
$texto1_parte1 = utf8_decode("Eduardo Sanjambela Tchandja, Director do Complexo Escolar BG0026 Padre Emil Frick, declara que ");
$pdf->Write(8, $texto1_parte1);

// Nome do aluno em negrito e vermelho
$pdf->SetFont('Arial', 'B', 12); 
$pdf->SetTextColor(255, 0, 0); 
$nome_aluno = utf8_decode($dados_aluno['nome']);
$pdf->Write(8, $nome_aluno);

// Restante do primeiro parágrafo
$pdf->SetFont('Arial', '', 12); 
$pdf->SetTextColor(0); 
$texto1_parte2 = utf8_decode(
    ", filho de " . $dados_aluno['nome_pai'] . " e de " . $dados_aluno['nome_mae'] . 
    ", nascido(a) aos " . date('d/m/Y', strtotime($dados_aluno['data_nascimento'])) . " em " . $dados_aluno['naturalidade'] . 
    ", BI nº " . $dados_aluno['bi_numero'] . ", passado pelo Arquivo de Identificação de Benguela aos 31 de Março de 2021." 
);
$pdf->Write(8, $texto1_parte2);
$pdf->Ln(8);

// Segundo parágrafo
$texto2 = utf8_decode(
    "Frequenta a " . $dados_matricula['classe'] . " Classe no curso de " . $dados_matricula['curso'] . 
    ", Turma " . $dados_matricula['turma_nome'] . ", nº " . $dados_matricula['numero'] . 
    ", período " . $dados_matricula['turno'] . ", sala nº " . $dados_matricula['sala'] . 
    " ano lectivo " . $dados_matricula['ano_letivo'] . "." 
);
$pdf->MultiCell(0, 8, $texto2, 0, 'J');
$pdf->Ln(8);

// Terceiro parágrafo (o restante do texto)
$texto3 = utf8_decode(
    "Mais se declara que o(a) referido(a) aluno(a) frequenta regularmente as aulas nesta Instituição, conforme registo escolar e controlo diário de presenças.\n\n" . 
    "Esta declaração destina-se para efeitos de trabalho.\n\n" . 
    "Por ser verdade e me ter sido solicitada, mandei passar a presente declaração que vai por mim assinada e autenticada com carimbo a óleo em uso nesta Instituição." 
);
$pdf->MultiCell(0, 8, $texto3, 0, 'J');
$pdf->Ln(10); 

// Data 
$pdf->SetFont('Arial', '', 12); 
$pdf->Cell(0, 8, $dataHoje, 0, 1, 'R'); 

// Redução de espaçamento aqui
$pdf->Ln(10); // Reduzido de 20 para 10

// Assinatura 
$pdf->SetFont('Arial', '', 12); 
$pdf->Cell(0, 8, utf8_decode('O DIRECTOR'), 0, 1, 'C'); 

// Adiciona a linha da assinatura 
$pdf->SetLineWidth(0.5); 
$x1 = $pdf->GetX() + 60; 
$y1 = $pdf->GetY() + 10; 
$x2 = $x1 + 80; 
$y2 = $y1; 
$pdf->Line($x1, $y1, $x2, $y2); 
$pdf->Ln(15); 

$pdf->Cell(0, 8, utf8_decode('EDUARDO SANJAMBELA TCHANDJA'), 0, 1, 'C'); 

// Gerar PDF para download 
$pdf->Output("I", "Declaracao_Frequencia_" . utf8_decode($dados_aluno['nome']) . ".pdf"); 
?>