<?php
session_start();
include 'conexao.php';



function formatarDataExtenso($data) {
    if (empty($data) || $data == "0000-00-00") return "";
    $meses = [
        1 => "Janeiro", 2 => "Fevereiro", 3 => "Março", 4 => "Abril",
        5 => "Maio", 6 => "Junho", 7 => "Julho", 8 => "Agosto",
        9 => "Setembro", 10 => "Outubro", 11 => "Novembro", 12 => "Dezembro"
    ];
    $timestamp = strtotime($data);
    $dia = date('j', $timestamp);
    $mes = $meses[(int)date('n', $timestamp)];
    $ano = date('Y', $timestamp);
    return "$dia de $mes de $ano";
}



// Acesso restrito
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'SECRETARIA GERAL') {
    header("Location: login.php");
    exit;
}

// Buscar alunos e anos letivos para o formulário
$alunos_com_anos = [];
$res = $conn->query("SELECT a.id AS aluno_id, a.nome AS aluno_nome, m.ano_letivo
                     FROM alunos a
                     JOIN matriculas m ON a.id = m.aluno_id
                     ORDER BY a.nome, m.ano_letivo DESC");
if ($res) {
    while ($row = $res->fetch_assoc()) {
        $alunos_com_anos[] = $row;
    }
}

$dados_aluno = null;
$tabela_notas = '';
$erro = '';
$aluno_id = $_GET['aluno_id'] ?? null;
$ano_letivo = $_GET['ano_letivo'] ?? null;

if ($aluno_id && $ano_letivo) {
    // Buscar dados do aluno, matrícula e turma em uma única consulta
    $stmt = $conn->prepare("
        SELECT
            a.nome, a.nome_pai, a.nome_mae, a.data_nascimento, a.bi_numero, a.bi_emitido_em, a.bi_data_emissao, a.naturalidade,
            a.provincia, a.municipio, a.classe, a.curso, a.turno, a.numero,
            m.ano_letivo,
            t.nome AS turma_nome
        FROM alunos a
        JOIN matriculas m ON a.id = m.aluno_id
        LEFT JOIN turmas t ON m.turma_id = t.id
        WHERE a.id = ? AND m.ano_letivo = ?
    ");
    if ($stmt) {
        $stmt->bind_param("is", $aluno_id, $ano_letivo);
        $stmt->execute();
        $dados_aluno = $stmt->get_result()->fetch_assoc();
        $stmt->close();
    } else {
        $erro = "Erro na preparação da consulta de dados do aluno: " . $conn->error;
    }

    if (!$dados_aluno) {
        $erro = "Dados do aluno ou matrícula não encontrados para o ano letivo selecionado.";
    } else {
        // A consulta de notas permanece a mesma, pois já está funcionando corretamente
        $stmt_notas = $conn->prepare("
            SELECT
                d.nome AS disciplina_nome,
                n.mf
            FROM notas n
            JOIN disciplinas d ON n.disciplina_id = d.id
            WHERE n.aluno_id = ? AND n.ano_lectivo = ?
            AND n.id = (
                SELECT MAX(id)
                FROM notas
                WHERE aluno_id = n.aluno_id
                  AND disciplina_id = n.disciplina_id
                  AND ano_lectivo = n.ano_lectivo
            )
            ORDER BY d.nome
        ");

        if ($stmt_notas) {
            $stmt_notas->bind_param("is", $aluno_id, $ano_letivo);
            $stmt_notas->execute();
            $notas_aluno = $stmt_notas->get_result()->fetch_all(MYSQLI_ASSOC);
            $stmt_notas->close();
        } else {
            $erro = "Erro na preparação da consulta de notas: " . $conn->error;
        }

        ob_start();
        ?>
        <table border='1' style='border-collapse: collapse; width: 100%; margin-top: 10px; font-size: 11pt;'>
            <thead>
                <tr>
                    <th style="background-color: #ffffff;">Disciplinas</th>
                    <th style="background-color: #ffffff;">Nota Final</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($notas_aluno)): ?>
                    <tr><td colspan="2" style="text-align: center;">Nenhuma nota encontrada para este aluno e ano letivo.</td></tr>
                <?php else: ?>
                    <?php foreach ($notas_aluno as $nota):
                        $cor = (is_numeric($nota['mf']) && $nota['mf'] < 10) ? 'red' : 'black';
                    ?>
                    <tr>
                        <td style="text-align:left; padding-left:10px;"><?= htmlspecialchars($nota['disciplina_nome']) ?></td>
                        <td style="text-align:center; color:<?= $cor ?>;"><?= htmlspecialchars($nota['mf'] ?? '-') ?></td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
        <?php
        $tabela_notas = ob_get_clean();
    }
} else {
    $erro = "Selecione um aluno e um ano letivo para gerar a declaração.";
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Declaração com Notas</title>
    <style>
        body { font-family: 'Times New Roman', serif; font-size: 11pt; margin: 0; padding: 10px; background-color: #fff; }
        .no-print {
            text-align: center;
            margin: 20px auto;
            padding: 20px;
            border: 1px solid #ddd;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            max-width: 600px;
        }
        .no-print h2 { font-size: 20px; color: #333; margin-bottom: 20px; }
        .no-print form { display: flex; flex-direction: column; gap: 15px; align-items: center; }
        .no-print label { font-weight: bold; font-size: 16px; color: #555; width: 100%; text-align: left; }
        .no-print select, .no-print button {
            width: 100%; padding: 12px; font-size: 16px; border-radius: 5px; border: 1px solid #ccc; box-sizing: border-box;
            -webkit-appearance: none; -moz-appearance: none; appearance: none; background-color: #f8f8f8;
        }
        .no-print select:focus, .no-print button:focus {
            outline: none; border-color: #007bff; box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
        }
        .no-print button {
            background-color: #007bff; color: #fff; border: none; cursor: pointer; transition: background-color 0.3s ease; margin-top: 10px;
        }
        .no-print button:hover { background-color: #0056b3; }
        #declaracao-container { max-width: 900px; margin: 20px auto; border: 1px solid #000; padding: 20px; box-sizing: border-box; background-color: #fff; }
        .header { text-align: center; margin-bottom: 10px; }
        .header h1, .header h2, .header h3 { margin: 0; padding: 1px 0; font-weight: normal; font-size: 12pt; }
        .header img { max-width: 70px; margin-bottom: 5px; }
        .titulo-declaracao { font-size: 14pt; font-weight: bold; text-align: center; margin-top: 10px; margin-bottom: 10px; text-decoration: underline; }
        .corpo-declaracao { text-align: justify; text-indent: 20px; line-height: 1.3; margin-bottom: 10px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; margin-bottom: 10px; font-size: 10pt; }
        th, td { border: 1px solid #000; padding: 6px; text-align: center; }
        th { background-color: #ffffff; font-weight: bold; }
        .assinatura { text-align: center; margin-top: 30px; }
        .assinatura .linha { width: 200px; margin: 5px auto; border-top: 1px solid #000; }
        .data { text-align: right; margin-top: 15px; }
        .print-btn { display: block; width: 50%; margin: 20px auto; }
        @media print {
            body * { visibility: hidden; }
            #declaracao-container, #declaracao-container * { visibility: visible; background-color: white; }
            #declaracao-container { position: absolute; left: 0; top: 0; width: 100%; border: none; box-shadow: none; margin: 0; padding: 15mm; box-sizing: border-box; }
            .no-print { display: none; }
            .corpo-declaracao { text-indent: 30px; line-height: 1.2; }
            .header img { max-width: 60px; }
            .header h3 { font-size: 11pt; }
            .titulo-declaracao { font-size: 13pt; }
            table { font-size: 9pt; }
            th, td { padding: 4px; }
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const alunosData = <?php echo json_encode($alunos_com_anos); ?>;
            const alunoSelect = document.getElementById('aluno_id');
            const anoSelect = document.getElementById('ano_letivo');

            function popularAnosLetivos(selectedAlunoId, selectedAnoLetivo = null) {
                anoSelect.innerHTML = '<option value="">-- Selecionar Ano Letivo --</option>';
                if (selectedAlunoId) {
                    const anosDoAluno = alunosData
                        .filter(aluno => aluno.aluno_id == selectedAlunoId)
                        .map(aluno => aluno.ano_letivo)
                        .filter((value, index, self) => self.indexOf(value) === index)
                        .sort((a, b) => b - a);

                    anosDoAluno.forEach(ano => {
                        const option = document.createElement('option');
                        option.value = ano;
                        option.textContent = ano;
                        if (ano == selectedAnoLetivo) {
                            option.selected = true;
                        }
                        anoSelect.appendChild(option);
                    });
                }
            }

            alunoSelect.addEventListener('change', function() {
                const selectedAlunoId = this.value;
                popularAnosLetivos(selectedAlunoId);
            });

            const urlParams = new URLSearchParams(window.location.search);
            const selectedAlunoId = urlParams.get('aluno_id');
            const selectedAnoLetivo = urlParams.get('ano_letivo');

            if (selectedAlunoId) {
                alunoSelect.value = selectedAlunoId;
                popularAnosLetivos(selectedAlunoId, selectedAnoLetivo);
            }
        });
    </script>
</head>
<body>

<div class="no-print">
    <h2>Gerar Declaração com Notas</h2>
    <?php if ($erro): ?>
        <p style="color:red; font-weight:bold;"><?= htmlspecialchars($erro) ?></p>
    <?php endif; ?>

    <form method="GET">
        <label for="aluno_id">Aluno:</label>
        <select name="aluno_id" id="aluno_id" required>
            <option value="">-- Selecionar Aluno --</option>
            <?php
            $alunos_unicos = [];
            foreach ($alunos_com_anos as $aluno) {
                if (!isset($alunos_unicos[$aluno['aluno_id']])) {
                    $alunos_unicos[$aluno['aluno_id']] = $aluno['aluno_nome'];
                }
            }
            asort($alunos_unicos);
            foreach ($alunos_unicos as $id => $nome): ?>
                <option value="<?= $id ?>" <?= ($id == $aluno_id) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($nome) ?>
                </option>
            <?php endforeach; ?>
        </select>
        <label for="ano_letivo">Ano Letivo:</label>
        <select name="ano_letivo" id="ano_letivo" required>
            <option value="">-- Selecionar Ano Letivo --</option>
            </select>
        <button type="submit">Gerar Declaração</button>
    </form>
</div>

<?php if ($dados_aluno): ?>
    <div id="declaracao-container">
        <div class="header">
            <img src="insignia/insignia.png" alt="Insígnia">
            <h3>REPÚBLICA DE ANGOLA</h3>
            <h3>GOVERNO PROVINCIAL DE BENGUELA</h3>
            <h3>GABINETE PROVINCIAL DA EDUCAÇÃO</h3>
            <h3>COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK - CATUMBELA</h3>
        </div>
        
        <h2 class="titulo-declaracao">DECLARAÇÃO</h2>

        <div class="corpo-declaracao">
            <p>
                Eduardo Sanjambela Tchandja, Director em exercício deste Complexo Escolar, declara que, <span style="color: red;"><?= htmlspecialchars($dados_aluno['nome']) ?></span>,
filho(a) de <?= htmlspecialchars($dados_aluno['nome_pai'] ?? '') ?> e de <?= htmlspecialchars($dados_aluno['nome_mae'] ?? '') ?>,
nascido(a) aos <?= formatarDataExtenso($dados_aluno['data_nascimento']) ?> em <?= htmlspecialchars($dados_aluno['naturalidade'] ?? '') ?>, 
município de <?= htmlspecialchars($dados_aluno['municipio'] ?? '') ?> província de <?= htmlspecialchars($dados_aluno['provincia'] ?? '') ?>,
portadora do B.I.nº <?= htmlspecialchars($dados_aluno['bi_numero'] ?? '') ?>
passado pelo Arquivo de Identificação de <?= htmlspecialchars($dados_aluno['bi_emitido_em'] ?? '') ?>,
aos <?= formatarDataExtenso($dados_aluno['bi_data_emissao']) ?>.


            </p>


            <p style="margin-top: 10px;">
                Concluiu com aproveitamento a <?= htmlspecialchars($dados_aluno['classe']) ?> classe, no curso de <?= htmlspecialchars($dados_aluno['curso']) ?> na turma <?= htmlspecialchars($dados_aluno['turma_nome'] ?? '') ?>, nº<?= htmlspecialchars($dados_aluno['numero'] ?? '') ?>, período <?= htmlspecialchars($dados_aluno['turno'] ?? '') ?>, no ano lectivo <?= htmlspecialchars($dados_aluno['ano_letivo']) ?> tal como espelham as notas abaixo descriminadas:
            </p>
        </div>

        <?= $tabela_notas ?>

        <div class="corpo-declaracao">
            <p style="margin-bottom: 10px;">Esta declaração destina-se para efeito de trabalho.</p>
            <p>Por ser verdade e me ter sido solicitada, mandei passar a presente declaração que vai por mim assinada e autenticada com carimbo a óleo em uso nesta Instituição.</p>
        </div>

        <div class="assinatura">
            <div style="font-weight:bold; margin-bottom: 5px;">
                Complexo Escolar BG0026 Padre Emil Frick – Catumbela, <?= date('d') ?> de <?= date('F') ?> de <?= date('Y') ?>.
            </div>
            <br>
            <div style="font-weight:bold;">O DIRECTOR</div>
            <div class="linha"></div>
            <div>EDUARDO SANJAMBELA TCHANDJA</div>
        </div>
        <div style="text-align:center; margin-top:10px;" class="no-print">
            <button onclick="window.print()">Imprimir Declaração</button>
        </div>
    </div>
<?php elseif ($erro): ?>
    <div style="text-align: center; margin-top: 20px;">
        <p style="color:red; font-weight:bold;"><?= htmlspecialchars($erro) ?></p>
    </div>
<?php endif; ?>

</body>
</html>