<?php
session_start();
include 'conexao.php';

function cabecalhoHorario($titulo) {
  echo "<h2 style='text-align:center; margin-top:20px;'> $titulo</h2>";
}

function renderTabelaHorario($horas, $dadosHorario) {
  echo "<table border='1' cellspacing='0' cellpadding='5' style='width:100%; border-collapse:collapse; margin-bottom:40px;'>";
  echo "<thead style='background-color:#004080; color:white;'>";
  echo "<tr><th>Hora</th><th>Segunda</th><th>Terça</th><th>Quarta</th><th>Quinta</th><th>Sexta</th></tr>";
  echo "</thead><tbody>";

  foreach ($horas as $tempo => $hora) {
    echo "<tr><td style='background:#f0f0f0; font-weight:bold;'>$hora</td>";
    for ($dia = 1; $dia <= 5; $dia++) {
      $key = "$tempo-$dia";
      $aula = $dadosHorario[$key] ?? '';
      echo "<td style='text-align:center;'>$aula</td>";
    }
    echo "</tr>";
  }

  echo "</tbody></table>";
}

// Buscar todas as turmas
$turmas = $conn->query("SELECT * FROM turmas ORDER BY turno, classe, nome");

// Definição dos horários
$horas_manha = [
  1 => "07:00 - 07:45",
  2 => "07:50 - 08:35",
  3 => "08:40 - 09:25",
  4 => "09:40 - 10:25",
  5 => "10:30 - 11:15",
  6 => "11:20 - 12:05",
];

$horas_tarde = [
  1 => "13:00 - 13:45",
  2 => "13:50 - 14:35",
  3 => "14:40 - 15:25",
  4 => "15:40 - 16:25",
  5 => "16:30 - 17:15",
  6 => "17:20 - 18:05",
];

// Exibir grelha por turma
echo "<h1 style='text-align:center; color:#004080;'>Grelha de Horários por Turma</h1>";
while ($turma = $turmas->fetch_assoc()) {
  $turma_id = $turma['id'];
  $turno = strtolower($turma['turno']);
  $horas = $turno === 'tarde' ? $horas_tarde : $horas_manha;
  $cabecalho = "Classe: {$turma['classe']} - Turma: {$turma['nome']} - Curso: {$turma['curso']} - Turno: {$turma['turno']} - Sala: {$turma['sala']}";

  cabecalhoHorario($cabecalho);

  // Buscar horário da turma
 $horario_result = $conn->query("
  SELECT h.*, d.nome AS disciplina_nome 
  FROM horario h 
  JOIN disciplinas d ON h.disciplina_id = d.id 
  WHERE h.turma_id = $turma_id
");

  $dadosHorario = [];
  while ($linha = $horario_result->fetch_assoc()) {
    $chave = $linha['tempo'] . '-' . $linha['dia_semana'];
    $dadosHorario[$chave] = $linha['disciplina'];
  }

  renderTabelaHorario($horas, $dadosHorario);
}

// Exibir grelha por professor
echo "<h1 style='text-align:center; color:#004080;'>Grelha de Horários por Professor</h1>";
$professores = $conn->query("SELECT id, nome FROM usuarios WHERE perfil = 'Professor' ORDER BY nome");

while ($prof = $professores->fetch_assoc()) {
  $prof_id = $prof['id'];
  cabecalhoHorario("Professor: {$prof['nome']}");

  $dadosHorario = [];

  // JOIN para pegar disciplina (nome), turma (classe, nome)
  $result = $conn->query("
    SELECT h.*, d.nome AS disciplina_nome, t.classe, t.nome AS turma_nome, t.turno
    FROM horario h
    JOIN disciplinas d ON h.disciplina_id = d.id
    JOIN turmas t ON h.turma_id = t.id
    WHERE h.professor_id = $prof_id
  ");

  $turno_padrao = 'manha';
  while ($linha = $result->fetch_assoc()) {
    $chave = $linha['tempo'] . '-' . $linha['dia_semana'];
    $dadosHorario[$chave] = $linha['disciplina_nome'] . "<br><small>{$linha['classe']} {$linha['turma_nome']}</small>";
    $turno_padrao = strtolower($linha['turno']);
  }

  $horas = $turno_padrao === 'tarde' ? $horas_tarde : $horas_manha;
  renderTabelaHorario($horas, $dadosHorario);
}
