<?php
require_once __DIR__ . '/vendor/autoload.php';
include 'conexao.php';

$nome = $_GET['nome'] ?? '';
$curso = $_GET['curso'] ?? '';
$ano = $_GET['ano'] ?? '';
$turno = $_GET['turno'] ?? '';

// Buscar alunos da turma
$stmt = $conn->prepare("SELECT nome, idade, genero FROM alunos WHERE turma = ? ORDER BY nome ASC");
$stmt->bind_param("s", $nome);
$stmt->execute();
$result = $stmt->get_result();

// Gerar HTML para o PDF
$html = '
<style>
    body { font-family: Arial, sans-serif; }
    h2, h4 { text-align: center; margin: 0; }
    .info { margin-top: 10px; font-size: 14px; }
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
        font-size: 12px;
    }
    th, td {
        border: 1px solid #000;
        padding: 6px;
        text-align: center;
    }
    th {
        background-color: #f2f2f2;
    }
</style>

<h2>Magistério 5 de Outubro</h2>
<h4>Lista Nominal de Alunos</h4>
<div class="info">
    <strong>Turma:</strong> ' . htmlspecialchars($nome) . ' &nbsp;&nbsp;&nbsp;
    <strong>Curso:</strong> ' . htmlspecialchars($curso) . ' &nbsp;&nbsp;&nbsp;
    <strong>Ano Lectivo:</strong> ' . htmlspecialchars($ano) . ' &nbsp;&nbsp;&nbsp;
    <strong>Período:</strong> ' . htmlspecialchars($turno) . '
</div>
<table>
    <thead>
        <tr>
            <th>N°</th>
            <th>Nome</th>
            <th>Idade</th>
            <th>Género</th>
        </tr>
    </thead>
    <tbody>';
$i = 1;
while ($row = $result->fetch_assoc()) {
    $html .= '<tr>
                <td>' . $i++ . '</td>
                <td>' . htmlspecialchars($row['nome']) . '</td>
                <td>' . $row['idade'] . '</td>
                <td>' . $row['genero'] . '</td>
              </tr>';
}
$html .= '
    </tbody>
</table>';

// Gerar PDF
$mpdf = new \Mpdf\Mpdf(['format' => 'A4']);
$mpdf->SetTitle("Lista da Turma $nome");
$mpdf->WriteHTML($html);
$mpdf->Output("lista_turma_$nome.pdf", 'I');

