<?php
// Inclui o arquivo de conexão com o banco de dados
include 'conexao.php';

// Pega o ID da turma da URL e garante que seja um número inteiro.
// Se não for encontrado, usa 0 como valor padrão.
$turma_id = isset($_GET['turma_id']) ? (int)$_GET['turma_id'] : 0;

// Inicializa a variável que vai armazenar as opções do select
$options = "<option value=''>Selecionar Disciplina</option>";

// Somente executa a consulta se um turma_id válido for fornecido
if ($turma_id > 0) {
    // 1. Prepara a declaração SQL com um 'placeholder' (?)
    $sql = "
        SELECT DISTINCT d.id, d.nome
        FROM atribuicoes a
        INNER JOIN disciplinas d ON a.disciplina_id = d.id
        WHERE a.turma_id = ?
          AND a.ano_lectivo = '2025/2026'
        ORDER BY d.nome
    ";

    $stmt = $conn->prepare($sql);

    // 2. Verifica se a preparação da consulta foi bem-sucedida
    if ($stmt) {
        // 3. Vincula o parâmetro 'turma_id' ao placeholder. 'i' significa que é um inteiro.
        $stmt->bind_param("i", $turma_id);
        
        // 4. Executa a consulta
        $stmt->execute();
        
        // 5. Obtém o resultado da consulta
        $result = $stmt->get_result();

        // 6. Percorre os resultados e constrói as opções do select
        while ($row = $result->fetch_assoc()) {
            // Usa htmlspecialchars para evitar ataques XSS (Cross-Site Scripting)
            $options .= "<option value='" . htmlspecialchars($row['id']) . "'>" . htmlspecialchars($row['nome']) . "</option>";
        }

        // 7. Fecha a declaração
        $stmt->close();
    }
}

// 8. Exibe as opções geradas
echo $options;

// 9. Fecha a conexão com o banco de dados no final do script
$conn->close();
?>