<?php
session_start();
include 'conexao.php';

// Verifique se o usuário está logado
if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}

// Obtenha o filtro de mês da URL, se existir
$mes_filtro = $_GET['mes'] ?? '';

// Consulta ajustada para incluir o campo 'status' da tabela 'propinas'
$sql = "SELECT p.id AS id_pagamento, a.nome AS aluno, p.mes_pagamento, p.valor, p.data_pagamento, p.status
        FROM alunos a
        LEFT JOIN propinas p ON a.id = p.aluno_id";

// Se um mês foi filtrado, adicione a cláusula WHERE
if ($mes_filtro) {
    $sql .= " WHERE p.mes_pagamento = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $mes_filtro);
    $stmt->execute();
    $res = $stmt->get_result();
} else {
    // Se nenhum filtro for aplicado, execute a consulta diretamente
    $res = $conn->query($sql);
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Histórico de Pagamentos</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f4f6f9;
            margin: 0;
            padding: 20px;
        }
        h2 {
            text-align: center;
            color: #003366;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ccc;
            padding: 8px;
            text-align: left;
            font-size: 14px;
        }
        th {
            background: #003366;
            color: white;
        }
        select {
            padding: 5px;
        }
        .btn-recibo, .btn-alterar {
            padding: 5px 10px;
            color: white;
            border: none;
            border-radius: 4px;
            text-decoration: none;
            font-size: 13px;
            margin-right: 5px;
        }
        .btn-recibo {
            background: #003366;
        }
        .btn-recibo:hover {
            background: #00509e;
        }
        .btn-alterar {
            background: #ff9800;
        }
        .btn-alterar:hover {
            background: #e68900;
        }
        .btn-bulk-print {
            background: #dc3545; /* Cor para destaque */
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-weight: bold;
            margin-left: 10px;
            transition: background 0.3s;
        }
        .btn-bulk-print:hover {
            background: #c82333;
        }
        /* Estilo para a célula da checkbox */
        td.checkbox-cell {
            text-align: center;
            width: 30px;
        }
    </style>
    <script>
        function checkBulkPrint() {
            const checkboxes = document.querySelectorAll('input[name="ids[]"]:checked');
            if (checkboxes.length === 0) {
                alert("Selecione pelo menos um pagamento para impressão em massa.");
                return false;
            }
            if (checkboxes.length > 6) {
                alert(`Você selecionou ${checkboxes.length} recibos. O limite para impressão em massa por folha é de 6.`);
                return false;
            }
            return true;
        }
        
        function toggleAll(source) {
            const checkboxes = document.querySelectorAll('input[name="ids[]"]');
            checkboxes.forEach(checkbox => {
                checkbox.checked = source.checked;
            });
        }
    </script>
</head>
<body>

<a href="painel_secretaria_geral.php" style="
    display: inline-block;
    margin: 20px;
    padding: 10px 20px;
    background-color: #003366;
    color: white;
    text-decoration: none;
    border-radius: 5px;
    font-weight: bold;
">
    ⬅ Voltar ao Painel
</a>

<h2>Histórico de Pagamento de Propinas</h2>

<form method="get" style="margin-bottom: 20px; text-align: center;">
    <label for="mes">Filtrar por Mês:</label>
    <select name="mes" id="mes" onchange="this.form.submit()">
        <option value="">Todos os meses</option>
        <?php
        $meses = ['Janeiro','Fevereiro','Março','Abril','Maio','Junho',
                  'Julho','Agosto','Setembro','Outubro','Novembro','Dezembro'];
        foreach ($meses as $mes) {
            $selected = $mes === $mes_filtro ? "selected" : "";
            echo "<option value=\"$mes\" $selected>$mes</option>";
        }
        ?>
    </select>
</form>

<!-- NOVO FORMULÁRIO PARA IMPRESSÃO EM MASSA -->
<form method="get" action="recibo_massa.php" target="_blank" onsubmit="return checkBulkPrint()" style="margin-bottom: 20px; text-align: center;">
    <button type="submit" class="btn-bulk-print">
        🖨️ Imprimir Selecionados (Máx. 6)
    </button>

    <table>
        <tr>
            <th class="checkbox-cell"><input type="checkbox" onclick="toggleAll(this)"></th>
            <th style="width: 25%;">Nome do Aluno</th>
            <th style="width: 15%;">Mês de Pagamento</th>
            <th style="width: 10%;">Status</th>
            <th style="width: 15%;">Valor</th>
            <th style="width: 15%;">Data</th>
            <th style="width: 20%;">Ações</th>
        </tr>
        <?php if ($res && $res->num_rows > 0): ?>
            <?php $res->data_seek(0); // Reposiciona o ponteiro de resultado ?>
            <?php while ($row = $res->fetch_assoc()): ?>
                <tr>
                    <td class="checkbox-cell">
                        <?php if (!empty($row['id_pagamento'])): ?>
                            <!-- Apenas permite seleção de pagamentos que realmente existem -->
                            <input type="checkbox" name="ids[]" value="<?= htmlspecialchars($row['id_pagamento']) ?>">
                        <?php endif; ?>
                    </td>
                    <td><?= htmlspecialchars($row['aluno']) ?></td>
                    <td><?= htmlspecialchars($row['mes_pagamento'] ?? '-') ?></td>
                    <td>
                        <?php if (!empty($row['status'])): ?>
                            <span style="color:green; font-weight:bold;"><?= htmlspecialchars($row['status']) ?></span>
                        <?php else: ?>
                            <span style="color:red; font-weight:bold;">Não Pago</span>
                        <?php endif; ?>
                    </td>
                    <td><?= $row['valor'] ? number_format($row['valor'], 2, ',', '.') . " Kz" : '-' ?></td>
                    <td><?= $row['data_pagamento'] ? date("d/m/Y", strtotime($row['data_pagamento'])) : '-' ?></td>
                    <td>
                        <?php if (!empty($row['id_pagamento'])): ?>
                            <a class="btn-recibo" href="recibo_propina.php?id=<?= $row['id_pagamento'] ?>" target="_blank">Ver Recibo</a>
                            <a class="btn-alterar" href="alterar_pagamento.php?id=<?= $row['id_pagamento'] ?>">Alterar</a>
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endwhile; ?>
        <?php else: ?>
            <tr><td colspan="7" style="text-align:center;">Nenhum registro encontrado.</td></tr>
        <?php endif; ?>
    </table>
</form>

</body>
</html>
