<?php
session_start();
include 'conexao.php';

if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}

// Dias e tempos padronizados
date_default_timezone_set('Africa/Luanda');
$dias = ['Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta'];
$tempos = [
    '07:30-08:15',
    '08:20-09:05',
    '09:10-09:55',
    '10:10-10:55',
    '11:00-11:45',
    '11:50-12:35'
];

$turma_id = isset($_GET['turma_id']) ? intval($_GET['turma_id']) : 0;
if (!$turma_id) die("Turma não especificada.");

// Verifica se o horário já existe
$acao = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['acao'])) {
    $acao = $_POST['acao'];
}

// Buscar disciplinas e professores atribuídos 
$sql = "SELECT a.*, d.nome AS disciplina, p.nome AS professor 
        FROM atribuicoes a 
        JOIN disciplinas d ON a.disciplina_id = d.id
        LEFT JOIN professores p ON a.professor_id = p.id
        WHERE a.turma_id = ? AND a.tempos_semana > 0";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $turma_id);
$stmt->execute();
$atribuicoes = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// Inicializar matriz do horário [dia][tempo] = disciplina
$horario = [];
foreach ($dias as $dia) {
    foreach ($tempos as $tempo) {
        $horario[$dia][$tempo] = null;
    }
}

// Controle de ocupação por professor
$ocupado = [];
foreach ($atribuicoes as $a) {
    $temposRestantes = $a['tempos_semana'];
    $disc = $a['disciplina'];
    $prof = $a['professor'];
    foreach ($dias as $dia) {
        foreach ($tempos as $tempo) {
            if ($temposRestantes <= 0) break;

            if ($horario[$dia][$tempo] === null && !isset($ocupado[$prof][$dia][$tempo])) {
                $horario[$dia][$tempo] = [
                    'disciplina' => $disc,
                    'professor' => $prof
                ];
                $ocupado[$prof][$dia][$tempo] = true;
                $temposRestantes--;
            }
        }
        if ($temposRestantes <= 0) break;
    }
}

// Salvar no banco de dados se ação definida
if ($acao === 'atualizar') {
    $conn->query("DELETE FROM horario WHERE turma_id = $turma_id");
} 

if ($acao === 'atualizar' || $acao === 'acrescentar') {
    $stmt = $conn->prepare("INSERT INTO horario (turma_id, dia, tempo, disciplina, professor) VALUES (?, ?, ?, ?, ?)");
    foreach ($dias as $dia) {
        foreach ($tempos as $tempo) {
            if ($horario[$dia][$tempo]) {
                $stmt->bind_param("issss", $turma_id, $dia, $tempo, $horario[$dia][$tempo]['disciplina'], $horario[$dia][$tempo]['professor']);
                $stmt->execute();
            }
        }
    }
    echo "<script>alert('Horário salvo com sucesso!');</script>";
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Horário Gerado</title>
  <style>
    body { font-family: 'Segoe UI', sans-serif; background: #f4f6f9; padding: 40px; }
    h2 { text-align: center; color: #003366; }
    table { width: 100%; border-collapse: collapse; background: white; margin-top: 20px; }
    th, td { border: 1px solid #ccc; padding: 10px; text-align: center; font-size: 13px; }
    th { background: #003366; color: white; }
    td small { display: block; font-size: 11px; color: #666; }
    form { text-align: center; margin-top: 20px; }
    select, button { padding: 8px 12px; margin: 10px; }
    .btn-print { background: green; color: white; padding: 6px 10px; border: none; border-radius: 4px; }
  </style>
</head>
<body>

<h2>Horário Gerado para a Turma <?= $turma_id ?></h2>

<form method="POST">
  <input type="hidden" name="acao" id="acao">
  <button type="button" onclick="definirAcao('atualizar')">Atualizar Horário</button>
  <button type="button" onclick="definirAcao('acrescentar')">Acrescentar ao Horário</button>
</form>

<table>
  <thead>
    <tr>
      <th>Hora</th>
      <?php foreach ($dias as $dia): ?>
        <th><?= $dia ?></th>
      <?php endforeach; ?>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($tempos as $tempo): ?>
      <tr>
        <td><?= $tempo ?></td>
        <?php foreach ($dias as $dia): ?>
          <td>
            <?php if (isset($horario[$dia][$tempo])): ?>
              <?= $horario[$dia][$tempo]['disciplina'] ?><br>
              <small><?= $horario[$dia][$tempo]['professor'] ?></small>
            <?php else: ?>
              -
            <?php endif; ?>
          </td>
        <?php endforeach; ?>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>

<div style="text-align: center; margin-top: 20px;">
  <a href="imprimir_horario.php?turma_id=<?= $turma_id ?>" class="btn-print">Imprimir Horário</a>
</div>

<script>
function definirAcao(tipo) {
  document.getElementById('acao').value = tipo;
  document.forms[0].submit();
}
</script>

</body>
</html>