<?php

// --- 1. CONFIGURAÇÕES FIXAS (Autoridades e Localização) ---
const DIRECTOR_NOME = 'JORGE JOAQUIM MANECO';
const MUNICIPAL_EDUCACAO = 'DIREÇÃO MUNICIPAL DA EDUCAÇÃO DE BENGUELA';
const LOCAL_DATA_FIXA = 'DIRECÇÃO MUNICIPAL DA EDUCAÇÃO DE BENGUELA, AOS ';
const DATA_ATUAL = '07 DE OUTUBRO DE 2025'; 

// =========================================================================
// !!! BLOCO DE INTEGRAÇÃO DA BASE DE DADOS (Cópia da Lógica Necessária) !!!
// =========================================================================

// PASSO 1: Incluir o arquivo de conexão
try {
    // Caracteres invisíveis removidos desta seção.
    include 'conexao.php';
    if (!isset($conn) || !$conn instanceof mysqli) {
        // Não é necessário um die() aqui, mas sim uma mensagem de erro na tela de impressão.
        $conn_status_message = "Erro: Conexão não é válida.";
        $conn = null;
    }
} catch (Exception $e) {
    $conn_status_message = "Erro fatal na conexão: " . $e->getMessage();
    $conn = null;
}

$funcionario_selecionado = null;
$documento_final = null;
$nome_documento = 'Documento de Declaração';
$user_id = (int)($_GET['user'] ?? 0);
$template_id = $_GET['doc'] ?? null;

// --- Consulta 2: Detalhes Completos do Funcionário Selecionado ---
if ($user_id > 0 && $template_id && isset($conn)) {
    
    $sql_detalhes = "
        SELECT 
            nome, agente, bi, data_bi, categoria, salario_liq, 
            salario_extenso, escola, iban, ano_inicio, ano_fim, 
            total_anos, data_inicio_completa
        FROM usuarios
        WHERE id = ?
    ";
    
    $stmt = $conn->prepare($sql_detalhes);
    if ($stmt) {
        $stmt->bind_param('i', $user_id);
        $stmt->execute();
        $result_detalhes = $stmt->get_result();
        
        if ($result_detalhes && $result_detalhes->num_rows > 0) {
            $funcionario_selecionado = $result_detalhes->fetch_assoc();
        } 
        $stmt->close();
    } 
}

// --- 3. DEFINIÇÃO DOS MODELOS DE DOCUMENTOS (Templates - Cópia) ---
$documentos = [
    'residencia' => [
        'nome' => 'Declaração de Aquisição de Residência',
        'finalidade' => 'aquisição de uma residência junto ao Fundo de Fomento Habitacional',
        'template' => '
            <p class="text-center font-bold">DECLARAÇÃO DE EFECTIVIDADE</p>
            <p>{{DIRECTOR}} , Director Municipal de Educação, declara para efeitos de {{FINALIDADE}}, que o(a) Senhor(a) **{{NOME}}**, é funcionário(a) do Ministério da Educação, colocado(a) no(a) {{ESCOLA}}, portador(a) do B.I nº **{{BI}}**, passado pelo Arquivo de Identificação de Benguela aos **{{DATA_BI}}**, com a categoria de **{{CATEGORIA}}**, agente nº **{{AGENTE}}**, auferindo um salário líquido mensal de AOA **{{SALARIO_LIQ}}** {{SALARIO_EXTENSO}}.</p>
            <p>Por ser verdade e me ter sido solicitada, mandei passar a presente Declaração, que vai por mim assinada e autenticada com o Carimbo a óleo em uso nesta Direcção Municipal de Educação.</p>
        ',
    ],
    'tempo_servico' => [
        'nome' => 'Declaração de Contagem de Tempo de Serviço',
        'finalidade' => 'contagem de tempo de serviço',
        'template' => '
            <p class="text-center font-bold">DECLARAÇÃO DE EFECTIVIDADE</p>
            <p>{{DIRECTOR}} , Director Municipal de Educação, declara para efeitos de {{FINALIDADE}}, que o(a) Senhor(a) **{{NOME}}**, foi funcionário(a) do Ministério da Educação em efectivo serviço, controlado(a) por esta Direcção Municipal de Educação, no período de **{{ANO_INICIO_EXT}}** à **{{ANO_FIM_EXT}}**, totalizando **{{TOTAL_ANOS}}** anos de serviço.</p>
            <p>Por ser verdade e me ter sido solicitada, mandei passar a presente Declaração, que vai por mim assinada e autenticada com o Carimbo a óleo em uso nesta Direcção Municipal de Educação.</p>
        ',
    ],
    'mudanca_banco' => [
        'nome' => 'Declaração de Mudança de Banco',
        'finalidade' => 'mudança de Banco para domiciliação dos salários',
        'template' => '
            <p class="text-center font-bold">DECLARAÇÃO DE EFECTIVIDADE</p>
            <p>{{DIRECTOR}} , Director Municipal de Educação, declara para efeitos de {{FINALIDADE}}, que o(a) Senhor(a) **{{NOME}}**, com a categoria de **{{CATEGORIA}}**, agente nº **{{AGENTE}}**, funcionário(a) colocado(a) no(a) **{{ESCOLA}}** com a conta bancária com IBAN n.º **{{IBAN}}**.</p>
            <p>Por ser verdade e me ter sido solicitada, mandei passar a presente Declaração, que vai por mim assinada e autenticada com o Carimbo a óleo em uso nesta Direcção Municipal de Educação.</p>
        ',
    ],
    'subsidio_morte' => [
        'nome' => 'Declaração de Subsídio de Morte (Pensão)',
        'finalidade' => 'obtenção de pensão alimentar dos menores sobrevivos de {{NOME}}',
        'template' => '
            <p class="text-center font-bold">DECLARAÇÃO DE EFECTIVIDADE</p>
            <p>{{DIRECTOR}} , Director Municipal de Educação, declara para efeitos de {{FINALIDADE}}, que este foi funcionário do Sector da Educação, colocado no {{ESCOLA}} com a categoria de **{{CATEGORIA}}**, tendo iniciado suas funções aos **{{DATA_INICIO_COMPLETA}}**, atividade que exerceu até o ano de **{{ANO_FIM}}**, totalizando **{{TOTAL_ANOS}}** anos de efetivo serviço.</p>
            <p>Por ser verdade e me ter sido solicitada, mandei passar a presente Declaração, que vai por mim assinada e autenticada com o Carimbo a óleo em uso nesta Direcção Municipal de Educação.</p>
        ',
    ],
];

// --- 4. LÓGICA DE GERAÇÃO DINÂMICA DO DOCUMENTO ---

if ($funcionario_selecionado && $template_id && isset($documentos[$template_id])) {
    $doc_info = $documentos[$template_id];
    $nome_documento = $doc_info['nome'];
    $template = $doc_info['template'];

    // Mapeamento dos dados do funcionário
    $placeholders = [
        '{{DIRECTOR}}' => DIRECTOR_NOME,
        '{{FINALIDADE}}' => $doc_info['finalidade'],
        '{{NOME}}' => $funcionario_selecionado['nome'] ?? 'NÃO ENCONTRADO',
        '{{BI}}' => $funcionario_selecionado['bi'] ?? 'NÃO ENCONTRADO',
        '{{DATA_BI}}' => $funcionario_selecionado['data_bi'] ?? 'NÃO ENCONTRADO',
        '{{CATEGORIA}}' => $funcionario_selecionado['categoria'] ?? 'NÃO ENCONTRADO',
        '{{AGENTE}}' => $funcionario_selecionado['agente'] ?? 'NÃO ENCONTRADO',
        '{{SALARIO_LIQ}}' => $funcionario_selecionado['salario_liq'] ?? 'NÃO ENCONTRADO',
        '{{SALARIO_EXTENSO}}' => $funcionario_selecionado['salario_extenso'] ?? '(Valor por extenso não disponível)',
        '{{ESCOLA}}' => $funcionario_selecionado['escola'] ?? 'NÃO ENCONTRADO',
        '{{IBAN}}' => $funcionario_selecionado['iban'] ?? 'NÃO ENCONTRADO',
        '{{ANO_INICIO_EXT}}' => 'Mil Novecentos e ' . ($funcionario_selecionado['ano_inicio'] ?? 'XX'),
        '{{ANO_FIM_EXT}}' => 'Mil Novecentos e ' . ($funcionario_selecionado['ano_fim'] ?? 'XX'),
        '{{TOTAL_ANOS}}' => $funcionario_selecionado['total_anos'] ?? 'XX',
        '{{DATA_INICIO_COMPLETA}}' => $funcionario_selecionado['data_inicio_completa'] ?? 'NÃO ENCONTRADO',
    ];

    $documento_final = str_replace(array_keys($placeholders), array_values($placeholders), $template);

    if ($template_id === 'subsidio_morte') {
        $documento_final = str_replace(
            $doc_info['finalidade'], 
            str_replace('{{NOME}}', $funcionario_selecionado['nome'] ?? 'NÃO ENCONTRADO', $doc_info['finalidade']),
            $documento_final
        );
    }
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($nome_documento) . (isset($funcionario_selecionado['nome']) ? ' - ' . $funcionario_selecionado['nome'] : '') ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        /* ========================================================= */
        /* === 1. CONTROLE DE IMPRESSÃO A4 VERTICAL (O MAIS IMPORTANTE) === */
        /* ========================================================= */
        @page {
            size: A4 portrait; 
            margin: 2.5cm;    /* Margens oficiais */
        }
        
        body {
            font-family: 'Times New Roman', Times, serif; 
            font-size: 12pt;
            margin: 0;
            padding: 0;
            background-color: white; /* Fundo branco para impressão */
        }
        
        .print-area {
            width: 100%;
            margin: 0;
            padding: 0;
            box-shadow: none; 
            border: none;
        }

        /* ========================================================= */
        /* === 2. ESTILOS DO CONTEÚDO PARA FORMATO OFICIAL === */
        /* ========================================================= */

        /* Estilo do Parágrafo Padrão (Recuo e Justificação) */
        .declaration-content p { 
            margin-bottom: 0.5rem; 
            line-height: 1.5;     
            text-align: justify; 
            text-indent: 1.5cm;
            font-size: 12pt;
        }

        /* Estilo do Título Centralizado */
        .declaration-content .text-center {
            text-indent: 0;
            margin-bottom: 2rem !important; 
            font-size: 14pt;
        }

        /* Cabeçalho da Direcção */
        .document-header p {
            font-size: 10pt;
            margin: 0;
            padding: 0;
            text-indent: 0;
        }

        /* --- CONTROLE DE ESPAÇAMENTO DO RODAPÉ (DATA E ASSINATURA) --- */
        
        /* Data e Local */
        .footer-date {
            margin-top: 35px; /* Espaço entre o corpo final do texto e a data */
            text-align: right;
            text-indent: 0;
        }

        /* Bloco de Assinatura */
        .footer-signature {
            margin-top: 60px; /* Espaço entre a data e o início da assinatura */
            text-align: center;
        }
        
        /* Linha de Assinatura */
        .signature-line {
            margin-top: 50px; 
            margin-bottom: 2px;
            width: 250px;
            margin-left: auto;
            margin-right: auto;
            border-top: 1px solid black;
        }

        /* Garante que o nome do diretor não tenha margem superior exagerada */
        .footer-signature p {
             margin-top: 0;
             margin-bottom: 0;
             text-indent: 0;
        }

        /* Oculta apenas o que pode aparecer na tela (barra lateral/botão não existem aqui) */
        .no-print { display: none !important; }

    </style>
</head>
<body>

    <div class="print-area">
        <?php if ($documento_final): ?>
            <div class="document-header text-center mb-8">
                <div class="flex justify-center mb-4">
                    <img src="insignia/insignia.png" alt="Insígnia" class="w-16 h-auto"> 
                </div>
                <p>REPÚBLICA DE ANGOLA</p>
                <p>GOVERNO PROVINCIAL DE BENGUELA</p>
                <p class="font-semibold mb-4"><?= MUNICIPAL_EDUCACAO ?></p>
                <hr class="w-1/3 mx-auto mb-6 border-t border-black">
            </div>

            <div id="declaration-preview" class="declaration-content min-h-[500px]">
                <?= $documento_final ?>
            </div>

            <div class='footer-date'> 
                <p><?= LOCAL_DATA_FIXA . DATA_ATUAL ?></p>
            </div>
            
            <div class='footer-signature'>
                <p>O DIRECTOR MUNICIPAL</p>
                <div class="signature-line"></div> 
                <p class='font-bold'><?= DIRECTOR_NOME ?></p>
            </div>
        <?php else: ?>
            <p class="text-red-500 text-center">Erro ao carregar o documento. Verifique se o funcionário e o template foram passados corretamente.</p>
        <?php endif; ?>
    </div>
    
    <script>
        window.onload = function() {
            window.print();
            // Opcional: fechar a janela após a impressão/cancelamento
            // window.onafterprint = function() {
            //     window.close();
            // };
        };
    </script>
</body>
</html>