<?php
require('fpdf/fpdf.php');
include 'conexao.php';

// Buscar todos os alunos
$alunos = $conn->query("SELECT nome, curso, genero, idade, lp, mat, media, obs FROM novos_alunos ORDER BY nome ASC")->fetch_all(MYSQLI_ASSOC);

class PDF extends FPDF {
    function Header() {
        // Insígnia no topo (posição absoluta)
        $this->Image('insignia/insignia.png', 95, 6, 20); // Centralizado no topo (x=95 para A4 paisagem), y=6

        // Espaço abaixo da imagem
        $this->Ln(22); // pular 22 unidades após a imagem

        // Cabeçalho institucional
        $this->SetFont('Arial', 'B', 10);
        $this->Cell(0, 6, utf8_decode('REPÚBLICA DE ANGOLA'), 0, 1, 'C');
        $this->Cell(0, 6, utf8_decode('GOVERNO PROVINCIAL DE BENGUELA'), 0, 1, 'C');
        $this->Cell(0, 6, utf8_decode('GABINETE PROVINCIAL DA EDUCAÇÃO'), 0, 1, 'C');
        $this->Cell(0, 6, utf8_decode('COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK - CATUMBELA'), 0, 1, 'C');


        // Título principal
        $this->Ln(6);
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(0, 10, utf8_decode('Resultado dos Testes de Admissão'), 0, 1, 'C');

       // Tabela
$this->Ln(3);
$this->SetFont('Arial','B',9);
$this->Cell(8,8,utf8_decode('Nº'),1,0,'C');
$this->Cell(45,8,'Nome',1,0,'C');
$this->Cell(18,8,'Curso',1,0,'C');
$this->Cell(18,8,utf8_decode('Género'),1,0,'C');
$this->Cell(12,8,'Idade',1,0,'C');
$this->Cell(16,8,'L.Port',1,0,'C');
$this->Cell(16,8,'Mat',1,0,'C');
$this->Cell(16,8,utf8_decode('Média'),1,0,'C');
$this->Cell(35,8,utf8_decode('Observação'),1,1,'C');
}
}

$pdf = new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial','',9);

$n = 1;
foreach ($alunos as $a) {
    $pdf->Cell(8,8,$n++,1,0,'C');
    $pdf->Cell(45,8,utf8_decode($a['nome']),1);
    $pdf->Cell(18,8,utf8_decode($a['curso']),1,0,'C');
    $pdf->Cell(18,8,utf8_decode($a['genero']),1,0,'C');
    $pdf->Cell(12,8,$a['idade'],1,0,'C');
    $pdf->Cell(16,8,$a['lp'],1,0,'C');
    $pdf->Cell(16,8,$a['mat'],1,0,'C');
    $pdf->Cell(16,8,$a['media'],1,0,'C');
    $pdf->Cell(35,8,utf8_decode($a['obs']),1,1,'C');
}
$pdf->Output();
?>
