<?php
require('fpdf/fpdf.php');
include 'conexao.php';

if (!isset($_GET['turma_id'])) {
    die("Turma não selecionada.");
}

$turma_id = intval($_GET['turma_id']);

// Buscar dados da turma (incluindo classe e sala, se existirem)
$sqlTurma = "SELECT nome, curso, turno, classe, sala FROM turmas WHERE id = $turma_id LIMIT 1";
$resTurma = $conn->query($sqlTurma);
if ($resTurma->num_rows === 0) {
    die("Turma não encontrada.");
}
$turma = $resTurma->fetch_assoc();
$nomeTurma = $turma['nome'];
$curso     = $turma['curso'];
$turno     = $turma['turno'];
$classe    = $turma['classe'] ?? '---';
$sala      = $turma['sala'] ?? '---';

// Buscar alunos
$alunos = [];
$sqlAlunos = "SELECT nome, idade, genero FROM alunos WHERE turma_id = $turma_id ORDER BY nome";
$resAlunos = $conn->query($sqlAlunos);
while ($row = $resAlunos->fetch_assoc()) {
    $alunos[] = $row;
}

// Criar PDF
class PDF extends FPDF {
    function Header() {
        global $nomeTurma, $curso, $turno, $classe, $sala;

        // Insígnia (centralizada)
        $this->Image('insignia/insignia.png', 95, 8, 20); // ajustado para centralizar
        $this->Ln(25); // espaço após imagem

        // Cabeçalho institucional
        $this->SetFont('Arial', 'B', 10);
        $this->Cell(0, 6, utf8_decode('REPÚBLICA DE ANGOLA'), 0, 1, 'C');
        $this->Cell(0, 6, utf8_decode('GOVERNO PROVINCIAL DE BENGUELA'), 0, 1, 'C');
        $this->Cell(0, 6, utf8_decode('GABINETE PROVINCIAL DA EDUCAÇÃO'), 0, 1, 'C');
        $this->Cell(0, 6, utf8_decode('COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK - CATUMBELA'), 0, 1, 'C');

        $this->Ln(4);
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(0, 7, utf8_decode("LISTA NOMINAL DOS ALUNOS DA TURMA $nomeTurma"), 0, 1, 'C');

        $this->SetFont('Arial', '', 11);
        $this->Cell(0, 6, utf8_decode("Curso: $curso    Turno: $turno    Classe: $classe    Sala: $sala"), 0, 1, 'C');

        $this->Ln(8);

       // Cabeçalho da tabela (centralizado com 160mm total)
$this->SetX(25);
$this->SetFont('Arial', 'B', 10);
$this->SetFillColor(220, 220, 220);
$this->Cell(10, 8, utf8_decode('Nº'), 1, 0, 'C', true);
$this->Cell(60, 8, utf8_decode('Nome do Aluno'), 1, 0, 'C', true);
$this->Cell(25, 8, utf8_decode('Género'), 1, 0, 'C', true);
$this->Cell(20, 8, 'Idade', 1, 0, 'C', true);
$this->Cell(45, 8, 'Curso', 1, 1, 'C', true);

    }

    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 9);
        $this->Cell(0, 10, utf8_decode('Página ') . $this->PageNo(), 0, 0, 'C');
    }
}

// Criar e preencher o PDF
$pdf = new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial', '', 10);

$n = 1;
foreach ($alunos as $a) {
    $pdf->SetX(25); // Centraliza horizontalmente
    $pdf->Cell(10, 8, $n++, 1, 0, 'C');
    $pdf->Cell(60, 8, utf8_decode($a['nome']), 1, 0); // nome mais largo
    $pdf->Cell(25, 8, utf8_decode($a['genero']), 1, 0, 'C');
    $pdf->Cell(20, 8, $a['idade'], 1, 0, 'C');
    $pdf->Cell(45, 8, utf8_decode($curso), 1, 1, 'C'); // mesmo curso para todos
}

$pdf->Output("I", "Lista_Turma_$nomeTurma.pdf");
?>
