<?php 
include 'conexao.php';
$lista = $conn->query("SELECT nome, curso, genero, idade FROM novos_alunos ORDER BY nome ASC")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Lista Nominal dos Candidatos Inscritos</title>
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      padding: 20px;
      background: white;
    }

    .cabecalho {
      text-align: center;
      margin-bottom: 20px;
    }

    .cabecalho img {
      width: 80px;
      height: auto;
    }

    .cabecalho h1, .cabecalho h2, .cabecalho h3 {
      margin: 2px;
      padding: 0;
    }

    h2.titulo {
      text-align: center;
      color: #002244;
      margin-top: 20px;
      margin-bottom: 30px;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
      background: #fff;
    }

    th, td {
      border: 1px solid #ccc;
      padding: 8px;
      text-align: center;
    }

    th {
      background: #003366;
      color: white;
    }

    .botoes {
      margin-top: 30px;
      text-align: center;
    }

    .botoes button {
      padding: 10px 20px;
      font-size: 16px;
      margin: 0 10px;
      border: none;
      border-radius: 5px;
      cursor: pointer;
    }

    .botoes .print {
      background-color: #007bff;
      color: white;
    }

    .botoes .voltar {
      background-color: #28a745;
      color: white;
    }

    .botoes button:hover {
      opacity: 0.85;
    }

    @media print {
      .botoes {
        display: none;
      }
    }
  </style>
</head>
<body>

  <!-- Cabeçalho institucional -->
  <div class="cabecalho">
    <img src="insignia/insignia.png" alt="Insígnia da República">
    <h1>REPÚBLICA DE ANGOLA</h1>
    <h2>GOVERNO PROVINCIAL DE BENGUELA</h2>
    <h3>GABINETE PROVINCIAL DA EDUCAÇÃO</h3>
    <h4>COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK - CATUMBELA</h4>


  </div>

  <h2 class="titulo">Lista Nominal dos Candidatos Inscritos</h2>

  <!-- Tabela -->
  <table>
    <thead>
      <tr>
        <th>Nº</th>
        <th>Nome</th>
        <th>Curso</th>
        <th>Género</th>
        <th>Idade</th>
      </tr>
    </thead>
    <tbody>
      <?php $n = 1; foreach ($lista as $al): ?>
      <tr>
        <td><?= $n++ ?></td>
        <td><?= htmlspecialchars($al['nome']) ?></td>
        <td><?= htmlspecialchars($al['curso']) ?></td>
        <td><?= htmlspecialchars($al['genero']) ?></td>
        <td><?= htmlspecialchars($al['idade']) ?></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

  <!-- Botões -->
  <div class="botoes">
    <button class="print" onclick="window.print()">🖨️ Imprimir</button>
    <button class="voltar" onclick="window.location.href='painel_secretaria_geral.php'">🔙 Voltar ao Painel</button>
  </div>

</body>
</html>
