<?php
require('fpdf/fpdf.php');
include 'conexao.php';

if (!isset($_GET['turma_id'])) {
    die("Turma não especificada.");
}

$turma_id = intval($_GET['turma_id']);

// Buscar dados da turma
$stmt = $conn->prepare("SELECT nome, classe, curso, turno, sala FROM turmas WHERE id = ?");
$stmt->bind_param("i", $turma_id);
$stmt->execute();
$turma = $stmt->get_result()->fetch_assoc();

// Buscar alunos
$stmt = $conn->prepare("SELECT numero, nome, idade, genero FROM alunos WHERE turma_id = ? ORDER BY numero ASC");
$stmt->bind_param("i", $turma_id);
$stmt->execute();
$alunos = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// Criar PDF
$pdf = new FPDF();
$pdf->AddPage();

// Adicionar Insígnia (centralizada)
$pdf->Image('insignia/insignia.png', 85, 10, 40);
$pdf->Ln(45); // Espaço entre imagem e cabeçalho

// Cabeçalho oficial com fonte tamanho 12
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 7, utf8_decode("REPÚBLICA DE ANGOLA"), 0, 1, 'C');
$pdf->Cell(0, 7, utf8_decode("GOVERNO PROVINCIAL DE BENGUELA"), 0, 1, 'C');
$pdf->Cell(0, 7, utf8_decode("GABINETE PROVINCIAL DA EDUCAÇÃO"), 0, 1, 'C');
$pdf->Cell(0, 7, utf8_decode("COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK - CATUMBELA"), 0, 1, 'C');

$pdf->Ln(8); // Espaço entre cabeçalho e título

// Título com CLASSE incluída automaticamente
$pdf->SetFont('Arial', 'B', 12);
$titulo = "Lista Nominal dos Alunos da turma: " . $turma['nome'] .
          ", classe: " . $turma['classe'] .
          ", curso: " . $turma['curso'] .
          ", sala: " . $turma['sala'] .
          ", período: " . $turma['turno'];
$pdf->MultiCell(0, 8, utf8_decode($titulo), 0, 'C');

$pdf->Ln(10); // Espaço antes da tabela

// Centralizar tabela: largura total = 10 + 90 + 25 + 25 = 150
$larguraTabela = 150;
$margemEsquerda = ($pdf->GetPageWidth() - $larguraTabela) / 2;
$pdf->SetX($margemEsquerda);

// Cabeçalho da tabela
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(10, 10, utf8_decode('Nº'), 1, 0, 'C');
$pdf->Cell(90, 10, utf8_decode('Nome'), 1, 0, 'C');
$pdf->Cell(25, 10, utf8_decode('Idade'), 1, 0, 'C');
$pdf->Cell(25, 10, utf8_decode('Género'), 1, 1, 'C');

// Corpo da tabela
$pdf->SetFont('Arial', '', 12);
foreach ($alunos as $aluno) {
    $pdf->SetX($margemEsquerda);
    $pdf->Cell(10, 10, $aluno['numero'], 1, 0, 'C');
    $pdf->Cell(90, 10, utf8_decode($aluno['nome']), 1, 0, 'L');
    $pdf->Cell(25, 10, $aluno['idade'], 1, 0, 'C');
    $pdf->Cell(25, 10, utf8_decode($aluno['genero']), 1, 1, 'C');
}

// Espaço antes da assinatura
$pdf->Ln(20);

// Assinatura
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 7, utf8_decode("O Chefe da Secretaria"), 0, 1, 'R');
$pdf->Ln(18);
$pdf->Cell(0, 7, "______________________________", 0, 1, 'R');

$pdf->Output();
?>
