<?php
include 'conexao.php';
session_start();

// =====================================================================
// 🔑 CORREÇÃO 1: FORÇAR A CONEXÃO A USAR UTF-8 (para 'Inglês' funcionar)
// =====================================================================
if (isset($conn)) {
    // Usando SET NAMES é frequentemente mais robusto que set_charset()
    $conn->query("SET NAMES 'utf8mb4'"); 
}

// Configuração regional
setlocale(LC_TIME, 'pt_PT.UTF-8', 'pt_BR.UTF-8', 'portuguese');
date_default_timezone_set('Africa/Luanda');

// Buscar turmas
$turmas = $conn->query("SELECT id, classe, nome, curso, sala, turno FROM turmas")->fetch_all(MYSQLI_ASSOC);

$turma_id = $_GET['turma_id'] ?? null;

$turmaInfo = null;
$alunos = [];

if ($turma_id) {
    // Buscar dados da turma
    $stmt = $conn->prepare("SELECT classe, nome, curso, sala, turno FROM turmas WHERE id = ?");
    $stmt->bind_param("i", $turma_id);
    $stmt->execute();
    $turmaInfo = $stmt->get_result()->fetch_assoc();
    $stmt->close();

    // Buscar alunos.
    // NOTA: A busca 'a.opcao_lingua' ainda é feita, mas o valor exibido será sobrescrito no HTML.
    $query = "SELECT 
                a.id, a.nome, a.idade, a.genero, a.opcao_lingua, a.vez, a.observacoes, a.numero, a.numero_processo
              FROM alunos a
              WHERE a.turma_id = ?
              ORDER BY 
                a.nome ASC, 
                CAST(a.numero AS UNSIGNED) ASC";

    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $turma_id); 
    $stmt->execute();
    $alunos = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Alunos - SISMAG (Documento Oficial)</title>
    
<script src="html2pdf.bundle.min.js"></script>
    <style>
        /* ======== ESTILO GERAL SISMAG ======== */
        body {
            margin: 0;
            font-family: 'Segoe UI', Arial, sans-serif;
            background-color: #f2f2f2;
        }

        /* Classes para esconder elementos na impressão/PDF */
        .no-print { display: block; }
        .hide-for-pdf { display: none !important; }

        .barra-superior {
            background-color: #007bff;
            color: white;
            padding: 12px 20px;
            font-size: 18px;
            font-weight: bold;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .barra-superior img {
            height: 35px;
            margin-right: 10px;
        }

        .container {
            display: flex;
            height: calc(100vh - 59px); /* Altura ajustada para caber no viewport */
        }

        .barra-lateral {
            background-color: #001f3f;
            width: 220px;
            color: white;
            padding: 20px 10px;
            display: flex;
            flex-direction: column;
            gap: 15px;
        }

        .barra-lateral a {
            text-decoration: none;
            color: white;
            background-color: #003366;
            padding: 10px;
            border-radius: 6px;
            text-align: center;
            transition: 0.3s;
        }

        .barra-lateral a:hover {
            background-color: #0056b3;
        }

        .conteudo {
            flex: 1;
            background-color: #fff;
            padding: 20px;
            overflow-y: auto;
            border-top-left-radius: 12px;
        }

        /* ======== FILTROS ======== */
        .filtros {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            align-items: center;
            gap: 10px;
            margin-bottom: 15px;
        }

        select, input[type="number"], button {
            padding: 6px 10px;
            font-size: 14px;
            border: 1px solid #ccc;
            border-radius: 6px;
        }

        button {
            background-color: #007bff;
            color: white;
            cursor: pointer;
            border: none;
            transition: 0.3s;
        }

        button:hover {
            background-color: #0056b3;
        }

        /* ======== CABEÇALHO ESCOLA (Documento Oficial) ======== */
        .cabecalho {
            text-align: center;
            font-size: 12px;
            margin-bottom: 10px;
            border-bottom: 1px solid #ccc;
            padding-bottom: 5px;
        }
        
        /* NOVO CONTAINER para o VISTO e o cabeçalho */
        .header-container {
            position: relative; 
            padding-top: 50px; 
        }
        
        /* ESTILO DO VISTO DO DIRECTOR */
        .visto-director {
            position: absolute;
            top: 40px; 
            left: 0px; 
            width: 180px; 
            text-align: center;
            font-size: 11px;
            z-index: 10; 
            line-height: 1.3;
        }
        
        .visto-director p {
            margin: 2px 0;
            padding: 0;
        }
        
        .visto-director .assinatura-line {
            margin-top: 5px;
            border-bottom: 1px solid #333;
            height: 1px;
            width: 70%; 
            display: block;
            margin-left: auto; 
            margin-right: auto; 
        }
        
        .visto-director .data-line {
            margin-top: 5px;
            display: flex;
            justify-content: center;
            gap: 5px; 
        }

        .visto-director .data-line span {
            border-bottom: 1px solid #333;
            width: 25px; 
            display: inline-block;
            text-align: center;
        }


        .cabecalho h3, .cabecalho h4 {
            margin: 0;
            font-weight: 700;
        }
        
        .cabecalho h4 {
            font-size: 14px;
            margin-top: 5px;
        }

        .insignia {
            display: block;
            margin: 0 auto 5px auto;
            height: 70px;
        }

        /* ======== TABELA ======== */
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 14px; 
            background-color: white;
            box-shadow: 0 0 5px rgba(0,0,0,0.1);
        }

        th, td {
            border: 1px solid #ccc;
            padding: 6px;
            text-align: center;
            vertical-align: middle;
        }

        th {
            background-color: #007bff;
            color: white;
            font-weight: 700;
        }

        .col-nome {
            /* 🚀 AJUSTE PARA AUMENTAR O TAMANHO DA FONTE DO NOME NA TELA */
            font-size: 18px; /* Aumentado para 18px */
            /* ------------------------------------------------------------- */
            text-align: left;
            padding-left: 10px;
            font-weight: 600;
        }

        /* ======== ASSINATURA (Rodapé) ======== */
        .assinaturas {
            display: flex;
            justify-content: center; 
            margin-top: 40px;
            font-size: 13px;
        }

        .assinatura {
            width: auto; 
            text-align: center;
        }

        .assinatura p {
            margin: 8px 0;
        }

        .assinatura p:nth-child(2) {
            margin-top: 30px; 
        }
        
        /* ================================================================= */
        /* === MEDIA QUERY PARA IMPRESSÃO (Ajuste para 40 alunos por página) === */
        /* ================================================================= */
        @media print {
            /* 1. Ocultar todos os botões e barras de navegação */
            .no-print, .barra-superior, .barra-lateral, .filtros {
                display: none !important;
            }
            button { display: none !important; }
            
            /* 2. Ajuste de layout de página para maximizar o conteúdo */
            body {
                margin: 0;
                padding: 5mm; /* Margem mínima */
                font-size: 10pt; /* Fontes do texto do documento */
            }

            .conteudo {
                padding: 0; /* Remover padding do container de conteúdo */
                overflow: visible;
                box-shadow: none;
            }
            
            /* 3. Reduzir o tamanho da fonte da tabela para caber 40 linhas */
            table {
                font-size: 10px; 
                page-break-inside: auto;
            }
            
            /* 4. Garantir que o cabeçalho se repita em páginas longas */
            thead { display: table-header-group; }
            tr { page-break-inside: avoid; page-break-after: auto; }
            
            /* 5. Ajustar padding das células e cabeçalho */
            th, td {
                padding: 2px 4px; 
                line-height: 1.2;
            }

            /* 🚀 AJUSTE PARA MANTER O NOME MAIOR NA IMPRESSÃO */
            .col-nome {
                font-size: 12px; /* Maior que o 10px padrão da tabela, mas cabe na largura da coluna */
            }
            /* ------------------------------------------------------ */
            
            .insignia {
                height: 40px; 
            }

            .cabecalho {
                font-size: 9px;
            }

            /* AJUSTES PARA O VISTO NA IMPRESSÃO */
            .header-container {
                padding-top: 30px; 
            }
            
            .visto-director {
                font-size: 8px; 
                top: 15mm; 
                left: 0mm; 
            }

            /* Reduzir o traço do visto na impressão também */
            .visto-director .assinatura-line {
                width: 70%; 
            }

            .assinaturas {
                margin-top: 20px;
                font-size: 10px;
                justify-content: center; 
            }
        }
    </style>
</head>
<body>

<div class="barra-superior no-print">
    <div>
        <img src="insignia/insignia.png" alt="Logo">
        EMILFRICK - Sistema de Gestão Académica
    </div>
    <div class="no-print">
        <button onclick="window.location.href='painel.php'">🏠 Início</button>
    </div>
</div>

<div class="container">
    <div class="barra-lateral no-print">
        <a href="cadastrar_aluno.php">👨‍🎓 Alunos</a>
        <a href="cadastrar_turma.php">🏫 Turmas</a>
        <a href="cadastrar_disciplina_anterior.php">📘 Disciplinas</a>
        <a href="lancar_nota.php">📝 Lançar Notas</a>
        <a href="ver_lista_turma.php">📋 Listas</a>
    </div>

    <div class="conteudo">
        <h2 style="margin-bottom: 10px;" class="no-print">📋 Relação Nominal dos Alunos</h2>

        <form method="get" class="filtros no-print" id="formFiltro">
            <div>
                <label><strong>Turma:</strong></label>
                <select name="turma_id" onchange="this.form.submit()">
                    <option value="">-- Selecione --</option>
                    <?php foreach ($turmas as $turma): ?>
                        <option value="<?= $turma['id'] ?>" <?= ($turma_id == $turma['id']) ? 'selected' : '' ?>>
                            <?= "{$turma['classe']} {$turma['nome']} - {$turma['curso']} ({$turma['turno']})" ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <?php if ($turma_id): ?>
                <div>
                    <button type="button" onclick="downloadListagem()">⬇️ PDF</button>
                    <button type="button" onclick="window.print()">🖨️ Imprimir</button>
                </div>
            <?php endif; ?>
        </form>

        <?php if ($turmaInfo): ?>
            <div id="content-to-pdf">
                
                <div class="header-container">
                    
                    <div class="visto-director">
                        <p>Visto</p>
                        <p>O Director</p>
                        <div class="assinatura-line"></div>
                        <p>Eduardo Sanjambela Tchandja</p>
                        <div class="data-line">
                            <span></span>/<span></span>/<span></span>
                        </div>
                    </div>
                    
                    
                    <div class="cabecalho">
                        <img src="insignia/insignia.png" class="insignia" alt="Insígnia">
                        <h3>REPÚBLICA DE ANGOLA<br>
                        GOVERNO PROVINCIAL DE BENGUELA<br>
                        GABINETE PROVINCIAL DA EDUCAÇÃO<br>
                        COMPLEXO ESCOLAR CATÓLICO Nº 0026 BLA PADRE EMIL FRICK - CATUMBELA</h3>
                        <h4>RELAÇÃO NOMINAL DOS ALUNOS MATRICULADOS - ANO LECTIVO 2025/2026</h4>
                        <p>
                            <strong>Classe:</strong> <?= htmlspecialchars($turmaInfo['classe']) ?> |
                            <strong>Turma:</strong> <?= htmlspecialchars($turmaInfo['nome']) ?> |
                            <strong>Curso:</strong> <?= htmlspecialchars($turmaInfo['curso']) ?> |
                            <strong>Sala:</strong> <?= htmlspecialchars($turmaInfo['sala']) ?> |
                            <strong>Turno:</strong> <?= htmlspecialchars($turmaInfo['turno']) ?>
                        </p>
                    </div>
                </div> 

                <table>
                    <thead>
                        <tr>
                            <th>Nº</th>
                            <th>Nº Proc.</th>
                            <th>Nome Completo do Aluno(a)</th>
                            <th>Idade</th>
                            <th>Gén</th>
                            <th>Opção</th>
                            <th>Vez</th>
                            <th>Observações</th>
                            <th class="no-print">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        // INICIALIZAÇÃO DO CONTADOR OFICIAL PARA A LISTA SEQUENCIAL
                        $ordem_counter = 1;
                        foreach ($alunos as $a): 
                        ?>
                        <tr >
                            <td><?= $ordem_counter ?></td>
                            <td><?= htmlspecialchars($a['numero_processo'] ?? '-') ?></td>
                            <td class="col-nome"><?= htmlspecialchars($a['nome']) ?></td>
                            
                            <td><?= htmlspecialchars($a['idade']) ?></td>
                            <td><?= htmlspecialchars($a['genero'] == 'Masculino' ? 'M' : 'F') ?></td>
                            
                            <td><?= htmlspecialchars('Inglês') ?></td>
                            
                            <td><?= htmlspecialchars($a['vez'] ?? '-') ?></td>
                            
                            <td><?= htmlspecialchars(utf8_decode($a['observacoes'] ?? '-')) ?></td>
                            
                            <td class="no-print">
                                <button onclick="removerAluno(<?= $a['id'] ?>, '<?= addslashes($a['nome']) ?>', <?= $turma_id ?>)">Remover</button>
                            </td>
                        </tr>
                        <?php 
                            // INCREMENTA O CONTADOR PARA O PRÓXIMO ALUNO
                            $ordem_counter++;
                        endforeach; ?>
                    </tbody>
                </table>

                <div class="assinaturas">
                    <div class="assinatura" style="width: auto;">
                        <p>Catumbela, <?= strftime('%d de %B de %Y') ?></p>
                        <p><strong>O SUBDIRECTOR PEDAGÓGICO EM EXERCÍCIO</strong></p>
                        <p>______________________________________________________</p>
                        <p><strong></strong></p>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
// Função para download em PDF, garantindo que a coluna Ações esteja oculta
function downloadListagem() {
    const controls = document.querySelectorAll('.no-print');
    
    // Oculta todos os elementos 'no-print' antes de gerar o PDF
    controls.forEach(el => el.classList.add('hide-for-pdf'));

    const element = document.getElementById('content-to-pdf');
    const turma = "<?= htmlspecialchars($turmaInfo['nome'] ?? '') ?>";
    const classe = "<?= htmlspecialchars($turmaInfo['classe'] ?? '') ?>";
    const curso = "<?= htmlspecialchars($turmaInfo['curso'] ?? '') ?>";
    const filename = `Relacao_Nominal_${classe}_${turma}_${curso}.pdf`.replace(/ /g, '_');

    // Configurações do html2pdf para documento A4
    html2pdf(element, {
        margin: [5, 5, 5, 5], // Margem em mm (Topo, Direita, Baixo, Esquerda)
        filename: filename,
        image: { type: 'jpeg', quality: 0.98 },
        html2canvas: { scale: 2, dpi: 192, letterRendering: true },
        jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' }
    }).then(() => {
        // Mostra novamente os elementos 'no-print' após gerar o PDF
        controls.forEach(el => el.classList.remove('hide-for-pdf'));
    });
}

function removerAluno(alunoId, alunoNome, turmaId) {
    if (confirm("Tem certeza que deseja remover o aluno '" + alunoNome + "'?")) {
        // Certifique-se de ter um script 'remover_aluno.php' que lide com a exclusão
        window.location.href = "remover_aluno.php?aluno_id=" + alunoId + "&turma_id=" + turmaId;
    }
}
</script>

</body>
</html>