<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Lista dos Novos Alunos</title>
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #f2f2f2;
      padding: 20px;
    }
    .container {
      max-width: 100%;
      background-color: #fff;
      padding: 30px;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    h2 {
      text-align: center;
      margin-bottom: 20px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-bottom: 20px;
    }
    th, td {
      border: 1px solid #ccc;
      padding: 10px;
      text-align: left;
    }
    th {
      background-color: #eee;
    }
    .btn {
      padding: 10px 15px;
      margin: 5px;
      background-color: #666;
      color: white;
      border: none;
      border-radius: 6px;
      font-weight: bold;
      cursor: pointer;
    }
    .btn:hover {
      background-color: #4d4d4d;
    }
    .vermelho {
      color: red;
      font-weight: bold;
    }
  </style>
  <script>
    function atribuirNotas() {
      const cabecalho = document.getElementById('cabecalho');
      const linhas = document.querySelectorAll('.linha-aluno');

      ['L.Port', 'Matemática', 'Média', 'Observação'].forEach(titulo => {
        const th = document.createElement('th');
        th.innerText = titulo;
        cabecalho.appendChild(th);
      });

      linhas.forEach(linha => {
        for (let i = 0; i < 2; i++) {
          const td = document.createElement('td');
          const input = document.createElement('input');
          input.type = 'number';
          input.min = '0';
          input.max = '20';
          input.step = '0.01';
          input.onchange = () => calcularMedia(linha);
          td.appendChild(input);
          linha.appendChild(td);
        }
        const tdMedia = document.createElement('td');
        tdMedia.className = 'media';
        linha.appendChild(tdMedia);

        const tdObs = document.createElement('td');
        tdObs.className = 'observacao';
        linha.appendChild(tdObs);
      });

      document.getElementById('atribuir-btn').disabled = true;
    }

    function calcularMedia(linha) {
      const inputs = linha.querySelectorAll('input');
      const nota1 = parseFloat(inputs[0].value) || 0;
      const nota2 = parseFloat(inputs[1].value) || 0;
      const media = ((nota1 + nota2) / 2).toFixed(1);
      const mediaTd = linha.querySelector('.media');
      const obsTd = linha.querySelector('.observacao');
      mediaTd.innerText = media;
      if (media >= 10) {
        obsTd.innerText = 'Admitido';
        obsTd.classList.remove('vermelho');
      } else {
        obsTd.innerText = 'Não Admitido';
        obsTd.classList.add('vermelho');
      }
    }
  </script>
</head>
<body>
  <div class="container">
    <h2>Lista dos Novos Alunos</h2>
    <table>
      <thead>
        <tr id="cabecalho">
          <th>Nº</th>
          <th>Nome</th>
          <th>Idade</th>
          <th>Género</th>
          <th>Curso</th>
        </tr>
      </thead>
      <tbody>
        <?php
          include 'conexao.php';
          $sql = "SELECT * FROM novos_alunos ORDER BY nome ASC";
          $result = $conexao->query($sql);
          $contador = 1;
          if ($result->num_rows > 0) {
            while ($linha = $result->fetch_assoc()) {
              echo "<tr class='linha-aluno'>";
              echo "<td>" . $contador++ . "</td>";
              echo "<td>" . htmlspecialchars($linha['nome']) . "</td>";
              echo "<td>" . htmlspecialchars($linha['idade']) . "</td>";
              echo "<td>" . htmlspecialchars($linha['genero']) . "</td>";
              echo "<td>" . htmlspecialchars($linha['curso']) . "</td>";
              echo "</tr>";
            }
          } else {
            echo "<tr><td colspan='5'>Nenhum aluno cadastrado.</td></tr>";
          }
        ?>
      </tbody>
    </table>

    <button class="btn" onclick="window.print()">Imprimir PDF</button>
    <button class="btn" onclick="location.href='painel.php'">Início</button>
    <button class="btn" id="atribuir-btn" onclick="atribuirNotas()">Atribuir Nota</button>
    <button class="btn">Imprimir Admitidos</button>
    <button class="btn">Criar Turmas Admitidos</button>
  </div>
</body>
</html>
