<?php
include 'conexao.php'; // Conexão com o banco de dados

// 1. AJUSTE NA QUERY: Adicionar a coluna 'id' (ou o nome da sua coluna de ID)
$sql = "SELECT id_funcionario, nome FROM usuarios ORDER BY nome ASC";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
<meta charset="UTF-8">
<title>Lista de Funcionários</title>
<style>
body { font-family: Arial, sans-serif; background-color: #f4f4f4; padding: 20px; }
.btn-imprimir { display: block; margin: 0 auto 20px auto; padding: 10px 20px; background-color: #28a745; color: #fff; font-weight: bold; border: none; border-radius: 5px; cursor: pointer; font-size: 14px; }
.btn-imprimir:hover { background-color: #218838; }
table { border-collapse: collapse; width: 80%; margin: 0 auto; background-color: #fff; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
th, td { padding: 12px 15px; text-align: left; }
th { background-color: #007BFF; color: white; font-size: 14px; }
tr:nth-child(even) { background-color: #f9f9f9; }
tr:hover { background-color: #e6f2ff; }
caption { caption-side: top; text-align: center; padding: 10px; font-size: 18px; font-weight: bold; }
@media print { body { background-color: #fff; padding: 0; } .btn-imprimir { display: none; } table { width: 100%; box-shadow: none; page-break-inside: avoid; } th, td { font-size: 12px; padding: 8px 10px; } }
</style>
</head>
<body>

<button class="btn-imprimir" onclick="window.print()">🖨 Imprimir A4</button>

<table>
<caption>Lista de Funcionários</caption>
<tr>
<th>ID Funcionário</th>
<th>Nome do Funcionário</th>
</tr>

<?php
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        
        // 2. USO DIRETO DO ID DO BANCO DE DADOS
        $idFuncionario = htmlspecialchars($row['id_funcionario']); 
        $nomeFuncionario = htmlspecialchars($row['nome']);

        echo "<tr>";
        // AQUI USAMOS O VALOR RETORNADO PELA QUERY
        echo "<td>{$idFuncionario}</td>"; 
        echo "<td>{$nomeFuncionario}</td>";
        echo "</tr>";
    }
} else {
    echo "<tr><td colspan='2' style='text-align:center;'>Nenhum funcionário encontrado.</td></tr>";
}
$conn->close();
?>

</table>

</body>
</html>