<?php
session_start();
require_once __DIR__ . '/conexao.php';

// 1. Verificação de Permissão de Acesso
if (!isset($_SESSION['usuario']['id']) || $_SESSION['usuario']['perfil'] !== 'SUBDIRECÇÃO PEDAGÓGICA') {
    die('Acesso não autorizado. Apenas a Subdireção Pedagógica pode aceder a este painel.');
}

$success_message = '';
$error_message = '';

// 2. Lógica para buscar as planificações
$stmt = $conn->prepare("SELECT 
    p.id, p.ano_lectivo, p.classe, p.disciplina, p.mes, p.data_planificacao, u.nome AS nome_professor
    FROM planificacoes_mensais p
    JOIN usuarios u ON p.usuario_id = u.id
    ORDER BY p.data_planificacao DESC");
$stmt->execute();
$result = $stmt->get_result();

?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Painel da Subdireção Pedagógica</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body { font-family: 'Segoe UI', sans-serif; margin: 20px; background: #f5f5f5; color: #222; }
        .container { max-width: 1200px; margin: auto; padding: 20px; background: #fff; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        h1 { text-align: center; color: #007BFF; }
        .message { padding: 10px; margin-bottom: 20px; border-radius: 5px; }
        .message.success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .message.error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        table, th, td { border: 1px solid #ddd; }
        th, td { padding: 12px; text-align: left; }
        th { background-color: #f2f2f2; }
        tr:nth-child(even) { background-color: #f9f9f9; }
        a.btn-visualizar {
            display: inline-block;
            padding: 8px 12px;
            background-color: #007BFF;
            color: white;
            text-decoration: none;
            border-radius: 4px;
        }
        a.btn-visualizar:hover { background-color: #0056b3; }
    </style>
</head>
<body>

<div class="container">
    <h1>Painel de Planificações Mensais</h1>

    <?php if ($success_message): ?>
    <div class="message success"><?= htmlspecialchars($success_message) ?></div>
    <?php endif; ?>
    <?php if ($error_message): ?>
    <div class="message error"><?= htmlspecialchars($error_message) ?></div>
    <?php endif; ?>

    <?php if ($result->num_rows > 0): ?>
    <table>
        <thead>
            <tr>
                <th>Professor</th>
                <th>Disciplina</th>
                <th>Classe</th>
                <th>Mês</th>
                <th>Data de Submissão</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?= htmlspecialchars($row['nome_professor']) ?></td>
                <td><?= htmlspecialchars($row['disciplina']) ?></td>
                <td><?= htmlspecialchars($row['classe']) ?></td>
                <td><?= htmlspecialchars($row['mes']) ?></td>
                <td><?= htmlspecialchars($row['data_planificacao']) ?></td>
                <td>
                    <a href="visualizar_planificacao.php?id=<?= htmlspecialchars($row['id']) ?>" class="btn-visualizar">Visualizar</a>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
    <?php else: ?>
    <p>Nenhuma planificação mensal encontrada.</p>
    <?php endif; ?>

</div>

</body>
</html>