<?php
session_start();
include 'conexao.php';

// Apenas administradores podem acessar esta página para ver a lista de professores e simular.
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'SUBDIRECÇÃO PEDAGÓGICA') {
    header("Location: login.php");
    exit;
}

// 1. Consulta para buscar todos os professores (ou usuários com perfil 'PROFESSOR')
$query = "SELECT id, nome, perfil FROM usuarios WHERE perfil = 'PROFESSOR' ORDER BY nome";
$result = $conn->query($query);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Lista de Professores</title>
    </head>
<body>
    <h1>Professores Cadastrados</h1>
    <table>
        <thead>
            <tr>
                <th>Nome</th>
                <th>Perfil</th>
                <th>Ação</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($professor = $result->fetch_assoc()): ?>
            <tr>
                <td><?= htmlspecialchars($professor['nome']) ?></td>
                <td><?= htmlspecialchars($professor['perfil']) ?></td>
                <td>
                    <a href="simular_acesso.php?target_id=<?= $professor['id'] ?>" 
                       onclick="return confirm('Tem certeza que deseja acessar o painel de <?= htmlspecialchars($professor['nome']) ?>?');">
                        Acessar Painel (Sem Senha)
                    </a>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</body>
</html>
<?php $conn->close(); ?>