<?php
session_start();
include 'conexao.php';

// Buscar todas as turmas distintas com curso
$grupos = $conn->query("
    SELECT DISTINCT curso, turma 
    FROM novos_alunos 
    WHERE obs = 'Admitido' AND turma IS NOT NULL 
    ORDER BY curso, turma
")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Turmas Organizadas - SISMAG</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="adminlte/plugins/fontawesome-free/css/all.min.css">
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background: #f0f2f5;
      padding: 20px;
    }
    h1 {
      text-align: center;
      color: #003366;
      margin-bottom: 30px;
    }
    h3 {
      margin-top: 40px;
      background: #003366;
      color: white;
      padding: 10px;
      border-radius: 6px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      background: white;
      margin-bottom: 30px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    th, td {
      border: 1px solid #ccc;
      padding: 10px;
      text-align: center;
    }
    th {
      background: #007bff;
      color: white;
    }
    td.nome {
      text-align: left;
    }
    .topbar {
      background: #1877f2;
      height: 60px;
      color: white;
      line-height: 60px;
      padding-left: 20px;
      font-weight: bold;
      font-size: 18px;
      margin-bottom: 20px;
    }
    .btn-voltar {
      display: inline-block;
      background: #007bff;
      color: white;
      padding: 10px 20px;
      text-decoration: none;
      border-radius: 6px;
      margin-bottom: 20px;
    }
    .btn-voltar:hover {
      background: #0056b3;
    }
  </style>
</head>
<body>

<div class="topbar">
  <i class="fas fa-users"></i> Lista das Turmas Organizadas
</div>

<a href="painel.php" class="btn-voltar"><i class="fas fa-arrow-left"></i> Voltar ao Painel</a>

<h1>Alunos Distribuídos por Turmas</h1>

<?php
if (count($grupos) === 0) {
    echo "<p>Nenhuma turma foi ainda atribuída.</p>";
} else {
    foreach ($grupos as $grupo) {
        $curso = $grupo['curso'];
        $turma = $grupo['turma'];

        // Buscar alunos dessa turma
        $stmt = $conn->prepare("
            SELECT nome, idade, genero 
            FROM novos_alunos 
            WHERE curso = ? AND turma = ? AND obs = 'Admitido'
            ORDER BY nome ASC
        ");
        $stmt->bind_param("ss", $curso, $turma);
        $stmt->execute();
        $alunos = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
        $stmt->close();

        echo "<h3>Curso: <strong>$curso</strong> | Turma: <strong>$turma</strong></h3>";
        echo "<table>
                <thead>
                  <tr>
                    <th>Nº</th>
                    <th>Nome</th>
                    <th>Idade</th>
                    <th>Género</th>
                  </tr>
                </thead>
                <tbody>";

        $n = 1;
        foreach ($alunos as $aluno) {
            echo "<tr>
                    <td>$n</td>
                    <td class='nome'>" . htmlspecialchars($aluno['nome']) . "</td>
                    <td>{$aluno['idade']}</td>
                    <td>{$aluno['genero']}</td>
                  </tr>";
            $n++;
        }

        echo "</tbody></table>";
    }
}
?>

</body>
</html>
